/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.DeleteAction;
import org.openstreetmap.josm.actions.mapmode.DrawAction;
import org.openstreetmap.josm.actions.mapmode.ExtrudeAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.actions.mapmode.ZoomAction;
import org.openstreetmap.josm.gui.FileDrop;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MapStatus;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.ScrollViewport;
import org.openstreetmap.josm.gui.dialogs.ChangesetDialog;
import org.openstreetmap.josm.gui.dialogs.CommandStackDialog;
import org.openstreetmap.josm.gui.dialogs.ConflictDialog;
import org.openstreetmap.josm.gui.dialogs.DialogsPanel;
import org.openstreetmap.josm.gui.dialogs.FilterDialog;
import org.openstreetmap.josm.gui.dialogs.HistoryDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.MapPaintDialog;
import org.openstreetmap.josm.gui.dialogs.RelationListDialog;
import org.openstreetmap.josm.gui.dialogs.SelectionListDialog;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.UserListDialog;
import org.openstreetmap.josm.gui.dialogs.ValidatorDialog;
import org.openstreetmap.josm.gui.dialogs.properties.PropertiesDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapFrame
extends JPanel
implements Destroyable,
MapView.LayerChangeListener {
    public MapMode mapMode;
    private final List<MapMode> mapModes = new ArrayList<MapMode>();
    public MapView mapView;
    private JToolBar toolBarActions = new JToolBar(1);
    private JToolBar toolBarToggle = new JToolBar(1);
    public MapStatus statusLine;
    public ConflictDialog conflictDialog;
    public FilterDialog filterDialog;
    public RelationListDialog relationListDialog;
    public ValidatorDialog validatorDialog;
    public SelectionListDialog selectionListDialog;
    private List<ToggleDialog> allDialogs = new ArrayList<ToggleDialog>();
    private final DialogsPanel dialogsPanel;
    public final ButtonGroup toolGroup = new ButtonGroup();
    public final JButton otherButton = new JButton(new OtherButtonsAction());
    public static final int DEF_TOGGLE_DLG_WIDTH = 330;
    private final Map<Layer, MapMode> lastMapMode = new HashMap<Layer, MapMode>();
    private static final CopyOnWriteArrayList<MapModeChangeListener> mapModeChangeListeners = new CopyOnWriteArrayList();

    public MapFrame(JPanel jPanel) {
        this.setSize(400, 400);
        this.setLayout(new BorderLayout());
        this.mapView = new MapView(jPanel);
        new FileDrop(this.mapView);
        Main.main.menu.viewMenu.setVisible(true);
        this.toolBarActions.setFloatable(false);
        this.addMapMode(new IconToggleButton(new SelectAction(this)));
        this.addMapMode(new IconToggleButton(new DrawAction(this)));
        this.addMapMode(new IconToggleButton(new ExtrudeAction(this)));
        this.addMapMode(new IconToggleButton(new ZoomAction(this)));
        this.addMapMode(new IconToggleButton(new DeleteAction(this)));
        this.toolGroup.setSelected(((AbstractButton)this.toolBarActions.getComponent(0)).getModel(), true);
        JSplitPane jSplitPane = new JSplitPane(1, true);
        this.dialogsPanel = new DialogsPanel(jSplitPane);
        jSplitPane.setLeftComponent(this.mapView);
        jSplitPane.setRightComponent(this.dialogsPanel);
        jSplitPane.setResizeWeight(1.0);
        jSplitPane.setDividerSize(5);
        jSplitPane.setBorder(null);
        jSplitPane.setUI(new BasicSplitPaneUI(){

            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    public void setBorder(Border border) {
                    }
                };
            }
        });
        jSplitPane.getInputMap(1).put(KeyStroke.getKeyStroke(117, 0), new Object());
        jSplitPane.getInputMap(1).put(KeyStroke.getKeyStroke(119, 0), new Object());
        this.add((Component)jSplitPane, "Center");
        this.dialogsPanel.setLayout(new BoxLayout(this.dialogsPanel, 1));
        this.dialogsPanel.setPreferredSize(new Dimension(Main.pref.getInteger("toggleDialogs.width", 330), 0));
        this.dialogsPanel.setMinimumSize(new Dimension(24, 0));
        this.mapView.setMinimumSize(new Dimension(10, 0));
        this.toolBarToggle.setFloatable(false);
        LayerListDialog.createInstance(this);
        this.addToggleDialog(LayerListDialog.getInstance());
        this.addToggleDialog(new PropertiesDialog(this));
        this.selectionListDialog = new SelectionListDialog();
        this.addToggleDialog(this.selectionListDialog);
        this.relationListDialog = new RelationListDialog();
        this.addToggleDialog(this.relationListDialog);
        this.addToggleDialog(new CommandStackDialog(this));
        this.addToggleDialog(new UserListDialog());
        this.addToggleDialog(new HistoryDialog());
        this.conflictDialog = new ConflictDialog();
        this.addToggleDialog(this.conflictDialog);
        this.validatorDialog = new ValidatorDialog();
        this.addToggleDialog(this.validatorDialog);
        this.filterDialog = new FilterDialog();
        this.addToggleDialog(this.filterDialog);
        this.addToggleDialog(new ChangesetDialog(this));
        this.addToggleDialog(new MapPaintDialog());
        this.statusLine = new MapStatus(this);
        MapView.addLayerChangeListener(this);
    }

    public void selectSelectTool(boolean bl) {
        if (bl && !Main.pref.getBoolean("modeless", false)) {
            return;
        }
        this.selectMapMode((MapMode)this.getDefaultButtonAction());
    }

    public void selectDrawTool(boolean bl) {
        if (bl && !Main.pref.getBoolean("modeless", false)) {
            return;
        }
        Action action = ((AbstractButton)this.toolBarActions.getComponent(1)).getAction();
        this.selectMapMode((MapMode)action);
    }

    @Override
    public void destroy() {
        int n;
        MapView.removeLayerChangeListener(this);
        this.dialogsPanel.destroy();
        for (n = 0; n < this.toolBarActions.getComponentCount(); ++n) {
            if (!(this.toolBarActions.getComponent(n) instanceof Destroyable)) continue;
            ((Destroyable)((Object)this.toolBarActions.getComponent(n))).destroy();
        }
        for (n = 0; n < this.toolBarToggle.getComponentCount(); ++n) {
            if (!(this.toolBarToggle.getComponent(n) instanceof Destroyable)) continue;
            ((Destroyable)((Object)this.toolBarToggle.getComponent(n))).destroy();
        }
        Main.main.menu.viewMenu.setVisible(false);
        if (this.statusLine.thread != null) {
            try {
                this.statusLine.thread.interrupt();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.mapView.destroy();
    }

    public Action getDefaultButtonAction() {
        return ((AbstractButton)this.toolBarActions.getComponent(0)).getAction();
    }

    public void initializeDialogsPane() {
        this.dialogsPanel.initialize(this.allDialogs);
    }

    public IconToggleButton addToggleDialog(final ToggleDialog toggleDialog) {
        IconToggleButton iconToggleButton = new IconToggleButton(toggleDialog.getToggleAction());
        this.toolBarToggle.add(iconToggleButton);
        iconToggleButton.addMouseListener(new PopupMenuLauncher(new JPopupMenu(){
            {
                this.add(new AbstractAction(){
                    {
                        this.putValue("Name", I18n.tr("Hide this button"));
                        this.putValue("ShortDescription", I18n.tr("Click the arrow at the bottom to show it again."));
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        toggleDialog.hideButton();
                    }
                });
            }
        }));
        toggleDialog.setButton(iconToggleButton);
        this.allDialogs.add(toggleDialog);
        if (this.dialogsPanel.initialized) {
            this.dialogsPanel.add(toggleDialog);
        }
        return iconToggleButton;
    }

    public void addMapMode(IconToggleButton iconToggleButton) {
        this.toolBarActions.add(iconToggleButton);
        this.toolGroup.add(iconToggleButton);
        if (!(iconToggleButton.getAction() instanceof MapMode)) {
            throw new IllegalArgumentException("MapMode action must be subclass of MapMode");
        }
        this.mapModes.add((MapMode)iconToggleButton.getAction());
    }

    @Override
    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        super.setVisible(bl);
        if (bl2 != bl) {
            this.firePropertyChange("visible", bl2, bl);
        }
    }

    public void selectMapMode(MapMode mapMode) {
        MapMode mapMode2 = this.mapMode;
        if (mapMode == mapMode2) {
            return;
        }
        if (mapMode2 != null) {
            mapMode2.exitMode();
        }
        this.mapMode = mapMode;
        mapMode.enterMode();
        this.lastMapMode.put(this.mapView.getActiveLayer(), mapMode);
        MapFrame.fireMapModeChanged(mapMode2, mapMode);
    }

    public void fillPanel(Container container) {
        container.add((Component)this, "Center");
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        this.toolBarActions.setAlignmentX(0.5f);
        jToolBar.add(this.toolBarActions);
        jToolBar.addSeparator(new Dimension(0, 18));
        this.toolBarToggle.setAlignmentX(0.5f);
        jToolBar.add(this.toolBarToggle);
        this.otherButton.setAlignmentX(0.5f);
        this.otherButton.setBorder(null);
        this.otherButton.setFont(this.otherButton.getFont().deriveFont(0));
        jToolBar.add(this.otherButton);
        if (Main.pref.getBoolean("sidetoolbar.visible", true)) {
            if (Main.pref.getBoolean("sidetoolbar.scrollable", true)) {
                final ScrollViewport scrollViewport = new ScrollViewport(jToolBar, 3);
                container.add((Component)scrollViewport, "West");
                jToolBar.addMouseWheelListener(new MouseWheelListener(){

                    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                        scrollViewport.scroll(0, mouseWheelEvent.getUnitsToScroll() * 5);
                    }
                });
            } else {
                container.add((Component)jToolBar, "West");
            }
        }
        if (this.statusLine != null && Main.pref.getBoolean("statusline.visible", true)) {
            container.add((Component)this.statusLine, "South");
        }
    }

    public <T> T getToggleDialog(Class<T> clazz) {
        return this.dialogsPanel.getToggleDialog(clazz);
    }

    public int getToggleDlgWidth() {
        return this.dialogsPanel.getWidth();
    }

    public static void addMapModeChangeListener(MapModeChangeListener mapModeChangeListener) {
        if (mapModeChangeListener != null) {
            mapModeChangeListeners.addIfAbsent(mapModeChangeListener);
        }
    }

    public static void removeMapModeChangeListener(MapModeChangeListener mapModeChangeListener) {
        mapModeChangeListeners.remove(mapModeChangeListener);
    }

    protected static void fireMapModeChanged(MapMode mapMode, MapMode mapMode2) {
        for (MapModeChangeListener mapModeChangeListener : mapModeChangeListeners) {
            mapModeChangeListener.mapModeChange(mapMode, mapMode2);
        }
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        boolean bl = false;
        if (this.mapMode == null || !this.mapMode.layerIsSupported(layer2)) {
            MapMode mapMode = this.lastMapMode.get(layer2);
            boolean bl2 = bl = mapMode != this.mapMode;
            if (mapMode != null) {
                this.selectMapMode(mapMode);
            }
        }
        if (!bl && this.mapMode != null) {
            this.mapMode.exitMode();
            this.mapMode.enterMode();
        }
        Main.map.mapView.preferenceChanged(null);
    }

    @Override
    public void layerAdded(Layer layer) {
    }

    @Override
    public void layerRemoved(Layer layer) {
        this.lastMapMode.remove(layer);
    }

    public static interface MapModeChangeListener {
        public void mapModeChange(MapMode var1, MapMode var2);
    }

    class OtherButtonsAction
    extends AbstractAction {
        public OtherButtonsAction() {
            this.putValue("Name", ">>");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            for (final ToggleDialog toggleDialog : MapFrame.this.allDialogs) {
                jPopupMenu.add(new JCheckBoxMenuItem(new AbstractAction(){
                    {
                        this.putValue("Name", toggleDialog.getToggleAction().getValue("Name"));
                        this.putValue("SmallIcon", toggleDialog.getToggleAction().getValue("SmallIcon"));
                        this.putValue("SwingSelectedKey", !toggleDialog.isButtonHidden());
                        this.putValue("ShortDescription", I18n.tr("Hide or show this toggle button"));
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (((Boolean)this.getValue("SwingSelectedKey")).booleanValue()) {
                            toggleDialog.showButton();
                        } else {
                            toggleDialog.hideButton();
                        }
                    }
                }));
            }
            Rectangle rectangle = MapFrame.this.otherButton.getBounds();
            jPopupMenu.show(MapFrame.this.otherButton, rectangle.x + rectangle.width, 0);
        }
    }
}

