/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserListDialog
extends ToggleDialog
implements SelectionChangedListener,
MapView.LayerChangeListener {
    private JTable userTable;
    private UserTableModel model;
    private SelectUsersPrimitivesAction selectionUsersPrimitivesAction;
    private ShowUserInfoAction showUserInfoAction;
    private LoadRelicensingInformationAction loadRelicensingInformationAction;

    public UserListDialog() {
        super(I18n.tr("Authors"), "userlist", I18n.tr("Open a list of people working on the selected objects."), Shortcut.registerShortcut("subwindow:authors", I18n.tr("Toggle: {0}", I18n.tr("Authors")), 65, 4, 1), 150);
        this.build();
    }

    @Override
    public void showNotify() {
        DataSet.addSelectionListener(this);
        MapView.addLayerChangeListener(this);
    }

    @Override
    public void hideNotify() {
        MapView.removeLayerChangeListener(this);
        DataSet.removeSelectionListener(this);
    }

    protected JPanel buildButtonRow() {
        JPanel jPanel = this.getButtonPanel(2);
        this.selectionUsersPrimitivesAction = new SelectUsersPrimitivesAction();
        this.userTable.getSelectionModel().addListSelectionListener(this.selectionUsersPrimitivesAction);
        jPanel.add(new SideButton(this.selectionUsersPrimitivesAction));
        this.showUserInfoAction = new ShowUserInfoAction();
        this.userTable.getSelectionModel().addListSelectionListener(this.showUserInfoAction);
        jPanel.add(new SideButton(this.showUserInfoAction));
        this.loadRelicensingInformationAction = new LoadRelicensingInformationAction();
        jPanel.add(new SideButton(this.loadRelicensingInformationAction));
        return jPanel;
    }

    protected void build() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.model = new UserTableModel();
        this.userTable = new JTable(this.model);
        this.userTable.setSelectionMode(2);
        TableColumnModel tableColumnModel = this.userTable.getColumnModel();
        tableColumnModel.getColumn(3).setPreferredWidth(20);
        tableColumnModel.getColumn(3).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setIcon((ImageIcon)object);
                jLabel.setText("");
                return jLabel;
            }
        });
        jPanel.add((Component)new JScrollPane(this.userTable), "Center");
        jPanel.add((Component)this.buildButtonRow(), "South");
        this.userTable.addMouseListener(new DoubleClickAdapter());
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        this.refresh(collection);
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        if (layer2 instanceof OsmDataLayer) {
            this.refresh(((OsmDataLayer)layer2).data.getSelected());
        } else {
            this.refresh(null);
        }
    }

    @Override
    public void layerAdded(Layer layer) {
    }

    @Override
    public void layerRemoved(Layer layer) {
    }

    public void refresh(Collection<? extends OsmPrimitive> collection) {
        this.model.populate(collection);
        if (this.model.getRowCount() != 0) {
            this.setTitle(I18n.trn("{0} Author", "{0} Authors", this.model.getRowCount(), this.model.getRowCount()));
        } else {
            this.setTitle(I18n.tr("Authors"));
        }
    }

    @Override
    public void showDialog() {
        super.showDialog();
        Layer layer = Main.main.getActiveLayer();
        if (layer instanceof OsmDataLayer) {
            this.refresh(((OsmDataLayer)layer).data.getSelected());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UserTableModel
    extends DefaultTableModel {
        private ArrayList<UserInfo> data;
        private ImageIcon greenCheckmark;

        public UserTableModel() {
            this.setColumnIdentifiers(new String[]{I18n.tr("Author"), I18n.tr("# Objects"), "%", I18n.tr("CT")});
            this.data = new ArrayList();
            this.greenCheckmark = ImageProvider.get("misc", "green_check.png");
        }

        protected Map<User, Integer> computeStatistics(Collection<? extends OsmPrimitive> collection) {
            HashMap<User, Integer> hashMap = new HashMap<User, Integer>();
            if (collection == null || collection.isEmpty()) {
                return hashMap;
            }
            for (OsmPrimitive osmPrimitive : collection) {
                if (hashMap.containsKey(osmPrimitive.getUser())) {
                    hashMap.put(osmPrimitive.getUser(), hashMap.get(osmPrimitive.getUser()) + 1);
                    continue;
                }
                hashMap.put(osmPrimitive.getUser(), 1);
            }
            return hashMap;
        }

        public void populate(Collection<? extends OsmPrimitive> collection) {
            Map<User, Integer> map = this.computeStatistics(collection);
            this.data.clear();
            if (collection != null) {
                for (Map.Entry<User, Integer> entry : map.entrySet()) {
                    this.data.add(new UserInfo(entry.getKey(), entry.getValue(), (double)entry.getValue().intValue() / (double)collection.size()));
                }
            }
            Collections.sort(this.data);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            UserInfo userInfo = this.data.get(n);
            switch (n2) {
                case 0: {
                    return userInfo.getName() == null ? "" : userInfo.getName();
                }
                case 1: {
                    return userInfo.count;
                }
                case 2: {
                    return NumberFormat.getPercentInstance().format(userInfo.percent);
                }
                case 3: {
                    if (userInfo.getRelicensingStatus() == 1) {
                        return this.greenCheckmark;
                    }
                    if (userInfo.getRelicensingStatus() == 3) {
                        return this.greenCheckmark;
                    }
                    return null;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void selectPrimitivesOwnedBy(int[] nArray) {
            HashSet<User> hashSet = new HashSet<User>();
            for (int n : nArray) {
                hashSet.add(this.data.get((int)n).user);
            }
            Object object = Main.main.getCurrentDataSet().getSelected();
            LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                OsmPrimitive osmPrimitive = (OsmPrimitive)iterator.next();
                if (!hashSet.contains(osmPrimitive.getUser())) continue;
                linkedList.add(osmPrimitive);
            }
            Main.main.getCurrentDataSet().setSelected(linkedList);
        }

        public List<User> getSelectedUsers(int[] nArray) {
            LinkedList<User> linkedList = new LinkedList<User>();
            if (nArray == null || nArray.length == 0) {
                return linkedList;
            }
            for (int n : nArray) {
                if (this.data.get((int)n).user == null) continue;
                linkedList.add(this.data.get((int)n).user);
            }
            return linkedList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserInfo
    implements Comparable<UserInfo> {
        public User user;
        public int count;
        public double percent;

        UserInfo(User user, int n, double d) {
            this.user = user;
            this.count = n;
            this.percent = d;
        }

        @Override
        public int compareTo(UserInfo userInfo) {
            if (this.count < userInfo.count) {
                return 1;
            }
            if (this.count > userInfo.count) {
                return -1;
            }
            if (this.user == null || this.user.getName() == null) {
                return 1;
            }
            if (userInfo.user == null || userInfo.user.getName() == null) {
                return -1;
            }
            return this.user.getName().compareTo(userInfo.user.getName());
        }

        public String getName() {
            if (this.user == null) {
                return I18n.tr("<new object>");
            }
            return this.user.getName();
        }

        public int getRelicensingStatus() {
            if (this.user == null) {
                return 0;
            }
            return this.user.getRelicensingStatus();
        }
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                UserListDialog.this.selectionUsersPrimitivesAction.select();
            }
        }
    }

    class LoadRelicensingInformationAction
    extends AbstractAction {
        public LoadRelicensingInformationAction() {
            this.putValue("Name", I18n.tr("Load CT"));
            this.putValue("ShortDescription", I18n.tr("Loads information about relicensing status from the server. Users having agreed to the new contributor terms will show a green check mark."));
            this.putValue("SmallIcon", ImageProvider.get("about"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            User.loadRelicensingInformation();
            Layer layer = Main.main.getActiveLayer();
            if (layer instanceof OsmDataLayer) {
                UserListDialog.this.refresh(((OsmDataLayer)layer).data.getSelected());
            }
            this.setEnabled(false);
        }
    }

    class ShowUserInfoAction
    extends AbstractInfoAction
    implements ListSelectionListener {
        public ShowUserInfoAction() {
            super(false);
            this.putValue("Name", I18n.tr("Show info"));
            this.putValue("ShortDescription", I18n.tr("Launches a browser with information about the user"));
            this.putValue("SmallIcon", ImageProvider.get("about"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            int[] nArray = UserListDialog.this.userTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            List<User> list = UserListDialog.this.model.getSelectedUsers(nArray);
            if (list.isEmpty()) {
                return;
            }
            if (list.size() > 10) {
                System.out.println(I18n.tr("Warning: only launching info browsers for the first {0} of {1} selected users", 10, list.size()));
            }
            Iterator<User> iterator = list.iterator();
            for (int i = Math.min(10, list.size()); iterator.hasNext() && i > 0 && (string = this.createInfoUrl(iterator.next())) != null; --i) {
                this.launchBrowser(string);
            }
        }

        protected String createInfoUrl(Object object) {
            User user = (User)object;
            try {
                return ShowUserInfoAction.getBaseUserUrl() + "/" + URLEncoder.encode(user.getName(), "UTF-8").replaceAll("\\+", "%20");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to create an URL because the encoding ''{0}''<br>was missing on this system.</html>", "UTF-8"), I18n.tr("Missing encoding"), 0);
                return null;
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(UserListDialog.this.userTable != null && UserListDialog.this.userTable.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class SelectUsersPrimitivesAction
    extends AbstractAction
    implements ListSelectionListener {
        public SelectUsersPrimitivesAction() {
            this.putValue("Name", I18n.tr("Select"));
            this.putValue("ShortDescription", I18n.tr("Select objects submitted by this user"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.updateEnabledState();
        }

        public void select() {
            int[] nArray = UserListDialog.this.userTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            UserListDialog.this.model.selectPrimitivesOwnedBy(UserListDialog.this.userTable.getSelectedRows());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.select();
        }

        protected void updateEnabledState() {
            this.setEnabled(UserListDialog.this.userTable != null && UserListDialog.this.userTable.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }
}

