/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.conflict.IConflictListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ConflictResolutionDialog;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConflictDialog
extends ToggleDialog
implements MapView.EditLayerChangeListener,
IConflictListener,
SelectionChangedListener {
    private ConflictCollection conflicts;
    private ConflictListModel model;
    private JList lstConflicts;
    private ResolveAction actResolve;
    private SelectAction actSelect;

    public static Color getColor() {
        return Main.pref.getColor(I18n.marktr("conflict"), Color.gray);
    }

    protected void build() {
        this.model = new ConflictListModel();
        this.lstConflicts = new JList(this.model);
        this.lstConflicts.setSelectionMode(2);
        this.lstConflicts.setCellRenderer(new OsmPrimitivRenderer());
        this.lstConflicts.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    ConflictDialog.this.resolve();
                }
            }
        });
        this.lstConflicts.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Main.map.mapView.repaint();
            }
        });
        this.add((Component)new JScrollPane(this.lstConflicts), "Center");
        this.actResolve = new ResolveAction();
        SideButton sideButton = new SideButton(this.actResolve);
        this.lstConflicts.getSelectionModel().addListSelectionListener(this.actResolve);
        this.actSelect = new SelectAction();
        SideButton sideButton2 = new SideButton(this.actSelect);
        this.lstConflicts.getSelectionModel().addListSelectionListener(this.actSelect);
        JPanel jPanel = this.getButtonPanel(2);
        jPanel.add(sideButton);
        jPanel.add(sideButton2);
        this.add((Component)jPanel, "South");
    }

    public ConflictDialog() {
        super(I18n.tr("Conflict"), "conflict", I18n.tr("Resolve conflicts."), Shortcut.registerShortcut("subwindow:conflict", I18n.tr("Toggle: {0}", I18n.tr("Conflict")), 67, 4), 100);
        this.build();
        this.refreshView();
    }

    @Override
    public void showNotify() {
        DataSet.addSelectionListener(this);
        MapView.addEditLayerChangeListener(this, true);
        this.refreshView();
    }

    @Override
    public void hideNotify() {
        MapView.removeEditLayerChangeListener(this);
        DataSet.removeSelectionListener(this);
    }

    private final void resolve() {
        if (this.conflicts == null || this.model.getSize() == 0) {
            return;
        }
        int n = this.lstConflicts.getSelectedIndex();
        if (n < 0) {
            n = 0;
        }
        Conflict<?> conflict = this.conflicts.get(n);
        ConflictResolutionDialog conflictResolutionDialog = new ConflictResolutionDialog(Main.parent);
        conflictResolutionDialog.getConflictResolver().populate(conflict);
        conflictResolutionDialog.setVisible(true);
        this.lstConflicts.setSelectedIndex(n);
        Main.map.mapView.repaint();
    }

    public final void refreshView() {
        OsmDataLayer osmDataLayer = Main.main.getEditLayer();
        this.conflicts = osmDataLayer == null ? new ConflictCollection() : osmDataLayer.getConflicts();
        this.model.fireContentChanged();
        this.updateTitle(this.conflicts.size());
    }

    private void updateTitle(int n) {
        if (n > 0) {
            this.setTitle(I18n.tr("Conflicts: {0} unresolved", this.conflicts.size()));
        } else {
            this.setTitle(I18n.tr("Conflict"));
        }
    }

    public void paintConflicts(final Graphics graphics, final NavigatableComponent navigatableComponent) {
        Color color = ConflictDialog.getColor();
        if (color.equals(Main.pref.getColor(I18n.marktr("background"), Color.black))) {
            return;
        }
        graphics.setColor(color);
        AbstractVisitor abstractVisitor = new AbstractVisitor(){

            public void visit(Node node) {
                Point point = navigatableComponent.getPoint(node);
                graphics.drawRect(point.x - 1, point.y - 1, 2, 2);
            }

            public void visit(Node node, Node node2) {
                Point point = navigatableComponent.getPoint(node);
                Point point2 = navigatableComponent.getPoint(node2);
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }

            public void visit(Way way) {
                Node node = null;
                for (Node node2 : way.getNodes()) {
                    if (node == null) {
                        node = node2;
                        continue;
                    }
                    this.visit(node, node2);
                    node = node2;
                }
            }

            public void visit(Relation relation) {
                for (RelationMember relationMember : relation.getMembers()) {
                    relationMember.getMember().visit(this);
                }
            }
        };
        for (Object object : this.lstConflicts.getSelectedValues()) {
            if (this.conflicts == null || !this.conflicts.hasConflictForMy((OsmPrimitive)object)) continue;
            ((OsmPrimitive)this.conflicts.getConflictForMy((OsmPrimitive)object).getTheir()).visit(abstractVisitor);
        }
    }

    @Override
    public void editLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
        if (osmDataLayer != null) {
            osmDataLayer.getConflicts().removeConflictListener(this);
        }
        if (osmDataLayer2 != null) {
            osmDataLayer2.getConflicts().addConflictListener(this);
        }
        this.refreshView();
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }

    public Conflict<? extends OsmPrimitive> getSelectedConflict() {
        if (this.conflicts == null || this.model.getSize() == 0) {
            return null;
        }
        int n = this.lstConflicts.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this.conflicts.get(n);
    }

    @Override
    public void onConflictsAdded(ConflictCollection conflictCollection) {
        this.refreshView();
    }

    @Override
    public void onConflictsRemoved(ConflictCollection conflictCollection) {
        System.err.println("1 conflict has been resolved.");
        this.refreshView();
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        this.lstConflicts.clearSelection();
        for (OsmPrimitive osmPrimitive : collection) {
            int n;
            if (this.conflicts == null || !this.conflicts.hasConflictForMy(osmPrimitive) || (n = this.model.indexOf(osmPrimitive)) < 0) continue;
            this.lstConflicts.addSelectionInterval(n, n);
        }
    }

    @Override
    public String helpTopic() {
        return HelpUtil.ht("/Dialog/ConflictList");
    }

    class SelectAction
    extends AbstractAction
    implements ListSelectionListener {
        public SelectAction() {
            this.putValue("Name", I18n.tr("Select"));
            this.putValue("ShortDescription", I18n.tr("Set the selected elements on the map to the selected items in the list above."));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.putValue("help", HelpUtil.ht("/Dialog/ConflictList#SelectAction"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
            for (Object object : ConflictDialog.this.lstConflicts.getSelectedValues()) {
                linkedList.add((OsmPrimitive)object);
            }
            Main.main.getCurrentDataSet().setSelected(linkedList);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            boolean bl = listSelectionModel.getMinSelectionIndex() >= 0 && listSelectionModel.getMaxSelectionIndex() >= listSelectionModel.getMinSelectionIndex();
            this.setEnabled(bl);
        }
    }

    class ResolveAction
    extends AbstractAction
    implements ListSelectionListener {
        public ResolveAction() {
            this.putValue("Name", I18n.tr("Resolve"));
            this.putValue("ShortDescription", I18n.tr("Open a merge dialog of all selected items in the list above."));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "conflict"));
            this.putValue("help", HelpUtil.ht("/Dialog/ConflictList#ResolveAction"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConflictDialog.this.resolve();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            boolean bl = listSelectionModel.getMinSelectionIndex() >= 0 && listSelectionModel.getMaxSelectionIndex() >= listSelectionModel.getMinSelectionIndex();
            this.setEnabled(bl);
        }
    }

    class ConflictListModel
    implements ListModel {
        private CopyOnWriteArrayList<ListDataListener> listeners = new CopyOnWriteArrayList();

        public void addListDataListener(ListDataListener listDataListener) {
            if (listDataListener != null) {
                this.listeners.addIfAbsent(listDataListener);
            }
        }

        public void removeListDataListener(ListDataListener listDataListener) {
            this.listeners.remove(listDataListener);
        }

        protected void fireContentChanged() {
            ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, this.getSize());
            Iterator<ListDataListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().contentsChanged(listDataEvent);
            }
        }

        public Object getElementAt(int n) {
            if (n < 0) {
                return null;
            }
            if (n >= this.getSize()) {
                return null;
            }
            return ConflictDialog.this.conflicts.get(n).getMy();
        }

        public int getSize() {
            if (ConflictDialog.this.conflicts == null) {
                return 0;
            }
            return ConflictDialog.this.conflicts.size();
        }

        public int indexOf(OsmPrimitive osmPrimitive) {
            if (ConflictDialog.this.conflicts == null) {
                return -1;
            }
            for (int i = 0; i < ConflictDialog.this.conflicts.size(); ++i) {
                if (!ConflictDialog.this.conflicts.get(i).isMatchingMy(osmPrimitive)) continue;
                return i;
            }
            return -1;
        }

        public OsmPrimitive get(int n) {
            if (ConflictDialog.this.conflicts == null) {
                return null;
            }
            return ConflictDialog.this.conflicts.get(n).getMy();
        }
    }
}

