/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageryLayerInfo {
    public static final ImageryLayerInfo instance = new ImageryLayerInfo();
    ArrayList<ImageryInfo> layers = new ArrayList();
    static ArrayList<ImageryInfo> defaultLayers = new ArrayList();
    private static final String[] DEFAULT_LAYER_SITES = new String[]{"http://josm.openstreetmap.de/maps"};

    private ImageryLayerInfo() {
    }

    public ImageryLayerInfo(ImageryLayerInfo imageryLayerInfo) {
        this.layers.addAll(imageryLayerInfo.layers);
    }

    public void load() {
        this.layers.clear();
        for (Collection<String> collection : Main.pref.getArray("imagery.layers", Collections.<Collection<String>>emptySet())) {
            this.add(new ImageryInfo(collection));
        }
        Collections.sort(this.layers);
    }

    public void loadDefaults(boolean bl) {
        defaultLayers.clear();
        Collection<String> collection = Main.pref.getCollection("imagery.layers.default", Collections.<String>emptySet());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : Main.pref.getCollection("imagery.layers.sites", Arrays.asList(DEFAULT_LAYER_SITES))) {
            try {
                String string2;
                InputStreamReader inputStreamReader;
                if (bl) {
                    MirroredInputStream.cleanup(string);
                }
                MirroredInputStream mirroredInputStream = new MirroredInputStream(string, -1L);
                try {
                    inputStreamReader = new InputStreamReader((InputStream)mirroredInputStream, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    inputStreamReader = new InputStreamReader(mirroredInputStream);
                }
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    String[] stringArray = string2.split(";");
                    if (string2.startsWith("#") || stringArray.length != 3 && stringArray.length != 4) continue;
                    boolean bl2 = "true".equals(stringArray[0]);
                    String string3 = I18n.tr(stringArray[1]);
                    String string4 = stringArray[2];
                    String string5 = null;
                    if (stringArray.length == 4) {
                        string5 = stringArray[3];
                    }
                    defaultLayers.add(new ImageryInfo(string3, string4, string5));
                    if (!bl2) continue;
                    arrayList.add(string4);
                    if (collection.contains(string4)) continue;
                    for (ImageryInfo imageryInfo : this.layers) {
                        if ((imageryInfo.getImageryType() != ImageryInfo.ImageryType.WMS || !string4.equals(imageryInfo.getUrl())) && !string4.equals(imageryInfo.getFullUrl())) continue;
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    this.add(new ImageryInfo(string3, string4));
                }
            }
            catch (IOException iOException) {
            }
        }
        Collections.sort(defaultLayers);
        Main.pref.putCollection("imagery.layers.default", arrayList.size() > 0 ? arrayList : collection);
    }

    public void add(ImageryInfo imageryInfo) {
        this.layers.add(imageryInfo);
    }

    public void remove(ImageryInfo imageryInfo) {
        this.layers.remove(imageryInfo);
    }

    public void save() {
        LinkedList<Collection<String>> linkedList = new LinkedList<Collection<String>>();
        for (ImageryInfo imageryInfo : this.layers) {
            linkedList.add(imageryInfo.getInfoArray());
        }
        Main.pref.putArray("imagery.layers", linkedList);
    }

    public List<ImageryInfo> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public List<ImageryInfo> getDefaultLayers() {
        return Collections.unmodifiableList(defaultLayers);
    }

    public static void addLayer(ImageryInfo imageryInfo) {
        instance.add(imageryInfo);
        instance.save();
        Main.main.menu.imageryMenu.refreshImageryMenu();
    }
}

