/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.mappaint.mapcss.parser.MapCSSParser;
import org.openstreetmap.josm.gui.mappaint.mapcss.parser.ParseException;
import org.openstreetmap.josm.gui.mappaint.mapcss.parser.TokenMgrError;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;

public class MapCSSStyleSource
extends StyleSource {
    public final List<MapCSSRule> rules = new ArrayList<MapCSSRule>();
    private Color backgroundColorOverride;

    public MapCSSStyleSource(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public MapCSSStyleSource(SourceEntry sourceEntry) {
        super(sourceEntry);
    }

    public void loadStyleSource() {
        this.init();
        this.rules.clear();
        try {
            MapCSSParser mapCSSParser = new MapCSSParser(this.getSourceInputStream(), "UTF-8");
            mapCSSParser.sheet(this);
            this.loadMeta();
            this.loadCanvas();
        }
        catch (IOException iOException) {
            System.err.println(I18n.tr("Warning: failed to load Mappaint styles from ''{0}''. Exception was: {1}", this.url, iOException.toString()));
            iOException.printStackTrace();
            this.logError(iOException);
        }
        catch (TokenMgrError tokenMgrError) {
            System.err.println(I18n.tr("Warning: failed to parse Mappaint styles from ''{0}''. Error was: {1}", this.url, tokenMgrError.getMessage()));
            tokenMgrError.printStackTrace();
            this.logError(tokenMgrError);
        }
        catch (ParseException parseException) {
            System.err.println(I18n.tr("Warning: failed to parse Mappaint styles from ''{0}''. Error was: {1}", this.url, parseException.getMessage()));
            parseException.printStackTrace();
            this.logError(new ParseException(parseException.getMessage()));
        }
    }

    public InputStream getSourceInputStream() throws IOException {
        MirroredInputStream mirroredInputStream = new MirroredInputStream(this.url);
        InputStream inputStream = mirroredInputStream.getZipEntry("mapcss", "style");
        if (inputStream != null) {
            this.zipIcons = mirroredInputStream.getFile();
            return inputStream;
        }
        this.zipIcons = null;
        return mirroredInputStream;
    }

    private void loadMeta() {
        Cascade cascade = this.constructSpecial("meta");
        String string = cascade.get("title", null, String.class);
        if (this.title == null) {
            this.title = string;
        }
        String string2 = cascade.get("icon", null, String.class);
        if (this.icon == null) {
            this.icon = string2;
        }
    }

    private void loadCanvas() {
        Cascade cascade = this.constructSpecial("canvas");
        this.backgroundColorOverride = cascade.get("background-color", null, Color.class);
    }

    private Cascade constructSpecial(String string) {
        MultiCascade multiCascade = new MultiCascade();
        Node node = new Node();
        String string2 = LanguageInfo.getJOSMLocaleCode();
        node.put("lang", string2);
        Environment environment = new Environment(node, multiCascade, "default", this);
        block0: for (MapCSSRule mapCSSRule : this.rules) {
            for (Selector selector : mapCSSRule.selectors) {
                if (!(selector instanceof Selector.GeneralSelector)) continue;
                Selector.GeneralSelector generalSelector = (Selector.GeneralSelector)selector;
                if (!generalSelector.base.equals(string)) continue;
                for (Condition condition : generalSelector.conds) {
                    if (condition.applies(environment)) continue;
                    continue block0;
                }
                for (Instruction instruction : mapCSSRule.declaration) {
                    instruction.execute(environment);
                }
            }
        }
        return multiCascade.getCascade("default");
    }

    public Color getBackgroundColorOverride() {
        return this.backgroundColorOverride;
    }

    public void apply(MultiCascade multiCascade, OsmPrimitive osmPrimitive, double d, OsmPrimitive osmPrimitive2, boolean bl) {
        Environment environment = new Environment(osmPrimitive, multiCascade, null, this);
        for (MapCSSRule mapCSSRule : this.rules) {
            for (Selector selector : mapCSSRule.selectors) {
                if (!selector.applies(environment)) continue;
                if (!selector.getRange().contains(d)) {
                    multiCascade.range = multiCascade.range.reduceAround(d, selector.getRange());
                    continue;
                }
                multiCascade.range = Range.cut(multiCascade.range, selector.getRange());
                String string = selector.getSubpart();
                if (string == null) {
                    string = "default";
                }
                if (string.equals("*")) {
                    for (Map.Entry entry : multiCascade.getLayers()) {
                        environment.layer = (String)entry.getKey();
                        if (Utils.equal(environment.layer, "*")) continue;
                        for (Instruction instruction : mapCSSRule.declaration) {
                            instruction.execute(environment);
                        }
                    }
                    continue;
                }
                environment.layer = string;
                for (Instruction instruction : mapCSSRule.declaration) {
                    instruction.execute(environment);
                }
            }
        }
    }

    public String toString() {
        return Utils.join("\n", this.rules);
    }
}

