/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.TextElement;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class NodeElemStyle
extends ElemStyle {
    public ImageIcon icon;
    public int iconAlpha;
    public Symbol symbol;
    public NodeTextElement text;
    private ImageIcon disabledIcon;
    public static final NodeElemStyle SIMPLE_NODE_ELEMSTYLE;

    protected NodeElemStyle(Cascade cascade, ImageIcon imageIcon, int n, Symbol symbol, NodeTextElement nodeTextElement) {
        super(cascade);
        this.icon = imageIcon;
        this.iconAlpha = n;
        this.symbol = symbol;
        this.text = nodeTextElement;
    }

    public static NodeElemStyle create(Environment environment) {
        return NodeElemStyle.create(environment, false);
    }

    private static NodeElemStyle create(Environment environment, boolean bl) {
        Object object;
        Cascade cascade = environment.mc.getCascade(environment.layer);
        MapPaintStyles.IconReference iconReference = cascade.get("icon-image", null, MapPaintStyles.IconReference.class);
        ImageIcon imageIcon = null;
        int n = 0;
        Symbol symbol = null;
        if (iconReference != null) {
            imageIcon = MapPaintStyles.getIcon(iconReference, false);
            if (imageIcon == null) {
                imageIcon = MapPaintStyles.getNoIcon_Icon(iconReference.source, false);
            }
            n = Math.min(255, Math.max(0, Main.pref.getInteger("mappaint.icon-image-alpha", 255)));
            object = Utils.color_float2int(cascade.get("icon-opacity", null, Float.TYPE));
            if (object != null) {
                n = (Integer)object;
            }
        } else {
            symbol = NodeElemStyle.createSymbol(environment);
        }
        if (imageIcon == null && symbol == null && !bl) {
            return null;
        }
        object = null;
        TextElement textElement = TextElement.create(cascade, PaintColors.TEXT.get());
        if (textElement != null) {
            HorizontalTextAlignment horizontalTextAlignment = HorizontalTextAlignment.RIGHT;
            String string = cascade.get("text-anchor-horizontal", null, String.class);
            if (Utils.equal(string, "left")) {
                horizontalTextAlignment = HorizontalTextAlignment.LEFT;
            } else if (Utils.equal(string, "center")) {
                horizontalTextAlignment = HorizontalTextAlignment.CENTER;
            } else if (Utils.equal(string, "right")) {
                horizontalTextAlignment = HorizontalTextAlignment.RIGHT;
            }
            VerticalTextAlignment verticalTextAlignment = VerticalTextAlignment.BOTTOM;
            String string2 = cascade.get("text-anchor-vertical", null, String.class);
            if (Utils.equal(string2, "above")) {
                verticalTextAlignment = VerticalTextAlignment.ABOVE;
            } else if (Utils.equal(string2, "top")) {
                verticalTextAlignment = VerticalTextAlignment.TOP;
            } else if (Utils.equal(string2, "center")) {
                verticalTextAlignment = VerticalTextAlignment.CENTER;
            } else if (Utils.equal(string2, "bottom")) {
                verticalTextAlignment = VerticalTextAlignment.BOTTOM;
            } else if (Utils.equal(string2, "below")) {
                verticalTextAlignment = VerticalTextAlignment.BELOW;
            }
            object = new NodeTextElement(textElement.textKey, horizontalTextAlignment, verticalTextAlignment, textElement.font, textElement.xOffset, textElement.yOffset, textElement.color);
        }
        return new NodeElemStyle(cascade, imageIcon, n, symbol, (NodeTextElement)object);
    }

    private static Symbol createSymbol(Environment environment) {
        Float f;
        SymbolShape symbolShape;
        Cascade cascade = environment.mc.getCascade(environment.layer);
        Cascade cascade2 = environment.mc.getCascade("default");
        String string = cascade.get("symbol-shape", null, String.class);
        if (Utils.equal(string, "square")) {
            symbolShape = SymbolShape.SQUARE;
        } else if (Utils.equal(string, "circle")) {
            symbolShape = SymbolShape.CIRCLE;
        } else {
            return null;
        }
        Float f2 = cascade2.get("symbol-size", null, Float.class);
        if (f2 != null && f2.floatValue() <= 0.0f) {
            f2 = null;
        }
        if ((f = NodeElemStyle.getWidth(cascade, "symbol-size", f2)) == null) {
            f = Float.valueOf(10.0f);
        }
        if (f.floatValue() <= 0.0f) {
            return null;
        }
        Float f3 = NodeElemStyle.getWidth(cascade2, "symbol-stroke-width", null);
        Float f4 = NodeElemStyle.getWidth(cascade, "symbol-stroke-width", f3);
        Color color = cascade.get("symbol-stroke-color", null, Color.class);
        if (f4 == null && color != null) {
            f4 = Float.valueOf(1.0f);
        } else if (f4 != null && color == null) {
            color = Color.ORANGE;
        }
        BasicStroke basicStroke = null;
        if (color != null) {
            float f5 = cascade.get("symbol-stroke-opacity", Float.valueOf(1.0f), Float.class).floatValue();
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), Utils.color_float2int(Float.valueOf(f5)));
            basicStroke = new BasicStroke(f4.floatValue());
        }
        Color color2 = cascade.get("symbol-fill-color", null, Color.class);
        if (basicStroke == null && color2 == null) {
            color2 = Color.BLUE;
        }
        if (color2 != null) {
            float f6 = cascade.get("symbol-fill-opacity", Float.valueOf(1.0f), Float.class).floatValue();
            color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), Utils.color_float2int(Float.valueOf(f6)));
        }
        return new Symbol(symbolShape, Math.round(f.floatValue()), basicStroke, color, color2);
    }

    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, MapPainter mapPainter, boolean bl, boolean bl2) {
        if (osmPrimitive instanceof Node) {
            Node node = (Node)osmPrimitive;
            if (this.icon != null && mapPainter.isShowIcons()) {
                mapPainter.drawNodeIcon(node, mapPainter.isInactive() || node.isDisabled() ? this.getDisabledIcon() : this.icon, Utils.color_int2float(this.iconAlpha).floatValue(), bl, bl2, this.text);
            } else if (this.symbol != null) {
                Color color;
                Color color2 = this.symbol.fillColor;
                if (color2 != null) {
                    if (node.isHighlighted()) {
                        color2 = mapPaintSettings.getHighlightColor();
                    } else if (mapPainter.isInactive() || node.isDisabled()) {
                        color2 = mapPaintSettings.getInactiveColor();
                    } else if (bl) {
                        color2 = mapPaintSettings.getSelectedColor(color2.getAlpha());
                    } else if (bl2) {
                        color2 = mapPaintSettings.getRelationSelectedColor(color2.getAlpha());
                    }
                }
                if ((color = this.symbol.strokeColor) != null) {
                    if (node.isHighlighted()) {
                        color = mapPaintSettings.getHighlightColor();
                    } else if (mapPainter.isInactive() || node.isDisabled()) {
                        color = mapPaintSettings.getInactiveColor();
                    } else if (bl) {
                        color = mapPaintSettings.getSelectedColor(color.getAlpha());
                    } else if (bl2) {
                        color = mapPaintSettings.getRelationSelectedColor(color.getAlpha());
                    }
                }
                mapPainter.drawNodeSymbol(node, this.symbol, color2, color, this.text);
            } else if (node.isHighlighted()) {
                mapPainter.drawNode(node, mapPaintSettings.getHighlightColor(), mapPaintSettings.getSelectedNodeSize(), mapPaintSettings.isFillSelectedNode(), this.text);
            } else {
                boolean bl3 = node.isConnectionNode();
                Color color = mapPainter.isInactive() || node.isDisabled() ? mapPaintSettings.getInactiveColor() : (bl ? mapPaintSettings.getSelectedColor() : (bl2 ? mapPaintSettings.getRelationSelectedColor() : (bl3 ? (node.isTagged() ? mapPaintSettings.getTaggedConnectionColor() : mapPaintSettings.getConnectionColor()) : (node.isTagged() ? mapPaintSettings.getTaggedColor() : mapPaintSettings.getNodeColor()))));
                int n = Utils.max(bl ? mapPaintSettings.getSelectedNodeSize() : 0, node.isTagged() ? mapPaintSettings.getTaggedNodeSize() : 0, bl3 ? mapPaintSettings.getConnectionNodeSize() : 0, mapPaintSettings.getUnselectedNodeSize());
                boolean bl4 = bl && mapPaintSettings.isFillSelectedNode() || node.isTagged() && mapPaintSettings.isFillTaggedNode() || bl3 && mapPaintSettings.isFillConnectionNode() || mapPaintSettings.isFillUnselectedNode();
                mapPainter.drawNode(node, color, n, bl4, this.text);
            }
        } else if (osmPrimitive instanceof Relation && this.icon != null) {
            mapPainter.drawRestriction((Relation)osmPrimitive, this);
        }
    }

    public ImageIcon getDisabledIcon() {
        if (this.disabledIcon != null) {
            return this.disabledIcon;
        }
        if (this.icon == null) {
            return null;
        }
        this.disabledIcon = new ImageIcon(GrayFilter.createDisabledImage(this.icon.getImage()));
        return this.disabledIcon;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 17 * n + (this.icon != null ? this.icon.getImage().hashCode() : 0);
        n = 17 * n + this.iconAlpha;
        n = 17 * n + (this.symbol != null ? this.symbol.hashCode() : 0);
        n = 17 * n + (this.text != null ? this.text.hashCode() : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        NodeElemStyle nodeElemStyle = (NodeElemStyle)object;
        if (this.icon != nodeElemStyle.icon && (this.icon == null || nodeElemStyle.icon == null || this.icon.getImage() != nodeElemStyle.icon.getImage())) {
            return false;
        }
        if (this.iconAlpha != nodeElemStyle.iconAlpha) {
            return false;
        }
        if (!Utils.equal(this.symbol, nodeElemStyle.symbol)) {
            return false;
        }
        return Utils.equal(this.text, nodeElemStyle.text);
    }

    public String toString() {
        return "NodeElemStyle{" + super.toString() + (this.icon != null ? "icon=" + this.icon + " iconAlpha=" + this.iconAlpha : "") + (this.symbol != null ? " symbol=[" + this.symbol + "]" : "") + '}';
    }

    static {
        MultiCascade multiCascade = new MultiCascade();
        Cascade cascade = multiCascade.getOrCreateCascade("default");
        cascade.put("text", "auto");
        SIMPLE_NODE_ELEMSTYLE = NodeElemStyle.create(new Environment(null, multiCascade, "default", null), true);
    }

    public static class NodeTextElement
    extends TextElement {
        public HorizontalTextAlignment hAlign;
        public VerticalTextAlignment vAlign;

        public NodeTextElement(String string, HorizontalTextAlignment horizontalTextAlignment, VerticalTextAlignment verticalTextAlignment, Font font, int n, int n2, Color color) {
            super(string, font, n, n2, color);
            CheckParameterUtil.ensureParameterNotNull((Object)horizontalTextAlignment);
            CheckParameterUtil.ensureParameterNotNull((Object)verticalTextAlignment);
            this.hAlign = horizontalTextAlignment;
            this.vAlign = verticalTextAlignment;
        }

        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            NodeTextElement nodeTextElement = (NodeTextElement)object;
            return this.hAlign == nodeTextElement.hAlign && this.vAlign == nodeTextElement.vAlign;
        }

        public int hashCode() {
            int n = super.hashCode();
            n = 97 * n + this.hAlign.hashCode();
            n = 97 * n + this.vAlign.hashCode();
            return n;
        }
    }

    public static class Symbol {
        public SymbolShape symbol;
        public int size;
        public Stroke stroke;
        public Color strokeColor;
        public Color fillColor;

        public Symbol(SymbolShape symbolShape, int n, Stroke stroke, Color color, Color color2) {
            if (stroke != null && color == null) {
                throw new IllegalArgumentException();
            }
            if (stroke == null && color2 == null) {
                throw new IllegalArgumentException();
            }
            this.symbol = symbolShape;
            this.size = n;
            this.stroke = stroke;
            this.strokeColor = color;
            this.fillColor = color2;
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Symbol symbol = (Symbol)object;
            return this.symbol == symbol.symbol && this.size == symbol.size && Utils.equal(this.stroke, symbol.stroke) && Utils.equal(this.strokeColor, symbol.strokeColor) && Utils.equal(this.fillColor, symbol.fillColor);
        }

        public int hashCode() {
            int n = 7;
            n = 67 * n + this.symbol.hashCode();
            n = 67 * n + this.size;
            n = 67 * n + (this.stroke != null ? this.stroke.hashCode() : 0);
            n = 67 * n + (this.strokeColor != null ? this.strokeColor.hashCode() : 0);
            n = 67 * n + (this.fillColor != null ? this.fillColor.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "symbol=" + (Object)((Object)this.symbol) + " size=" + this.size + (this.stroke != null ? " stroke=" + this.stroke + " strokeColor=" + this.strokeColor : "") + (this.fillColor != null ? " fillColor=" + this.fillColor : "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VerticalTextAlignment {
        ABOVE,
        TOP,
        CENTER,
        BOTTOM,
        BELOW;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HorizontalTextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SymbolShape {
        SQUARE,
        CIRCLE;

    }
}

