/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.LineElemStyle;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.NodeElemStyle;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElemStyles {
    private List<StyleSource> styleSources = new ArrayList<StyleSource>();
    private boolean drawMultipolygon;
    private int cacheIdx;

    public void clearCached() {
        ++this.cacheIdx;
    }

    public List<StyleSource> getStyleSources() {
        return Collections.unmodifiableList(this.styleSources);
    }

    public StyleCache.StyleList get(OsmPrimitive osmPrimitive, double d, NavigatableComponent navigatableComponent) {
        return (StyleCache.StyleList)this.getStyleCacheWithRange((OsmPrimitive)osmPrimitive, (double)d, (NavigatableComponent)navigatableComponent).a;
    }

    public Pair<StyleCache.StyleList, Range> getStyleCacheWithRange(OsmPrimitive osmPrimitive, double d, NavigatableComponent navigatableComponent) {
        Pair<StyleCache.StyleList, Range> pair;
        if (osmPrimitive.mappaintStyle == null || osmPrimitive.mappaintCacheIdx != this.cacheIdx) {
            osmPrimitive.mappaintStyle = StyleCache.EMPTY_STYLECACHE;
        } else {
            pair = osmPrimitive.mappaintStyle.getWithRange(d);
            if (pair.a != null) {
                return pair;
            }
        }
        pair = this.getImpl(osmPrimitive, d, navigatableComponent);
        if (osmPrimitive instanceof Node) {
            boolean bl = false;
            for (ElemStyle elemStyle : (StyleCache.StyleList)pair.a) {
                if (elemStyle.isModifier) continue;
                bl = true;
                break;
            }
            if (!bl) {
                pair.a = new StyleCache.StyleList((StyleCache.StyleList)pair.a, (ElemStyle)NodeElemStyle.SIMPLE_NODE_ELEMSTYLE);
            }
        } else if (osmPrimitive instanceof Way) {
            boolean bl = false;
            for (ElemStyle elemStyle : (StyleCache.StyleList)pair.a) {
                if (!(elemStyle instanceof LineElemStyle) || elemStyle.isModifier) continue;
                bl = true;
                break;
            }
            if (!bl) {
                ElemStyle elemStyle;
                AreaElemStyle areaElemStyle = Utils.find((Iterable)pair.a, AreaElemStyle.class);
                elemStyle = areaElemStyle == null ? LineElemStyle.UNTAGGED_WAY : LineElemStyle.createSimpleLineStyle(areaElemStyle.color);
                pair.a = new StyleCache.StyleList((StyleCache.StyleList)pair.a, elemStyle);
            }
        }
        osmPrimitive.mappaintStyle = osmPrimitive.mappaintStyle.put((StyleCache.StyleList)pair.a, (Range)pair.b);
        osmPrimitive.mappaintCacheIdx = this.cacheIdx;
        return pair;
    }

    private Pair<StyleCache.StyleList, Range> getImpl(OsmPrimitive osmPrimitive, double d, NavigatableComponent navigatableComponent) {
        if (osmPrimitive instanceof Node) {
            return this.generateStyles(osmPrimitive, d, null, false);
        }
        if (osmPrimitive instanceof Way) {
            Object object2;
            Iterator<Way> iterator;
            Multipolygon multipolygon;
            Relation relation;
            Pair<StyleCache.StyleList, Range> pair = this.generateStyles(osmPrimitive, d, null, false);
            boolean bl = false;
            boolean bl2 = false;
            Color color = null;
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                relation = (Relation)osmPrimitive2;
                if (!this.drawMultipolygon || !relation.isMultipolygon() || !relation.isUsable()) continue;
                multipolygon = new Multipolygon(navigatableComponent);
                multipolygon.load(relation);
                if (!multipolygon.getOuterWays().contains(osmPrimitive)) continue;
                if (!bl) {
                    iterator = new ArrayList(((StyleCache.StyleList)pair.a).size());
                    for (Object object2 : (StyleCache.StyleList)pair.a) {
                        if (object2 instanceof AreaElemStyle) {
                            color = ((AreaElemStyle)object2).color;
                            continue;
                        }
                        iterator.add((Way)((Object)((ElemStyle)object2)));
                    }
                    pair.a = new StyleCache.StyleList((Collection<ElemStyle>)((Object)iterator));
                    bl = true;
                    bl2 = Utils.exists((Iterable)pair.a, LineElemStyle.class);
                }
                if (bl2) continue;
                iterator = this.getStyleCacheWithRange(relation, d, navigatableComponent);
                LineElemStyle lineElemStyle = Utils.find((Iterable)((Pair)((Object)iterator)).a, LineElemStyle.class);
                if (lineElemStyle != null) {
                    pair.a = new StyleCache.StyleList((StyleCache.StyleList)pair.a, (ElemStyle)lineElemStyle);
                    pair.b = Range.cut((Range)pair.b, (Range)((Pair)((Object)iterator)).b);
                    break;
                }
                if (color != null || (object2 = Utils.find((Iterable)((Pair)((Object)iterator)).a, AreaElemStyle.class)) == null) continue;
                pair.b = Range.cut((Range)pair.b, (Range)((Pair)((Object)iterator)).b);
                color = ((AreaElemStyle)object2).color;
            }
            if (bl) {
                if (!Utils.exists((Iterable)pair.a, LineElemStyle.class)) {
                    pair.a = new StyleCache.StyleList((StyleCache.StyleList)pair.a, (ElemStyle)LineElemStyle.createSimpleLineStyle(color));
                }
                return pair;
            }
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                relation = (Relation)osmPrimitive2;
                if (!this.drawMultipolygon || !relation.isMultipolygon() || !relation.isUsable()) continue;
                multipolygon = new Multipolygon(navigatableComponent);
                multipolygon.load(relation);
                if (!multipolygon.getInnerWays().contains(osmPrimitive)) continue;
                iterator = multipolygon.getOuterWays().iterator();
                pair = this.generateStyles(osmPrimitive, d, iterator.hasNext() ? iterator.next() : null, false);
                boolean bl3 = false;
                for (Object object3 : (StyleCache.StyleList)pair.a) {
                    if (!(object3 instanceof LineElemStyle) && !(object3 instanceof AreaElemStyle)) continue;
                    bl3 = true;
                }
                if (!bl3 && !multipolygon.getOuterWays().isEmpty()) {
                    Object object3;
                    object2 = this.get(relation, d, navigatableComponent);
                    object3 = null;
                    Iterator<ElemStyle> iterator2 = ((StyleCache.StyleList)object2).iterator();
                    while (iterator2.hasNext()) {
                        ElemStyle elemStyle = iterator2.next();
                        if (!(elemStyle instanceof AreaElemStyle)) continue;
                        object3 = ((AreaElemStyle)elemStyle).color;
                        break;
                    }
                    pair.a = new StyleCache.StyleList((StyleCache.StyleList)pair.a, (ElemStyle)LineElemStyle.createSimpleLineStyle((Color)object3));
                }
                return pair;
            }
            return pair;
        }
        if (osmPrimitive instanceof Relation) {
            Pair<StyleCache.StyleList, Range> pair = this.generateStyles(osmPrimitive, d, null, true);
            if (this.drawMultipolygon && ((Relation)osmPrimitive).isMultipolygon() && !Utils.exists((Iterable)pair.a, AreaElemStyle.class)) {
                Multipolygon multipolygon = new Multipolygon(navigatableComponent);
                multipolygon.load((Relation)osmPrimitive);
                for (Way way : multipolygon.getOuterWays()) {
                    Pair<StyleCache.StyleList, Range> pair2 = this.generateStyles(way, d, null, false);
                    ElemStyle elemStyle = Utils.find((Iterable)pair2.a, AreaElemStyle.class);
                    if (elemStyle == null) continue;
                    pair.a = new StyleCache.StyleList((StyleCache.StyleList)pair.a, elemStyle);
                    pair.b = Range.cut((Range)pair.b, (Range)pair2.b);
                    break;
                }
            }
            return pair;
        }
        return null;
    }

    public Pair<StyleCache.StyleList, Range> generateStyles(OsmPrimitive osmPrimitive, double d, OsmPrimitive osmPrimitive2, boolean bl) {
        ArrayList<ElemStyle> arrayList = new ArrayList<ElemStyle>();
        MultiCascade multiCascade = new MultiCascade();
        Environment environment = new Environment(osmPrimitive, multiCascade, null, null);
        for (StyleSource object : this.styleSources) {
            if (!object.active) continue;
            object.apply(multiCascade, osmPrimitive, d, osmPrimitive2, bl);
        }
        for (Map.Entry entry : multiCascade.getLayers()) {
            if ("*".equals(entry.getKey())) continue;
            environment.layer = (String)entry.getKey();
            Cascade cascade = (Cascade)entry.getValue();
            if (osmPrimitive instanceof Way) {
                ElemStyles.addIfNotNull(arrayList, AreaElemStyle.create(cascade));
                ElemStyles.addIfNotNull(arrayList, LineElemStyle.createLine(environment));
                ElemStyles.addIfNotNull(arrayList, LineElemStyle.createCasing(environment));
                continue;
            }
            if (osmPrimitive instanceof Node) {
                ElemStyles.addIfNotNull(arrayList, NodeElemStyle.create(environment));
                continue;
            }
            if (!(osmPrimitive instanceof Relation)) continue;
            if (((Relation)osmPrimitive).isMultipolygon()) {
                ElemStyles.addIfNotNull(arrayList, AreaElemStyle.create(cascade));
                ElemStyles.addIfNotNull(arrayList, LineElemStyle.createLine(environment));
                ElemStyles.addIfNotNull(arrayList, LineElemStyle.createCasing(environment));
                continue;
            }
            if (!"restriction".equals(osmPrimitive.get("type"))) continue;
            ElemStyles.addIfNotNull(arrayList, NodeElemStyle.create(environment));
        }
        return new Pair<StyleCache.StyleList, Range>(new StyleCache.StyleList(arrayList), multiCascade.range);
    }

    private static <T> void addIfNotNull(List<T> list, T t) {
        if (t != null) {
            list.add(t);
        }
    }

    public boolean isDrawMultipolygon() {
        return this.drawMultipolygon;
    }

    public void setDrawMultipolygon(boolean bl) {
        this.drawMultipolygon = bl;
    }

    void clear() {
        this.styleSources.clear();
    }

    void add(StyleSource styleSource) {
        this.styleSources.add(styleSource);
    }

    void setStyleSources(Collection<StyleSource> collection) {
        this.styleSources.clear();
        this.styleSources.addAll(collection);
    }
}

