/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionInfo;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffsetBookmark {
    public static List<OffsetBookmark> allBookmarks = new ArrayList<OffsetBookmark>();
    public Projection proj;
    public String layerName;
    public String name;
    public double dx;
    public double dy;
    public double centerX;
    public double centerY;

    public boolean isUsable(ImageryLayer imageryLayer) {
        if (this.proj == null) {
            return false;
        }
        if (!Main.proj.toCode().equals(this.proj.toCode())) {
            return false;
        }
        return imageryLayer.getInfo().getName().equals(this.layerName);
    }

    public OffsetBookmark(Projection projection, String string, String string2, double d, double d2) {
        this(projection, string, string2, d, d2, 0.0, 0.0);
    }

    public OffsetBookmark(Projection projection, String string, String string2, double d, double d2, double d3, double d4) {
        this.proj = projection;
        this.layerName = string;
        this.name = string2;
        this.dx = d;
        this.dy = d2;
        this.centerX = d3;
        this.centerY = d4;
    }

    public OffsetBookmark(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        String string = arrayList.get(0);
        this.proj = ProjectionInfo.getProjectionByCode(string);
        if (this.proj == null) {
            for (Projection projection : Projections.getProjections()) {
                if (!projection.getCacheDirectoryName().equals(string)) continue;
                this.proj = projection;
                break;
            }
        }
        this.layerName = arrayList.get(1);
        this.name = arrayList.get(2);
        this.dx = Double.valueOf(arrayList.get(3));
        this.dy = Double.valueOf(arrayList.get(4));
        if (arrayList.size() >= 7) {
            this.centerX = Double.valueOf(arrayList.get(5));
            this.centerY = Double.valueOf(arrayList.get(6));
        }
        if (this.proj instanceof Mercator && Math.abs(this.dx) < 0.001 && Math.abs(this.dy) < 0.001) {
            this.dx *= 6378137.0;
            this.dy *= 6378137.0;
        }
        if (this.proj == null) {
            System.err.println(I18n.tr("Projection ''{0}'' is not found, bookmark ''{1}'' is not usable", string, this.name));
        }
    }

    public ArrayList<String> getInfoArray() {
        ArrayList<String> arrayList = new ArrayList<String>(7);
        if (this.proj != null) {
            arrayList.add(this.proj.toCode());
        } else {
            arrayList.add("");
        }
        arrayList.add(this.layerName);
        arrayList.add(this.name);
        arrayList.add(String.valueOf(this.dx));
        arrayList.add(String.valueOf(this.dy));
        if (this.centerX != 0.0 || this.centerY != 0.0) {
            arrayList.add(String.valueOf(this.centerX));
            arrayList.add(String.valueOf(this.centerY));
        }
        return arrayList;
    }

    public static void loadBookmarks() {
        for (Collection<String> collection : Main.pref.getArray("imagery.offsets", Collections.<Collection<String>>emptySet())) {
            allBookmarks.add(new OffsetBookmark(collection));
        }
    }

    public static void saveBookmarks() {
        LinkedList<Collection<String>> linkedList = new LinkedList<Collection<String>>();
        for (OffsetBookmark offsetBookmark : allBookmarks) {
            linkedList.add(offsetBookmark.getInfoArray());
        }
        Main.pref.putArray("imagery.offsets", linkedList);
    }

    public static OffsetBookmark getBookmarkByName(ImageryLayer imageryLayer, String string) {
        for (OffsetBookmark offsetBookmark : allBookmarks) {
            if (!offsetBookmark.isUsable(imageryLayer) || !string.equals(offsetBookmark.name)) continue;
            return offsetBookmark;
        }
        return null;
    }

    public static void bookmarkOffset(String string, ImageryLayer imageryLayer) {
        LatLon latLon = Main.map != null && Main.map.mapView != null ? Main.proj.eastNorth2latlon(Main.map.mapView.getCenter()) : new LatLon(0.0, 0.0);
        OffsetBookmark offsetBookmark = new OffsetBookmark(Main.proj, imageryLayer.getInfo().getName(), string, imageryLayer.getDx(), imageryLayer.getDy(), latLon.lon(), latLon.lat());
        ListIterator<OffsetBookmark> listIterator = allBookmarks.listIterator();
        while (listIterator.hasNext()) {
            OffsetBookmark offsetBookmark2 = listIterator.next();
            if (!offsetBookmark2.isUsable(imageryLayer) || !string.equals(offsetBookmark2.name)) continue;
            listIterator.set(offsetBookmark);
            OffsetBookmark.saveBookmarks();
            return;
        }
        allBookmarks.add(offsetBookmark);
        OffsetBookmark.saveBookmarks();
    }
}

