/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadPrimitiveTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadReferrersTask;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.OsmIdTextField;
import org.openstreetmap.josm.gui.widgets.OsmPrimitiveTypesComboBox;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class DownloadPrimitiveAction
extends JosmAction {
    public DownloadPrimitiveAction() {
        super(I18n.tr("Download object..."), "downloadprimitive", I18n.tr("Download OSM object by ID."), Shortcut.registerShortcut("system:download_primitive", I18n.tr("File: {0}", I18n.tr("Download Object...")), 79, 9), true);
        this.putValue("help", HelpUtil.ht("/Action/DownloadObject"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JCheckBox jCheckBox = new JCheckBox(I18n.tr("Separate Layer"));
        jCheckBox.setToolTipText(I18n.tr("Select if the data should be downloaded into a new layer"));
        jCheckBox.setSelected(Main.pref.getBoolean("download.newlayer"));
        JCheckBox jCheckBox2 = new JCheckBox(I18n.tr("Download referrers"));
        jCheckBox2.setToolTipText(I18n.tr("Select if the referrers of the object should be downloaded as well"));
        jCheckBox2.setSelected(Main.pref.getBoolean("downloadprimitive.referrers"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("Object type:")), gridBagConstraints);
        OsmPrimitiveTypesComboBox osmPrimitiveTypesComboBox = new OsmPrimitiveTypesComboBox();
        osmPrimitiveTypesComboBox.setToolTipText(I18n.tr("Choose the OSM object type"));
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)osmPrimitiveTypesComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("Object ID:")), gridBagConstraints);
        OsmIdTextField osmIdTextField = new OsmIdTextField();
        osmIdTextField.setToolTipText(I18n.tr("Enter the ID of the object that should be downloaded"));
        osmIdTextField.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0, false));
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)osmIdTextField, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jCheckBox2, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Download Object"), new String[]{I18n.tr("Download object"), I18n.tr("Cancel")});
        extendedDialog.setContent(jPanel, false);
        extendedDialog.setButtonIcons(new String[]{"download.png", "cancel.png"});
        extendedDialog.setToolTipTexts(new String[]{I18n.tr("Start downloading"), I18n.tr("Close dialog and cancel downloading")});
        extendedDialog.setDefaultButton(1);
        extendedDialog.configureContextsensitiveHelp("/Action/DownloadObject", true);
        osmPrimitiveTypesComboBox.setSelectedIndex(Main.pref.getInteger("downloadprimitive.lasttype", 0));
        extendedDialog.showDialog();
        if (extendedDialog.getValue() != 1) {
            return;
        }
        Main.pref.putInteger("downloadprimitive.lasttype", osmPrimitiveTypesComboBox.getSelectedIndex());
        Main.pref.put("downloadprimitive.referrers", jCheckBox2.isSelected());
        Main.pref.put("download.newlayer", jCheckBox.isSelected());
        int n = osmIdTextField.getOsmId();
        if (n <= 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Invalid ID specified. Cannot download object."), I18n.tr("Information"), 1);
        } else {
            this.download(jCheckBox.isSelected(), osmPrimitiveTypesComboBox.getType(), n, jCheckBox2.isSelected());
        }
    }

    public void download(boolean bl, OsmPrimitiveType osmPrimitiveType, int n, boolean bl2) {
        OsmDataLayer osmDataLayer = DownloadPrimitiveAction.getEditLayer();
        if (osmDataLayer == null || bl) {
            osmDataLayer = new OsmDataLayer(new DataSet(), OsmDataLayer.createNewName(), null);
            Main.main.addLayer(osmDataLayer);
        }
        Main.worker.submit(new DownloadPrimitiveTask(new SimplePrimitiveId(n, osmPrimitiveType), osmDataLayer));
        if (bl2) {
            Main.worker.submit(new DownloadReferrersTask(osmDataLayer, n, osmPrimitiveType));
        }
    }
}

