/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferringRelationsBrowserModel
extends AbstractListModel {
    private Relation relation = null;
    private ArrayList<Relation> referrers = new ArrayList();

    public ReferringRelationsBrowserModel() {
    }

    public ReferringRelationsBrowserModel(Relation relation) {
        this();
        this.relation = relation;
    }

    protected void fireModelUpdate() {
        int n = Math.max(0, this.referrers.size() - 1);
        this.fireContentsChanged(this, 0, n);
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
        this.referrers.clear();
        this.fireModelUpdate();
    }

    @Override
    public Object getElementAt(int n) {
        return this.referrers.get(n);
    }

    @Override
    public int getSize() {
        return this.referrers.size();
    }

    protected boolean isReferringRelation(Relation relation) {
        if (relation == null) {
            return false;
        }
        for (RelationMember relationMember : relation.getMembers()) {
            Relation relation2;
            if (!relationMember.isRelation() || !(relation2 = relationMember.getRelation()).equals(this.relation)) continue;
            return true;
        }
        return false;
    }

    public void populate(List<Relation> list) {
        this.referrers.clear();
        if (list != null) {
            for (Relation relation : list) {
                if (!this.isReferringRelation(relation)) continue;
                this.referrers.add(relation);
            }
        }
        this.fireModelUpdate();
    }

    public void populate(DataSet dataSet) {
        this.referrers.clear();
        if (dataSet == null) {
            this.fireModelUpdate();
            return;
        }
        for (Relation relation : dataSet.getRelations()) {
            if (!this.isReferringRelation(relation)) continue;
            this.referrers.add(relation);
        }
        this.fireModelUpdate();
    }

    public boolean canReload() {
        return this.relation != null && !this.relation.isNew();
    }

    public Relation getRelation() {
        return this.relation;
    }

    public Relation get(int n) {
        return this.referrers.get(n);
    }
}

