/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.util.Collection;
import java.util.HashMap;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.tools.I18n;

public class ProjectionInfo {
    private static HashMap<String, Projection> allCodes = new HashMap();

    private static ProjectionSubPrefs recreateProj(ProjectionSubPrefs projectionSubPrefs) {
        try {
            return (ProjectionSubPrefs)projectionSubPrefs.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new IllegalStateException(I18n.tr("Cannot instantiate projection ''{0}''", projectionSubPrefs.getClass().toString()), exception);
        }
    }

    public static Projection getProjectionByCode(String string) {
        Projection projection = allCodes.get(string);
        if (projection == null) {
            return null;
        }
        if (string.equals(projection.toCode())) {
            return projection;
        }
        if (!(projection instanceof ProjectionSubPrefs)) {
            throw new IllegalStateException(I18n.tr("Projection code mismatch in ''{0}'': toCode() returns ''{1}'', expected ''{2}''.", projection.getClass().toString(), projection.toCode(), string));
        }
        ProjectionSubPrefs projectionSubPrefs = ProjectionInfo.recreateProj((ProjectionSubPrefs)projection);
        Collection<String> collection = projectionSubPrefs.getPreferencesFromCode(string);
        if (collection != null) {
            projectionSubPrefs.setPreferences(collection);
        }
        if (!string.equals(projectionSubPrefs.toCode())) {
            throw new IllegalStateException(I18n.tr("Bad implementation of ''{0}'' projection class: cannot set preferences to match code ''{1}''.", projectionSubPrefs.getClass().toString(), string));
        }
        allCodes.put(string, projectionSubPrefs);
        return projectionSubPrefs;
    }

    static {
        for (Projection projection : Projections.getProjections()) {
            if (projection instanceof ProjectionSubPrefs) {
                ProjectionSubPrefs projectionSubPrefs = ProjectionInfo.recreateProj((ProjectionSubPrefs)projection);
                for (String string : projectionSubPrefs.allCodes()) {
                    allCodes.put(string, projectionSubPrefs);
                }
                continue;
            }
            allCodes.put(projection.toCode(), projection);
        }
    }
}

