/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitivesAddedEvent
extends AbstractDatasetChangedEvent {
    private final List<? extends OsmPrimitive> primitives;
    private final boolean wasIncomplete;

    public PrimitivesAddedEvent(DataSet dataSet, Collection<? extends OsmPrimitive> collection, boolean bl) {
        super(dataSet);
        this.primitives = Collections.unmodifiableList(new ArrayList<OsmPrimitive>(collection));
        this.wasIncomplete = bl;
    }

    @Override
    public void fire(DataSetListener dataSetListener) {
        dataSetListener.primtivesAdded(this);
    }

    public List<? extends OsmPrimitive> getPrimitives() {
        return this.primitives;
    }

    public boolean wasIncomplete() {
        return this.wasIncomplete;
    }

    @Override
    public AbstractDatasetChangedEvent.DatasetEventType getType() {
        return AbstractDatasetChangedEvent.DatasetEventType.PRIMITIVES_ADDED;
    }
}

