/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginPreferenceFactory;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.plugins.ReadLocalPluginInformationTask;
import org.openstreetmap.josm.plugins.ReadRemotePluginInformationTask;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginHandler {
    public static final Collection<DeprecatedPlugin> DEPRECATED_PLUGINS;
    public static final String[] UNMAINTAINED_PLUGINS;
    public static final Collection<PluginProxy> pluginList;

    private static void filterDeprecatedPlugins(Window window, Collection<String> collection) {
        TreeSet<DeprecatedPlugin> treeSet = new TreeSet<DeprecatedPlugin>();
        for (DeprecatedPlugin object : DEPRECATED_PLUGINS) {
            if (!collection.contains(object.name)) continue;
            collection.remove(object.name);
            Main.pref.removeFromCollection("plugins", object.name);
            treeSet.add(object);
            object.migrate();
        }
        if (treeSet.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(I18n.trn("The following plugin is no longer necessary and has been deactivated:", "The following plugins are no longer necessary and have been deactivated:", treeSet.size()));
        stringBuilder.append("<ul>");
        for (DeprecatedPlugin deprecatedPlugin : treeSet) {
            stringBuilder.append("<li>").append(deprecatedPlugin.name);
            if (deprecatedPlugin.reason != null) {
                stringBuilder.append(" (").append(deprecatedPlugin.reason).append(")");
            }
            stringBuilder.append("</li>");
        }
        stringBuilder.append("</ul>");
        stringBuilder.append("</html>");
        JOptionPane.showMessageDialog(window, stringBuilder.toString(), I18n.tr("Warning"), 2);
    }

    private static void filterUnmaintainedPlugins(Window window, Collection<String> collection) {
        for (String string : UNMAINTAINED_PLUGINS) {
            if (!collection.contains(string)) continue;
            String string2 = I18n.tr("<html>Loading of the plugin \"{0}\" was requested.<br>This plugin is no longer developed and very likely will produce errors.<br>It should be disabled.<br>Delete from preferences?</html>", string);
            if (!PluginHandler.confirmDisablePlugin(window, string2, string)) continue;
            Main.pref.removeFromCollection("plugins", string);
            collection.remove(string);
        }
    }

    public static boolean checkAndConfirmPluginUpdate(Window window) {
        String string = null;
        String string2 = null;
        int n = Version.getInstance().getVersion();
        if (Main.pref.getInteger("pluginmanager.version", 0) < n) {
            string = "<html>" + I18n.tr("You updated your JOSM software.<br>To prevent problems the plugins should be updated as well.<br><br>Update plugins now?") + "</html>";
            string2 = "pluginmanager.version-based-update.policy";
        } else {
            long l = System.currentTimeMillis();
            long l2 = Main.pref.getLong("pluginmanager.lastupdate", 0L);
            Integer n2 = Main.pref.getInteger("pluginmanager.time-based-update.interval", 60);
            long l3 = (l - l2) / 86400000L;
            if (l2 <= 0L || n2 <= 0) {
                Main.pref.put("pluginmanager.lastupdate", Long.toString(l));
            } else if (l3 > (long)n2.intValue()) {
                string = "<html>" + I18n.tr("Last plugin update more than {0} days ago.", l3) + "</html>";
                string2 = "pluginmanager.time-based-update.policy";
            }
        }
        if (string == null) {
            return false;
        }
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Update plugins"), ImageProvider.get("dialogs", "refresh"), I18n.tr("Click to update the activated plugins"), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Skip update"), ImageProvider.get("cancel"), I18n.tr("Click to skip updating the activated plugins"), null)};
        UpdatePluginsMessagePanel updatePluginsMessagePanel = new UpdatePluginsMessagePanel();
        updatePluginsMessagePanel.setMessage(string);
        updatePluginsMessagePanel.initDontShowAgain(string2);
        String string3 = Main.pref.get(string2, "ask");
        string3 = string3.trim().toLowerCase();
        if (string3.equals("never")) {
            if ("pluginmanager.version-based-update.policy".equals(string2)) {
                System.out.println(I18n.tr("Skipping plugin update after JOSM upgrade. Automatic update at startup is disabled."));
            } else if ("pluginmanager.time-based-update.policy".equals(string2)) {
                System.out.println(I18n.tr("Skipping plugin update after elapsed update interval. Automatic update at startup is disabled."));
            }
            return false;
        }
        if (string3.equals("always")) {
            if ("pluginmanager.time-based-update.policy".equals(string2)) {
                System.out.println(I18n.tr("Running plugin update after JOSM upgrade. Automatic update at startup is enabled."));
            } else if ("pluginmanager.time-based-update.policy".equals(string2)) {
                System.out.println(I18n.tr("Running plugin update after elapsed update interval. Automatic update at startup is disabled."));
            }
            return true;
        }
        if (!string3.equals("ask")) {
            System.err.println(I18n.tr("Unexpected value ''{0}'' for preference ''{1}''. Assuming value ''ask''.", string3, string2));
        }
        int n3 = HelpAwareOptionPane.showOptionDialog(window, updatePluginsMessagePanel, I18n.tr("Update plugins"), 2, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/Preferences/Plugins#AutomaticUpdate"));
        if (updatePluginsMessagePanel.isRememberDecision()) {
            switch (n3) {
                case 0: {
                    Main.pref.put(string2, "always");
                    break;
                }
                case -1: 
                case 1: {
                    Main.pref.put(string2, "never");
                }
            }
        } else {
            Main.pref.put(string2, "ask");
        }
        return n3 == 0;
    }

    private static void alertMissingRequiredPlugin(Window window, String string, Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(I18n.trn("Plugin {0} requires a plugin which was not found. The missing plugin is:", "Plugin {0} requires {1} plugins which were not found. The missing plugins are:", set.size(), string, set.size()));
        stringBuilder.append("<ul>");
        for (String string2 : set) {
            stringBuilder.append("<li>").append(string2).append("</li>");
        }
        stringBuilder.append("</ul>").append("</html>");
        JOptionPane.showMessageDialog(window, stringBuilder.toString(), I18n.tr("Error"), 0);
    }

    private static void alertJOSMUpdateRequired(Window window, String string, int n) {
        HelpAwareOptionPane.showOptionDialog(window, I18n.tr("<html>Plugin {0} requires JOSM version {1}. The current JOSM version is {2}.<br>You have to update JOSM in order to use this plugin.</html>", string, n, Version.getInstance().getVersion()), I18n.tr("Warning"), 2, HelpUtil.ht("/Plugin/Loading#JOSMUpdateRequired"));
    }

    public static boolean checkLoadPreconditions(Window window, Collection<PluginInformation> collection, PluginInformation pluginInformation) {
        int n = Version.getInstance().getVersion();
        if (pluginInformation.mainversion > n && n != 0) {
            PluginHandler.alertJOSMUpdateRequired(window, pluginInformation.name, pluginInformation.mainversion);
            return false;
        }
        if (pluginInformation.requires != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (PluginInformation stringArray : collection) {
                hashSet.add(stringArray.name);
            }
            HashSet hashSet2 = new HashSet();
            for (String string : pluginInformation.requires.split(";")) {
                if (hashSet.contains(string)) continue;
                hashSet2.add(string);
            }
            if (!hashSet2.isEmpty()) {
                PluginHandler.alertMissingRequiredPlugin(window, pluginInformation.name, hashSet2);
                return false;
            }
        }
        return true;
    }

    public static ClassLoader createClassLoader(Collection<PluginInformation> collection) {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        File file = Main.pref.getPluginsDirectory();
        for (PluginInformation object2 : collection) {
            if (object2.libraries == null) continue;
            linkedList.addAll(object2.libraries);
            File file2 = new File(file, object2.name + ".jar");
            URL uRL = PluginInformation.fileToURL(file2);
            linkedList.add(uRL);
        }
        URL[] uRLArray = new URL[linkedList.size()];
        uRLArray = linkedList.toArray(uRLArray);
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, Main.class.getClassLoader());
        return uRLClassLoader;
    }

    public static void loadPlugin(Window window, PluginInformation pluginInformation, ClassLoader classLoader) {
        String string = I18n.tr("Could not load plugin {0}. Delete from preferences?", pluginInformation.name);
        try {
            Class<?> clazz = pluginInformation.loadClass(classLoader);
            if (clazz != null) {
                System.out.println(I18n.tr("loading plugin ''{0}'' (version {1})", pluginInformation.name, pluginInformation.localversion));
                pluginList.add(pluginInformation.load(clazz));
            }
            string = null;
        }
        catch (PluginException pluginException) {
            pluginException.printStackTrace();
            if (pluginException.getCause() instanceof ClassNotFoundException) {
                string = I18n.tr("<html>Could not load plugin {0} because the plugin<br>main class ''{1}'' was not found.<br>Delete from preferences?", pluginInformation.name, pluginInformation.className);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (string != null && PluginHandler.confirmDisablePlugin(window, string, pluginInformation.name)) {
            Main.pref.removeFromCollection("plugins", pluginInformation.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPlugins(Window window, Collection<PluginInformation> collection, ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask(I18n.tr("Loading plugins ..."));
            progressMonitor.subTask(I18n.tr("Checking plugin preconditions..."));
            LinkedList<PluginInformation> linkedList = new LinkedList<PluginInformation>();
            for (PluginInformation object : collection) {
                if (!PluginHandler.checkLoadPreconditions(window, collection, object)) continue;
                linkedList.add(object);
            }
            Collections.sort(linkedList, new Comparator<PluginInformation>(){

                @Override
                public int compare(PluginInformation pluginInformation, PluginInformation pluginInformation2) {
                    if (pluginInformation.stage < pluginInformation2.stage) {
                        return -1;
                    }
                    if (pluginInformation.stage == pluginInformation2.stage) {
                        return 0;
                    }
                    return 1;
                }
            });
            if (linkedList.isEmpty()) {
                return;
            }
            ClassLoader classLoader = PluginHandler.createClassLoader(linkedList);
            ImageProvider.sources.add(0, classLoader);
            progressMonitor.setTicksCount(linkedList.size());
            for (PluginInformation pluginInformation : linkedList) {
                progressMonitor.setExtraText(I18n.tr("Loading plugin ''{0}''...", pluginInformation.name));
                PluginHandler.loadPlugin(window, pluginInformation, classLoader);
                progressMonitor.worked(1);
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public static void loadEarlyPlugins(Window window, Collection<PluginInformation> collection, ProgressMonitor progressMonitor) {
        ArrayList<PluginInformation> arrayList = new ArrayList<PluginInformation>(collection.size());
        for (PluginInformation pluginInformation : collection) {
            if (!pluginInformation.early) continue;
            arrayList.add(pluginInformation);
        }
        PluginHandler.loadPlugins(window, arrayList, progressMonitor);
    }

    public static void loadLatePlugins(Window window, Collection<PluginInformation> collection, ProgressMonitor progressMonitor) {
        ArrayList<PluginInformation> arrayList = new ArrayList<PluginInformation>(collection.size());
        for (PluginInformation pluginInformation : collection) {
            if (pluginInformation.early) continue;
            arrayList.add(pluginInformation);
        }
        PluginHandler.loadPlugins(window, arrayList, progressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Map<String, PluginInformation> loadLocallyAvailablePluginInformation(ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            ReadLocalPluginInformationTask readLocalPluginInformationTask = new ReadLocalPluginInformationTask(progressMonitor);
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Future<?> future = executorService.submit(readLocalPluginInformationTask);
            try {
                future.get();
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
                Map<String, PluginInformation> map = null;
                progressMonitor.finishTask();
                return map;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                Map<String, PluginInformation> map = null;
                progressMonitor.finishTask();
                return map;
            }
            HashMap<String, PluginInformation> hashMap = new HashMap<String, PluginInformation>();
            for (PluginInformation pluginInformation : readLocalPluginInformationTask.getAvailablePlugins()) {
                hashMap.put(pluginInformation.name, pluginInformation);
            }
            HashMap<String, PluginInformation> hashMap2 = hashMap;
            return hashMap2;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private static void alertMissingPluginInformation(Window window, Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(I18n.trn("JOSM could not find information about the following plugin:", "JOSM could not find information about the following plugins:", collection.size()));
        stringBuilder.append("<ul>");
        for (String string : collection) {
            stringBuilder.append("<li>").append(string).append("</li>");
        }
        stringBuilder.append("</ul>");
        stringBuilder.append(I18n.trn("The plugin is not going to be loaded.", "The plugins are not going to be loaded.", collection.size()));
        stringBuilder.append("</html>");
        HelpAwareOptionPane.showOptionDialog(window, stringBuilder.toString(), I18n.tr("Warning"), 2, HelpUtil.ht("/Plugin/Loading#MissingPluginInfos"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PluginInformation> buildListOfPluginsToLoad(Window window, ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask(I18n.tr("Determine plugins to load..."));
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(Main.pref.getCollection("plugins", new LinkedList<String>()));
            if (System.getProperty("josm.plugins") != null) {
                hashSet.addAll(Arrays.asList(System.getProperty("josm.plugins").split(",")));
            }
            progressMonitor.subTask(I18n.tr("Removing deprecated plugins..."));
            PluginHandler.filterDeprecatedPlugins(window, hashSet);
            progressMonitor.subTask(I18n.tr("Removing unmaintained plugins..."));
            PluginHandler.filterUnmaintainedPlugins(window, hashSet);
            Map<String, PluginInformation> map = PluginHandler.loadLocallyAvailablePluginInformation(progressMonitor.createSubTaskMonitor(1, false));
            LinkedList<PluginInformation> linkedList = new LinkedList<PluginInformation>();
            Object object = hashSet.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (!map.containsKey(string)) continue;
                linkedList.add(map.get(string));
                object.remove();
            }
            if (!hashSet.isEmpty()) {
                PluginHandler.alertMissingPluginInformation(window, hashSet);
            }
            object = linkedList;
            return object;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private static void alertFailedPluginUpdate(Window window, Collection<PluginInformation> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append(I18n.trn("Updating the following plugin has failed:", "Updating the following plugins has failed:", collection.size()));
        stringBuffer.append("<ul>");
        for (PluginInformation pluginInformation : collection) {
            stringBuffer.append("<li>").append(pluginInformation.name).append("</li>");
        }
        stringBuffer.append("</ul>");
        stringBuffer.append(I18n.trn("Please open the Preference Dialog after JOSM has started and try to update it manually.", "Please open the Preference Dialog after JOSM has started and try to update them manually.", collection.size()));
        stringBuffer.append("</html>");
        HelpAwareOptionPane.showOptionDialog(window, stringBuffer.toString(), I18n.tr("Plugin update failed"), 0, HelpUtil.ht("/Plugin/Loading#FailedPluginUpdated"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public static List<PluginInformation> updatePlugins(Window window, List<PluginInformation> list, ProgressMonitor progressMonitor) throws IllegalArgumentException {
        block14: {
            CheckParameterUtil.ensureParameterNotNull(list, "plugins");
            if (progressMonitor == null) {
                progressMonitor = NullProgressMonitor.INSTANCE;
            }
            try {
                progressMonitor.beginTask("");
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                ReadRemotePluginInformationTask readRemotePluginInformationTask = new ReadRemotePluginInformationTask(progressMonitor.createSubTaskMonitor(1, false), Main.pref.getPluginSites());
                Future<?> future = executorService.submit(readRemotePluginInformationTask);
                try {
                    future.get();
                    list = PluginHandler.buildListOfPluginsToLoad(window, progressMonitor.createSubTaskMonitor(1, false));
                }
                catch (ExecutionException executionException) {
                    System.out.println(I18n.tr("Warning: failed to download plugin information list"));
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    System.out.println(I18n.tr("Warning: failed to download plugin information list"));
                    interruptedException.printStackTrace();
                }
                ArrayList<PluginInformation> arrayList = new ArrayList<PluginInformation>();
                for (Object object : list) {
                    if (!((PluginInformation)object).isUpdateRequired()) continue;
                    arrayList.add((PluginInformation)object);
                }
                if (arrayList.isEmpty()) break block14;
                PluginDownloadTask pluginDownloadTask = new PluginDownloadTask(progressMonitor.createSubTaskMonitor(1, false), arrayList, I18n.tr("Update plugins"));
                future = executorService.submit(pluginDownloadTask);
                try {
                    future.get();
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                    PluginHandler.alertFailedPluginUpdate(window, arrayList);
                    List<PluginInformation> list2 = list;
                    progressMonitor.finishTask();
                    return list2;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    PluginHandler.alertFailedPluginUpdate(window, arrayList);
                    List<PluginInformation> list3 = list;
                    progressMonitor.finishTask();
                    return list3;
                }
                if (!pluginDownloadTask.getFailedPlugins().isEmpty()) {
                    Object object;
                    PluginHandler.alertFailedPluginUpdate(window, pluginDownloadTask.getFailedPlugins());
                    object = list;
                    return object;
                }
                break block14;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                progressMonitor.finishTask();
            }
        }
        Main.pref.putInteger("pluginmanager.version", Version.getInstance().getVersion());
        Main.pref.put("pluginmanager.lastupdate", Long.toString(System.currentTimeMillis()));
        return list;
    }

    public static boolean confirmDisablePlugin(Window window, String string, String string2) {
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Disable plugin"), ImageProvider.get("dialogs", "delete"), I18n.tr("Click to delete the plugin ''{0}''", string2), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Keep plugin"), ImageProvider.get("cancel"), I18n.tr("Click to keep the plugin ''{0}''", string2), null)};
        int n = HelpAwareOptionPane.showOptionDialog(window, string, I18n.tr("Disable plugin"), 2, null, buttonSpecArray, buttonSpecArray[0], null);
        return n == 0;
    }

    public static void notifyMapFrameChanged(MapFrame mapFrame, MapFrame mapFrame2) {
        for (PluginProxy pluginProxy : pluginList) {
            pluginProxy.mapFrameInitialized(mapFrame, mapFrame2);
        }
    }

    public static Object getPlugin(String string) {
        for (PluginProxy pluginProxy : pluginList) {
            if (!pluginProxy.getPluginInformation().name.equals(string)) continue;
            return pluginProxy.plugin;
        }
        return null;
    }

    public static void addDownloadSelection(List<DownloadSelection> list) {
        for (PluginProxy pluginProxy : pluginList) {
            pluginProxy.addDownloadSelection(list);
        }
    }

    public static void getPreferenceSetting(Collection<PreferenceSettingFactory> collection) {
        for (PluginProxy pluginProxy : pluginList) {
            collection.add(new PluginPreferenceFactory(pluginProxy));
        }
    }

    public static void installDownloadedPlugins(boolean bl) {
        File[] fileArray;
        File file = Main.pref.getPluginsDirectory();
        if (!(file.exists() && file.isDirectory() && file.canWrite())) {
            return;
        }
        for (File file2 : fileArray = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".jar.new");
            }
        })) {
            String string = file2.getPath();
            File file3 = new File(string.substring(0, string.length() - 4));
            String string2 = file2.getName().substring(0, file2.getName().length() - 8);
            if (file3.exists() && !file3.delete() && bl) {
                System.err.println(I18n.tr("Warning: failed to delete outdated plugin ''{0}''.", file3.toString()));
                System.err.println(I18n.tr("Warning: failed to install already downloaded plugin ''{0}''. Skipping installation. JOSM is still going to load the old plugin version.", string2));
                continue;
            }
            if (file2.renameTo(file3) || !bl) continue;
            System.err.println(I18n.tr("Warning: failed to install plugin ''{0}'' from temporary download file ''{1}''. Renaming failed.", file3.toString(), file2.toString()));
            System.err.println(I18n.tr("Warning: failed to install already downloaded plugin ''{0}''. Skipping installation. JOSM is still going to load the old plugin version.", string2));
        }
    }

    private static boolean confirmDeactivatingPluginAfterException(PluginProxy pluginProxy) {
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Disable plugin"), ImageProvider.get("dialogs", "delete"), I18n.tr("Click to disable the plugin ''{0}''", pluginProxy.getPluginInformation().name), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Keep plugin"), ImageProvider.get("cancel"), I18n.tr("Click to keep the plugin ''{0}''", pluginProxy.getPluginInformation().name), null)};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append(I18n.tr("An unexpected exception occurred that may have come from the ''{0}'' plugin.", pluginProxy.getPluginInformation().name));
        stringBuffer.append("<br>");
        if (pluginProxy.getPluginInformation().author != null) {
            stringBuffer.append(I18n.tr("According to the information within the plugin, the author is {0}.", pluginProxy.getPluginInformation().author));
            stringBuffer.append("<br>");
        }
        stringBuffer.append(I18n.tr("Try updating to the newest version of this plugin before reporting a bug."));
        stringBuffer.append("<br>");
        stringBuffer.append(I18n.tr("Should the plugin be disabled?"));
        stringBuffer.append("</html>");
        int n = HelpAwareOptionPane.showOptionDialog(Main.parent, stringBuffer.toString(), I18n.tr("Update plugins"), 3, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/ErrorMessages#ErrorInPlugin"));
        return n == 0;
    }

    private static PluginProxy getPluginCausingException(Throwable throwable) {
        for (PluginProxy pluginProxy : pluginList) {
            String string = pluginProxy.getPluginInformation().className;
            int n = string.lastIndexOf(".");
            string = string.substring(0, n);
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                String string2 = stackTraceElement.getClassName();
                if (!string2.startsWith(string)) continue;
                return pluginProxy;
            }
        }
        return null;
    }

    public static void disablePluginAfterException(Throwable throwable) {
        PluginProxy pluginProxy = null;
        if (throwable instanceof PluginException) {
            pluginProxy = ((PluginException)throwable).plugin;
        }
        if (pluginProxy == null) {
            pluginProxy = PluginHandler.getPluginCausingException(throwable);
        }
        if (pluginProxy == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>(Main.pref.getCollection("plugins", Collections.<String>emptySet()));
        if (!hashSet.contains(pluginProxy.getPluginInformation().name)) {
            return;
        }
        if (!PluginHandler.confirmDeactivatingPluginAfterException(pluginProxy)) {
            return;
        }
        hashSet.remove(pluginProxy.getPluginInformation().name);
        Main.pref.putCollection("plugins", hashSet);
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("The plugin has been removed from the configuration. Please restart JOSM to unload the plugin."), I18n.tr("Information"), 1);
    }

    public static String getBugReportText() {
        String string = "";
        LinkedList<String> linkedList = new LinkedList<String>(Main.pref.getCollection("plugins", new LinkedList<String>()));
        for (PluginProxy object : pluginList) {
            PluginInformation pluginInformation = object.getPluginInformation();
            linkedList.remove(pluginInformation.name);
            linkedList.add(pluginInformation.name + " (" + (pluginInformation.localversion != null && !pluginInformation.localversion.equals("") ? pluginInformation.localversion : "unknown") + ")");
        }
        Collections.sort(linkedList);
        for (String string2 : linkedList) {
            string = string + "Plugin: " + string2 + "\n";
        }
        return string;
    }

    public static JPanel getInfoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        for (PluginProxy pluginProxy : pluginList) {
            final PluginInformation pluginInformation = pluginProxy.getPluginInformation();
            String string = pluginInformation.name + (pluginInformation.version != null && !pluginInformation.version.equals("") ? " Version: " + pluginInformation.version : "");
            jPanel.add((Component)new JLabel(string), GBC.std());
            jPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
            jPanel.add((Component)new JButton(new AbstractAction(I18n.tr("Information")){

                public void actionPerformed(ActionEvent actionEvent) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Map.Entry<String, String> entry : pluginInformation.attr.entrySet()) {
                        stringBuilder.append(entry.getKey());
                        stringBuilder.append(": ");
                        stringBuilder.append(entry.getValue());
                        stringBuilder.append("\n");
                    }
                    JTextArea jTextArea = new JTextArea(10, 40);
                    jTextArea.setEditable(false);
                    jTextArea.setText(stringBuilder.toString());
                    JOptionPane.showMessageDialog(Main.parent, new JScrollPane(jTextArea), I18n.tr("Plugin information"), 1);
                }
            }), GBC.eol());
            JTextArea jTextArea = new JTextArea(pluginInformation.description == null ? I18n.tr("no description available") : pluginInformation.description);
            jTextArea.setEditable(false);
            jTextArea.setFont(new JLabel().getFont().deriveFont(2));
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            jTextArea.setBackground(UIManager.getColor("Panel.background"));
            jPanel.add((Component)jTextArea, GBC.eop().fill(2));
        }
        return jPanel;
    }

    static {
        String string = I18n.tr("integrated into main program");
        class RemotecontrolMigration
        implements Runnable {
            RemotecontrolMigration() {
            }

            public void run() {
                System.out.println("Migrating remotecontrol plugin...");
                if (!RemoteControl.PROP_REMOTECONTROL_ENABLED.isSet()) {
                    System.out.println("  Setting " + RemoteControl.PROP_REMOTECONTROL_ENABLED.getKey() + "=true");
                    RemoteControl.PROP_REMOTECONTROL_ENABLED.put(true);
                }
                System.out.println("...Done.");
            }
        }
        DEPRECATED_PLUGINS = Arrays.asList(new DeprecatedPlugin("mappaint", string), new DeprecatedPlugin("unglueplugin", string), new DeprecatedPlugin("lang-de", string), new DeprecatedPlugin("lang-en_GB", string), new DeprecatedPlugin("lang-fr", string), new DeprecatedPlugin("lang-it", string), new DeprecatedPlugin("lang-pl", string), new DeprecatedPlugin("lang-ro", string), new DeprecatedPlugin("lang-ru", string), new DeprecatedPlugin("ewmsplugin", string), new DeprecatedPlugin("ywms", string), new DeprecatedPlugin("tways-0.2", string), new DeprecatedPlugin("geotagged", string), new DeprecatedPlugin("landsat", I18n.tr("replaced by new {0} plugin", "lakewalker")), new DeprecatedPlugin("namefinder", string), new DeprecatedPlugin("waypoints", string), new DeprecatedPlugin("slippy_map_chooser", string), new DeprecatedPlugin("tcx-support", I18n.tr("replaced by new {0} plugin", "dataimport")), new DeprecatedPlugin("usertools", string), new DeprecatedPlugin("AgPifoJ", string), new DeprecatedPlugin("utilsplugin", string), new DeprecatedPlugin("ghost", string), new DeprecatedPlugin("validator", string), new DeprecatedPlugin("multipoly", string), new DeprecatedPlugin("remotecontrol", string, new RemotecontrolMigration()), new DeprecatedPlugin("imagery", string), new DeprecatedPlugin("slippymap", string), new DeprecatedPlugin("wmsplugin", string));
        UNMAINTAINED_PLUGINS = new String[]{"gpsbabelgui", "Intersect_way"};
        pluginList = new LinkedList<PluginProxy>();
    }

    private static class UpdatePluginsMessagePanel
    extends JPanel {
        private JMultilineLabel lblMessage;
        private JCheckBox cbDontShowAgain;

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.lblMessage = new JMultilineLabel("");
            this.add((Component)this.lblMessage, gridBagConstraints);
            this.lblMessage.setFont(this.lblMessage.getFont().deriveFont(0));
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 0.0;
            this.cbDontShowAgain = new JCheckBox(I18n.tr("Do not ask again and remember my decision (go to Preferences->Plugins to change it later)"));
            this.add((Component)this.cbDontShowAgain, gridBagConstraints);
            this.cbDontShowAgain.setFont(this.cbDontShowAgain.getFont().deriveFont(0));
        }

        public UpdatePluginsMessagePanel() {
            this.build();
        }

        public void setMessage(String string) {
            this.lblMessage.setText(string);
        }

        public void initDontShowAgain(String string) {
            String string2 = Main.pref.get(string, "ask");
            this.cbDontShowAgain.setSelected(!(string2 = string2.trim().toLowerCase()).equals("ask"));
        }

        public boolean isRememberDecision() {
            return this.cbDontShowAgain.isSelected();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeprecatedPlugin
    implements Comparable<DeprecatedPlugin> {
        public String name;
        public String reason;
        private Runnable migration;

        public DeprecatedPlugin(String string) {
            this.name = string;
        }

        public DeprecatedPlugin(String string, String string2) {
            this.name = string;
            this.reason = string2;
        }

        public DeprecatedPlugin(String string, String string2, Runnable runnable) {
            this.name = string;
            this.reason = string2;
            this.migration = runnable;
        }

        public void migrate() {
            if (this.migration != null) {
                this.migration.run();
            }
        }

        @Override
        public int compareTo(DeprecatedPlugin deprecatedPlugin) {
            return this.name.compareTo(deprecatedPlugin.name);
        }
    }
}

