/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.net.URLDecoder;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

public class ImportHandler
extends RequestHandler {
    public static final String command = "import";
    public static final String permissionKey = "remotecontrol.permission.import";
    public static final boolean permissionDefault = true;

    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        try {
            DownloadOsmTask downloadOsmTask = new DownloadOsmTask();
            downloadOsmTask.loadUrl(false, URLDecoder.decode((String)this.args.get("url"), "UTF-8"), null);
        }
        catch (Exception exception) {
            System.out.println("RemoteControl: Error parsing import remote control request:");
            exception.printStackTrace();
            throw new RequestHandler.RequestHandlerErrorException();
        }
    }

    protected String[] getMandatoryParams() {
        return new String[]{"url"};
    }

    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to import data from the following URL:") + "<br>" + this.request;
    }

    public PermissionPrefWithDefault getPermissionPref() {
        return new PermissionPrefWithDefault(permissionKey, true, "RemoteControl: import forbidden by preferences");
    }
}

