/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.GeorefImage;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.io.imagery.Grabber;
import org.openstreetmap.josm.io.imagery.WMSRequest;
import org.openstreetmap.josm.tools.I18n;

public class WMSGrabber
extends Grabber {
    protected String baseURL;
    private final boolean urlWithPatterns;
    public static final NumberFormat latLonFormat = new DecimalFormat("###0.0000000", new DecimalFormatSymbols(Locale.US));

    public WMSGrabber(MapView mapView, WMSLayer wMSLayer) {
        super(mapView, wMSLayer);
        this.baseURL = wMSLayer.getInfo().getURL();
        this.urlWithPatterns = ImageryInfo.isUrlWithPatterns(this.baseURL);
    }

    void fetch(WMSRequest wMSRequest, int n) throws Exception {
        URL uRL = null;
        try {
            uRL = this.getURL(this.b.min.east(), this.b.min.north(), this.b.max.east(), this.b.max.north(), this.width(), this.height());
            wMSRequest.finish(GeorefImage.State.IMAGE, this.grab(uRL, n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception(exception.getMessage() + "\nImage couldn't be fetched: " + (uRL != null ? uRL.toString() : ""));
        }
    }

    protected URL getURL(double d, double d2, double d3, double d4, int n, int n2) throws MalformedURLException {
        Object object;
        Object object2;
        String string = Main.proj.toCode();
        if (Main.proj instanceof Mercator) {
            object2 = Main.proj.eastNorth2latlon(new EastNorth(d, d2));
            object = Main.proj.eastNorth2latlon(new EastNorth(d3, d4));
            string = "EPSG:4326";
            d2 = ((LatLon)object2).lat();
            d = ((LatLon)object2).lon();
            d4 = ((LatLon)object).lat();
            d3 = ((LatLon)object).lon();
        }
        object2 = this.baseURL;
        object = latLonFormat.format(d) + "," + latLonFormat.format(d2) + "," + latLonFormat.format(d3) + "," + latLonFormat.format(d4);
        if (this.urlWithPatterns) {
            object2 = ((String)object2).replaceAll("\\{proj\\}", string).replaceAll("\\{bbox\\}", (String)object).replaceAll("\\{w\\}", latLonFormat.format(d)).replaceAll("\\{s\\}", latLonFormat.format(d2)).replaceAll("\\{e\\}", latLonFormat.format(d3)).replaceAll("\\{n\\}", latLonFormat.format(d4)).replaceAll("\\{width\\}", String.valueOf(n)).replaceAll("\\{height\\}", String.valueOf(n2));
        } else {
            object2 = (String)object2 + "bbox=" + (String)object + WMSGrabber.getProjection(this.baseURL, false) + "&width=" + n + "&height=" + n2;
            if (!this.baseURL.endsWith("&") && !this.baseURL.endsWith("?")) {
                System.out.println(I18n.tr("Warning: The base URL ''{0}'' for a WMS service doesn't have a trailing '&' or a trailing '?'.", this.baseURL));
                System.out.println(I18n.tr("Warning: Fetching WMS tiles is likely to fail. Please check you preference settings."));
                System.out.println(I18n.tr("Warning: The complete URL is ''{0}''.", object2));
            }
        }
        return new URL(((String)object2).replace(" ", "%20"));
    }

    public static String getProjection(String string, Boolean bl) {
        String string2 = Main.proj.toCode();
        if (Main.proj instanceof Mercator) {
            string2 = "EPSG:4326";
        }
        String string3 = "";
        try {
            Matcher matcher = Pattern.compile(".*srs=([a-z0-9:]+).*").matcher(string.toLowerCase());
            if (matcher.matches()) {
                if (!(string2 = string2.toLowerCase()).equals(matcher.group(1)) && bl.booleanValue()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("The projection ''{0}'' in URL and current projection ''{1}'' mismatch.\nThis may lead to wrong coordinates.", matcher.group(1), string2), I18n.tr("Warning"), 2);
                }
            } else {
                string3 = "&srs=" + string2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
    }

    public boolean loadFromCache(WMSRequest wMSRequest) {
        URL uRL = null;
        try {
            uRL = this.getURL(this.b.min.east(), this.b.min.north(), this.b.max.east(), this.b.max.north(), this.width(), this.height());
        }
        catch (Exception exception) {
            return false;
        }
        BufferedImage bufferedImage = cache.getImg(uRL.toString());
        if (!wMSRequest.isReal() && !this.layer.hasAutoDownload() || bufferedImage != null) {
            if (bufferedImage == null) {
                wMSRequest.finish(GeorefImage.State.NOT_IN_CACHE, null);
                return true;
            }
            wMSRequest.finish(GeorefImage.State.IMAGE, bufferedImage);
            return true;
        }
        return false;
    }

    protected BufferedImage grab(URL uRL, int n) throws IOException, OsmTransferException {
        System.out.println("Grabbing WMS " + (n > 1 ? "(attempt " + n + ") " : "") + uRL);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        if (this.layer.getInfo().getCookies() != null && !this.layer.getInfo().getCookies().equals("")) {
            httpURLConnection.setRequestProperty("Cookie", this.layer.getInfo().getCookies());
        }
        httpURLConnection.setRequestProperty("User-Agent", Main.pref.get("imagery.wms.user_agent", Version.getInstance().getAgentString()));
        httpURLConnection.setConnectTimeout(Main.pref.getInteger("imagery.wms.timeout.connect", 30) * 1000);
        httpURLConnection.setReadTimeout(Main.pref.getInteger("imagery.wms.timeout.read", 30) * 1000);
        String string = httpURLConnection.getHeaderField("Content-Type");
        if (httpURLConnection.getResponseCode() != 200 || string != null && !string.startsWith("image")) {
            throw new IOException(this.readException(httpURLConnection));
        }
        ProgressInputStream progressInputStream = new ProgressInputStream(httpURLConnection, null);
        BufferedImage bufferedImage = ImageIO.read(progressInputStream);
        ((InputStream)progressInputStream).close();
        cache.saveImg(uRL.toString(), bufferedImage);
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readException(URLConnection uRLConnection) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        InputStream inputStream = uRLConnection.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string.replaceAll("[^\\p{Print}]", ""));
                stringBuilder.append('\n');
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            bufferedReader.close();
        }
    }
}

