/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.CredentialsManagerException;
import org.openstreetmap.josm.io.auth.CredentialsManagerResponse;

public class DefaultAuthenticator
extends Authenticator {
    private static final Logger logger = Logger.getLogger(DefaultAuthenticator.class.getName());
    private static DefaultAuthenticator instance;
    private CredentialsManager credentialManager;
    private final Map<Authenticator.RequestorType, Boolean> credentialsTried = new HashMap<Authenticator.RequestorType, Boolean>();
    private boolean enabled = true;

    public static DefaultAuthenticator getInstance() {
        return instance;
    }

    public static void createInstance(CredentialsManager credentialsManager) {
        instance = new DefaultAuthenticator(credentialsManager);
    }

    private DefaultAuthenticator(CredentialsManager credentialsManager) {
        this.credentialManager = credentialsManager;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        if (!this.enabled) {
            return null;
        }
        try {
            String string;
            if (this.getRequestorType().equals((Object)Authenticator.RequestorType.SERVER) && (string = Main.pref.get("osm-server.auth-method", "basic")).equals("oauth")) {
                return null;
            }
            boolean bl = this.credentialsTried.get((Object)this.getRequestorType()) != null;
            CredentialsManagerResponse credentialsManagerResponse = this.credentialManager.getCredentials(this.getRequestorType(), bl);
            if (credentialsManagerResponse == null || credentialsManagerResponse.isCanceled()) {
                return null;
            }
            this.credentialsTried.put(this.getRequestorType(), true);
            return new PasswordAuthentication(credentialsManagerResponse.getUsername(), credentialsManagerResponse.getPassword());
        }
        catch (CredentialsManagerException credentialsManagerException) {
            credentialsManagerException.printStackTrace();
            return null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }
}

