/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.preferences.AddWMSLayerPanel;
import org.openstreetmap.josm.gui.preferences.ImagerySettingsMigration;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.io.imagery.HTMLGrabber;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ImageryPreference
implements PreferenceSetting {
    ImageryProvidersPanel imageryProviders;
    static ImagerySettingsMigration settingsMigration;
    private Color colFadeColor;
    private JButton btnFadeColor;
    private JSlider fadeAmount = new JSlider(0, 100);
    private JComboBox sharpen;
    private JComboBox browser;
    JCheckBox overlapCheckBox;
    JSpinner spinEast;
    JSpinner spinNorth;
    JSpinner spinSimConn;
    private JCheckBox autozoomActive = new JCheckBox();
    private JCheckBox autoloadTiles = new JCheckBox();
    private JSpinner minZoomLvl;
    private JSpinner maxZoomLvl;
    private JCheckBox addToSlippyMapChosser = new JCheckBox();

    private JPanel buildCommonSettingsPanel(final PreferenceTabbedPane preferenceTabbedPane) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.colFadeColor = ImageryLayer.getFadeColor();
        this.btnFadeColor = new JButton();
        this.btnFadeColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JColorChooser jColorChooser = new JColorChooser(ImageryPreference.this.colFadeColor);
                int n = JOptionPane.showConfirmDialog(preferenceTabbedPane, jColorChooser, I18n.tr("Choose a color for {0}", I18n.tr("imagery fade")), 2, -1);
                if (n == 0) {
                    ImageryPreference.this.colFadeColor = jColorChooser.getColor();
                    ImageryPreference.this.btnFadeColor.setBackground(ImageryPreference.this.colFadeColor);
                    ImageryPreference.this.btnFadeColor.setText(ColorHelper.color2html(ImageryPreference.this.colFadeColor));
                }
            }
        });
        jPanel.add((Component)new JLabel(I18n.tr("Fade Color: ")), GBC.std());
        jPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        jPanel.add((Component)this.btnFadeColor, GBC.eol().fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("Fade amount: ")), GBC.std());
        jPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        jPanel.add((Component)this.fadeAmount, GBC.eol().fill(2));
        this.sharpen = new JComboBox<String>(new String[]{I18n.tr("None"), I18n.tr("Soft"), I18n.tr("Strong")});
        jPanel.add(new JLabel(I18n.tr("Sharpen (requires layer re-add): ")));
        jPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        jPanel.add((Component)this.sharpen, GBC.eol().fill(2));
        if (settingsMigration != null) {
            final JButton jButton = new JButton(I18n.tr("WMSPlugin/SlippyMap settings migration"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (settingsMigration == null) {
                        return;
                    }
                    settingsMigration.settingsMigrationDialog(preferenceTabbedPane);
                    ImageryPreference.this.loadSettings();
                    ImageryPreference.this.imageryProviders.model.fireTableDataChanged();
                    if (!settingsMigration.hasConflicts()) {
                        jButton.setEnabled(false);
                        settingsMigration = null;
                    }
                }
            });
            jPanel.add((Component)jButton, GBC.eol().insets(0, 5, 0, 5));
        }
        return jPanel;
    }

    private JPanel buildWMSSettingsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.browser = new JComboBox<String>(new String[]{"webkit-image {0}", "gnome-web-photo --mode=photo --format=png {0} /dev/stdout", "gnome-web-photo-fixed {0}", "webkit-image-gtk {0}"});
        this.browser.setEditable(true);
        jPanel.add((Component)new JLabel(I18n.tr("Downloader:")), GBC.eol().fill(2));
        jPanel.add(this.browser);
        jPanel.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        this.overlapCheckBox = new JCheckBox(I18n.tr("Overlap tiles"));
        JLabel jLabel = new JLabel(I18n.tr("% of east:"));
        JLabel jLabel2 = new JLabel(I18n.tr("% of north:"));
        this.spinEast = new JSpinner(new SpinnerNumberModel(WMSLayer.PROP_OVERLAP_EAST.get(), 1, 50, 1));
        this.spinNorth = new JSpinner(new SpinnerNumberModel(WMSLayer.PROP_OVERLAP_NORTH.get(), 1, 50, 1));
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(this.overlapCheckBox);
        jPanel2.add(jLabel);
        jPanel2.add(this.spinEast);
        jPanel2.add(jLabel2);
        jPanel2.add(this.spinNorth);
        jPanel.add(jPanel2);
        jPanel.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        JLabel jLabel3 = new JLabel(I18n.tr("Simultaneous connections"));
        this.spinSimConn = new JSpinner(new SpinnerNumberModel(WMSLayer.PROP_SIMULTANEOUS_CONNECTIONS.get(), 1, 30, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(jLabel3);
        jPanel3.add(this.spinSimConn);
        jPanel.add((Component)jPanel3, GBC.eol().fill(2));
        return jPanel;
    }

    private JPanel buildTMSSettingsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.minZoomLvl = new JSpinner(new SpinnerNumberModel(2, 2, 30, 1));
        this.maxZoomLvl = new JSpinner(new SpinnerNumberModel(18, 2, 30, 1));
        jPanel.add((Component)new JLabel(I18n.tr("Auto zoom by default: ")), GBC.std());
        jPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        jPanel.add((Component)this.autozoomActive, GBC.eol().fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("Autoload tiles by default: ")), GBC.std());
        jPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        jPanel.add((Component)this.autoloadTiles, GBC.eol().fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("Min zoom lvl: ")), GBC.std());
        jPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        jPanel.add((Component)this.minZoomLvl, GBC.eol().fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("Max zoom lvl: ")), GBC.std());
        jPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        jPanel.add((Component)this.maxZoomLvl, GBC.eol().fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("Add to slippymap chooser: ")), GBC.std());
        jPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        jPanel.add((Component)this.addToSlippyMapChosser, GBC.eol().fill(2));
        return jPanel;
    }

    private void addSettingsSection(JPanel jPanel, String string, JPanel jPanel2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel.add((Component)jLabel, GBC.std());
        jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(5, 0, 0, 0));
        jPanel.add((Component)jPanel2, GBC.eol().insets(20, 5, 0, 10));
    }

    private Component buildSettingsPanel(PreferenceTabbedPane preferenceTabbedPane) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addSettingsSection(jPanel, I18n.tr("Common Settings"), this.buildCommonSettingsPanel(preferenceTabbedPane));
        this.addSettingsSection(jPanel, I18n.tr("WMS Settings"), this.buildWMSSettingsPanel());
        this.addSettingsSection(jPanel, I18n.tr("TMS Settings"), this.buildTMSSettingsPanel());
        jPanel.add((Component)new JPanel(), GBC.eol().fill(1));
        return new JScrollPane(jPanel);
    }

    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        JPanel jPanel = preferenceTabbedPane.createPreferenceTab("imagery", I18n.tr("Imagery Preferences"), I18n.tr("Modify list of imagery layers displayed in the Imagery menu"));
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.imageryProviders = new ImageryProvidersPanel(preferenceTabbedPane, ImageryLayerInfo.instance);
        jTabbedPane.add(this.imageryProviders);
        jTabbedPane.add(this.buildSettingsPanel(preferenceTabbedPane));
        jTabbedPane.add(new OffsetBookmarksPanel(preferenceTabbedPane));
        this.loadSettings();
        jTabbedPane.setTitleAt(0, I18n.tr("Imagery providers"));
        jTabbedPane.setTitleAt(1, I18n.tr("Settings"));
        jTabbedPane.setTitleAt(2, I18n.tr("Offset bookmarks"));
        jPanel.add((Component)jTabbedPane, GBC.std().fill(1));
    }

    private void loadSettings() {
        this.btnFadeColor.setBackground(this.colFadeColor);
        this.btnFadeColor.setText(ColorHelper.color2html(this.colFadeColor));
        this.fadeAmount.setValue(ImageryLayer.PROP_FADE_AMOUNT.get());
        this.sharpen.setSelectedIndex(Math.max(0, Math.min(2, ImageryLayer.PROP_SHARPEN_LEVEL.get())));
        this.browser.setSelectedItem(HTMLGrabber.PROP_BROWSER.get());
        this.overlapCheckBox.setSelected(WMSLayer.PROP_OVERLAP.get());
        this.spinEast.setValue(WMSLayer.PROP_OVERLAP_EAST.get());
        this.spinNorth.setValue(WMSLayer.PROP_OVERLAP_NORTH.get());
        this.spinSimConn.setValue(WMSLayer.PROP_SIMULTANEOUS_CONNECTIONS.get());
        this.autozoomActive.setSelected(TMSLayer.PROP_DEFAULT_AUTOZOOM.get());
        this.autoloadTiles.setSelected(TMSLayer.PROP_DEFAULT_AUTOLOAD.get());
        this.addToSlippyMapChosser.setSelected(TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.get());
        this.maxZoomLvl.setValue(TMSLayer.getMaxZoomLvl(null));
        this.minZoomLvl.setValue(TMSLayer.getMinZoomLvl(null));
    }

    public boolean ok() {
        boolean bl = false;
        ImageryLayerInfo.instance.save();
        Main.main.menu.imageryMenu.refreshImageryMenu();
        Main.main.menu.imageryMenu.refreshOffsetMenu();
        OffsetBookmark.saveBookmarks();
        WMSLayer.PROP_OVERLAP.put(this.overlapCheckBox.getModel().isSelected());
        WMSLayer.PROP_OVERLAP_EAST.put((Integer)this.spinEast.getModel().getValue());
        WMSLayer.PROP_OVERLAP_NORTH.put((Integer)this.spinNorth.getModel().getValue());
        WMSLayer.PROP_SIMULTANEOUS_CONNECTIONS.put((Integer)this.spinSimConn.getModel().getValue());
        HTMLGrabber.PROP_BROWSER.put(this.browser.getEditor().getItem().toString());
        if (TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.get() != this.addToSlippyMapChosser.isSelected()) {
            bl = true;
        }
        TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.put(this.addToSlippyMapChosser.isSelected());
        TMSLayer.PROP_DEFAULT_AUTOZOOM.put(this.autozoomActive.isSelected());
        TMSLayer.PROP_DEFAULT_AUTOLOAD.put(this.autoloadTiles.isSelected());
        TMSLayer.setMaxZoomLvl((Integer)this.maxZoomLvl.getValue());
        TMSLayer.setMinZoomLvl((Integer)this.minZoomLvl.getValue());
        ImageryLayer.PROP_FADE_AMOUNT.put(this.fadeAmount.getValue());
        ImageryLayer.setFadeColor(this.colFadeColor);
        ImageryLayer.PROP_SHARPEN_LEVEL.put(this.sharpen.getSelectedIndex());
        return bl;
    }

    public void setServerUrl(String string, String string2) {
        for (int i = 0; i < this.imageryProviders.model.getRowCount(); ++i) {
            if (!string.equals(this.imageryProviders.model.getValueAt(i, 0).toString())) continue;
            this.imageryProviders.model.setValueAt(string2, i, 1);
            return;
        }
        this.imageryProviders.model.addRow(new String[]{string, string2});
    }

    public String getServerUrl(String string) {
        for (int i = 0; i < this.imageryProviders.model.getRowCount(); ++i) {
            if (!string.equals(this.imageryProviders.model.getValueAt(i, 0).toString())) continue;
            return this.imageryProviders.model.getValueAt(i, 1).toString();
        }
        return null;
    }

    public static void initialize() {
        settingsMigration = new ImagerySettingsMigration();
        settingsMigration.migrateSettings();
        if (!settingsMigration.hasConflicts()) {
            settingsMigration = null;
        }
        ImageryLayerInfo.instance.load();
        OffsetBookmark.loadBookmarks();
        Main.main.menu.imageryMenu.refreshImageryMenu();
        Main.main.menu.imageryMenu.refreshOffsetMenu();
    }

    static class OffsetBookmarksPanel
    extends JPanel {
        List<OffsetBookmark> bookmarks = OffsetBookmark.allBookmarks;
        OffsetsBookmarksModel model = new OffsetsBookmarksModel();

        public OffsetBookmarksPanel(final PreferenceTabbedPane preferenceTabbedPane) {
            super(new GridBagLayout());
            final JTable jTable = new JTable(this.model){

                public String getToolTipText(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    return OffsetBookmarksPanel.this.model.getValueAt(this.rowAtPoint(point), this.columnAtPoint(point)).toString();
                }
            };
            JScrollPane jScrollPane = new JScrollPane(jTable);
            this.add((Component)jScrollPane, GBC.eol().fill(1));
            jScrollPane.setPreferredSize(new Dimension(200, 200));
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            tableColumnModel.getColumn(0).setPreferredWidth(150);
            tableColumnModel.getColumn(1).setPreferredWidth(200);
            tableColumnModel.getColumn(2).setPreferredWidth(300);
            tableColumnModel.getColumn(3).setPreferredWidth(150);
            tableColumnModel.getColumn(4).setPreferredWidth(150);
            JPanel jPanel = new JPanel(new FlowLayout());
            JButton jButton = new JButton(I18n.tr("Add"));
            jPanel.add((Component)jButton, GBC.std().insets(0, 5, 0, 0));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OffsetBookmark offsetBookmark = new OffsetBookmark(Main.proj, "", "", 0.0, 0.0);
                    OffsetBookmarksPanel.this.model.addRow(offsetBookmark);
                }
            });
            JButton jButton2 = new JButton(I18n.tr("Delete"));
            jPanel.add((Component)jButton2, GBC.std().insets(0, 5, 0, 0));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jTable.getSelectedRow() == -1) {
                        JOptionPane.showMessageDialog(preferenceTabbedPane, I18n.tr("Please select the row to delete."));
                    } else {
                        Integer n;
                        while ((n = Integer.valueOf(jTable.getSelectedRow())) != -1) {
                            OffsetBookmarksPanel.this.model.removeRow(n);
                        }
                    }
                }
            });
            this.add((Component)jPanel, GBC.eol());
        }

        class OffsetsBookmarksModel
        extends DefaultTableModel {
            public OffsetsBookmarksModel() {
                this.setColumnIdentifiers(new String[]{I18n.tr("Projection"), I18n.tr("Layer"), I18n.tr("Name"), I18n.tr("Easting"), I18n.tr("Northing")});
            }

            public OffsetBookmark getRow(int n) {
                return OffsetBookmarksPanel.this.bookmarks.get(n);
            }

            public void addRow(OffsetBookmark offsetBookmark) {
                OffsetBookmarksPanel.this.bookmarks.add(offsetBookmark);
                int n = this.getRowCount() - 1;
                this.fireTableRowsInserted(n, n);
            }

            public void removeRow(int n) {
                OffsetBookmarksPanel.this.bookmarks.remove(this.getRow(n));
                this.fireTableRowsDeleted(n, n);
            }

            public int getRowCount() {
                return OffsetBookmarksPanel.this.bookmarks.size();
            }

            public Object getValueAt(int n, int n2) {
                OffsetBookmark offsetBookmark = OffsetBookmarksPanel.this.bookmarks.get(n);
                switch (n2) {
                    case 0: {
                        return ((Object)offsetBookmark.proj).toString();
                    }
                    case 1: {
                        return offsetBookmark.layerName;
                    }
                    case 2: {
                        return offsetBookmark.name;
                    }
                    case 3: {
                        return offsetBookmark.dx;
                    }
                    case 4: {
                        return offsetBookmark.dy;
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }

            public void setValueAt(Object object, int n, int n2) {
                OffsetBookmark offsetBookmark = OffsetBookmarksPanel.this.bookmarks.get(n);
                switch (n2) {
                    case 1: {
                        offsetBookmark.layerName = object.toString();
                        break;
                    }
                    case 2: {
                        offsetBookmark.name = object.toString();
                        break;
                    }
                    case 3: {
                        offsetBookmark.dx = Double.parseDouble((String)object);
                        break;
                    }
                    case 4: {
                        offsetBookmark.dy = Double.parseDouble((String)object);
                        break;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                }
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 >= 1;
            }
        }
    }

    static class ImageryProvidersPanel
    extends JPanel {
        final ImageryLayerTableModel model;
        private final ImageryLayerInfo layerInfo;

        public ImageryProvidersPanel(final PreferenceTabbedPane preferenceTabbedPane, ImageryLayerInfo imageryLayerInfo) {
            super(new GridBagLayout());
            this.layerInfo = imageryLayerInfo;
            this.model = new ImageryLayerTableModel();
            final JTable jTable = new JTable(this.model){

                public String getToolTipText(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    return ImageryProvidersPanel.this.model.getValueAt(this.rowAtPoint(point), this.columnAtPoint(point)).toString();
                }
            };
            JScrollPane jScrollPane = new JScrollPane(jTable);
            this.add((Component)jScrollPane, GBC.eol().fill(1));
            jScrollPane.setPreferredSize(new Dimension(200, 200));
            final ImageryDefaultLayerTableModel imageryDefaultLayerTableModel = new ImageryDefaultLayerTableModel();
            final JTable jTable2 = new JTable(imageryDefaultLayerTableModel){

                public String getToolTipText(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    return (String)imageryDefaultLayerTableModel.getValueAt(this.rowAtPoint(point), this.columnAtPoint(point));
                }
            };
            JScrollPane jScrollPane2 = new JScrollPane(jTable2);
            jScrollPane2.setPreferredSize(new Dimension(200, 200));
            TableColumnModel tableColumnModel = jTable2.getColumnModel();
            tableColumnModel.getColumn(1).setPreferredWidth(800);
            tableColumnModel.getColumn(0).setPreferredWidth(200);
            tableColumnModel = jTable.getColumnModel();
            tableColumnModel.getColumn(2).setPreferredWidth(50);
            tableColumnModel.getColumn(1).setPreferredWidth(800);
            tableColumnModel.getColumn(0).setPreferredWidth(200);
            JPanel jPanel = new JPanel(new FlowLayout());
            JButton jButton = new JButton(I18n.tr("Add"));
            jPanel.add((Component)jButton, GBC.std().insets(0, 5, 0, 0));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AddWMSLayerPanel addWMSLayerPanel = new AddWMSLayerPanel();
                    int n = JOptionPane.showConfirmDialog(preferenceTabbedPane, addWMSLayerPanel, I18n.tr("Add Imagery URL"), 2);
                    if (n == 0) {
                        ImageryProvidersPanel.this.model.addRow(new ImageryInfo(addWMSLayerPanel.getUrlName(), addWMSLayerPanel.getUrl()));
                    }
                }
            });
            JButton jButton2 = new JButton(I18n.tr("Delete"));
            jPanel.add((Component)jButton2, GBC.std().insets(0, 5, 0, 0));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jTable.getSelectedRow() == -1) {
                        JOptionPane.showMessageDialog(preferenceTabbedPane, I18n.tr("Please select the row to delete."));
                    } else {
                        Integer n;
                        while ((n = Integer.valueOf(jTable.getSelectedRow())) != -1) {
                            ImageryProvidersPanel.this.model.removeRow(n);
                        }
                    }
                }
            });
            JButton jButton3 = new JButton(I18n.tr("Copy Selected Default(s)"));
            jPanel.add((Component)jButton3, GBC.std().insets(0, 5, 0, 0));
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = jTable2.getSelectedRows();
                    if (nArray.length == 0) {
                        JOptionPane.showMessageDialog(preferenceTabbedPane, I18n.tr("Please select at least one row to copy."), I18n.tr("Information"), 1);
                        return;
                    }
                    block0: for (int i = 0; i < nArray.length; ++i) {
                        int n;
                        ImageryInfo imageryInfo = imageryDefaultLayerTableModel.getRow(nArray[i]);
                        for (n = 0; n < ImageryProvidersPanel.this.model.getRowCount(); ++n) {
                            if (!imageryInfo.equalsBaseValues(ImageryProvidersPanel.this.model.getRow(n))) continue;
                            jTable.getSelectionModel().setSelectionInterval(n, n);
                            jTable.scrollRectToVisible(jTable.getCellRect(n, 0, true));
                            continue block0;
                        }
                        if (imageryInfo.eulaAcceptanceRequired != null && !ImageryProvidersPanel.this.confirmEulaAcceptance(preferenceTabbedPane, imageryInfo.eulaAcceptanceRequired)) continue;
                        ImageryProvidersPanel.this.model.addRow(new ImageryInfo(imageryInfo));
                        n = ImageryProvidersPanel.this.model.getRowCount() - 1;
                        jTable.getSelectionModel().setSelectionInterval(n, n);
                        jTable.scrollRectToVisible(jTable.getCellRect(n, 0, true));
                    }
                }
            });
            this.add(jPanel);
            this.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
            this.add((Component)jScrollPane2, GBC.eol().insets(0, 5, 0, 0).fill(1));
        }

        private boolean confirmEulaAcceptance(PreferenceTabbedPane preferenceTabbedPane, String string) {
            URL uRL = null;
            try {
                uRL = new URL(string.replaceAll("\\{lang\\}", Locale.getDefault().toString()));
                JEditorPane jEditorPane = null;
                try {
                    jEditorPane = new JEditorPane(uRL);
                }
                catch (IOException iOException) {
                    try {
                        uRL = new URL(string.replaceAll("\\{lang\\}", "en"));
                        jEditorPane = new JEditorPane(uRL);
                    }
                    catch (IOException iOException2) {
                        JOptionPane.showMessageDialog(preferenceTabbedPane, I18n.tr("EULA license URL not available: {0}", string));
                        return false;
                    }
                }
                Box box = Box.createVerticalBox();
                jEditorPane.setEditable(false);
                JScrollPane jScrollPane = new JScrollPane(jEditorPane);
                jScrollPane.setPreferredSize(new Dimension(400, 400));
                box.add(jScrollPane);
                int n = JOptionPane.showConfirmDialog(Main.parent, box, I18n.tr("Please abort if you are not sure"), 0, 2);
                if (n == 0) {
                    return true;
                }
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(preferenceTabbedPane, I18n.tr("Malformed URL for the EULA licence: {0}", string));
            }
            return false;
        }

        class ImageryDefaultLayerTableModel
        extends DefaultTableModel {
            public ImageryDefaultLayerTableModel() {
                this.setColumnIdentifiers(new String[]{I18n.tr("Menu Name (Default)"), I18n.tr("Imagery URL (Default)")});
            }

            public ImageryInfo getRow(int n) {
                return ImageryProvidersPanel.this.layerInfo.getDefaultLayers().get(n);
            }

            public int getRowCount() {
                return ImageryProvidersPanel.this.layerInfo.getDefaultLayers().size();
            }

            public Object getValueAt(int n, int n2) {
                ImageryInfo imageryInfo = ImageryProvidersPanel.this.layerInfo.getDefaultLayers().get(n);
                switch (n2) {
                    case 0: {
                        return imageryInfo.getName();
                    }
                    case 1: {
                        return imageryInfo.getFullURL();
                    }
                }
                return null;
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        }

        class ImageryLayerTableModel
        extends DefaultTableModel {
            public ImageryLayerTableModel() {
                this.setColumnIdentifiers(new String[]{I18n.tr("Menu Name"), I18n.tr("Imagery URL"), I18n.trc("layer", "Zoom")});
            }

            public ImageryInfo getRow(int n) {
                return ImageryProvidersPanel.this.layerInfo.getLayers().get(n);
            }

            public void addRow(ImageryInfo imageryInfo) {
                ImageryProvidersPanel.this.layerInfo.add(imageryInfo);
                int n = this.getRowCount() - 1;
                this.fireTableRowsInserted(n, n);
            }

            public void removeRow(int n) {
                ImageryProvidersPanel.this.layerInfo.remove(this.getRow(n));
                this.fireTableRowsDeleted(n, n);
            }

            public int getRowCount() {
                return ImageryProvidersPanel.this.layerInfo.getLayers().size();
            }

            public Object getValueAt(int n, int n2) {
                ImageryInfo imageryInfo = ImageryProvidersPanel.this.layerInfo.getLayers().get(n);
                switch (n2) {
                    case 0: {
                        return imageryInfo.getName();
                    }
                    case 1: {
                        return imageryInfo.getFullURL();
                    }
                    case 2: {
                        return imageryInfo.getImageryType() == ImageryInfo.ImageryType.WMS || imageryInfo.getImageryType() == ImageryInfo.ImageryType.HTML ? (imageryInfo.getPixelPerDegree() == 0.0 ? "" : Double.valueOf(imageryInfo.getPixelPerDegree())) : (imageryInfo.getMaxZoom() == 0 ? "" : Integer.valueOf(imageryInfo.getMaxZoom()));
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }

            public void setValueAt(Object object, int n, int n2) {
                ImageryInfo imageryInfo = ImageryProvidersPanel.this.layerInfo.getLayers().get(n);
                switch (n2) {
                    case 0: {
                        imageryInfo.setName((String)object);
                        break;
                    }
                    case 1: {
                        imageryInfo.setURL((String)object);
                        break;
                    }
                    case 2: {
                        imageryInfo.setPixelPerDegree(0.0);
                        imageryInfo.setMaxZoom(0);
                        try {
                            if (imageryInfo.getImageryType() == ImageryInfo.ImageryType.WMS || imageryInfo.getImageryType() == ImageryInfo.ImageryType.HTML) {
                                imageryInfo.setPixelPerDegree(Double.parseDouble((String)object));
                                break;
                            }
                            imageryInfo.setMaxZoom(Integer.parseInt((String)object));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        break;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                }
            }

            public boolean isCellEditable(int n, int n2) {
                return true;
            }
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new ImageryPreference();
        }
    }
}

