/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.ValidatorVisitor;
import org.openstreetmap.josm.gui.MapView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestError {
    private Boolean ignored = false;
    private Severity severity;
    private String message;
    private String description;
    private String description_en;
    private Collection<? extends OsmPrimitive> primitives;
    private Collection<?> highlighted;
    private Test tester;
    private int code;
    private boolean selected;

    public TestError(Test test, Severity severity, String string, String string2, String string3, int n, Collection<? extends OsmPrimitive> collection, Collection<?> collection2) {
        this.tester = test;
        this.severity = severity;
        this.message = string;
        this.description = string2;
        this.description_en = string3;
        this.primitives = collection;
        this.highlighted = collection2;
        this.code = n;
    }

    public TestError(Test test, Severity severity, String string, int n, Collection<? extends OsmPrimitive> collection, Collection<?> collection2) {
        this(test, severity, string, null, null, n, collection, collection2);
    }

    public TestError(Test test, Severity severity, String string, String string2, String string3, int n, Collection<? extends OsmPrimitive> collection) {
        this(test, severity, string, string2, string3, n, collection, collection);
    }

    public TestError(Test test, Severity severity, String string, int n, Collection<? extends OsmPrimitive> collection) {
        this(test, severity, string, null, null, n, collection, collection);
    }

    public TestError(Test test, Severity severity, String string, int n, OsmPrimitive osmPrimitive) {
        this(test, severity, string, null, null, n, Collections.singletonList(osmPrimitive), Collections.singletonList(osmPrimitive));
    }

    public TestError(Test test, Severity severity, String string, String string2, String string3, int n, OsmPrimitive osmPrimitive) {
        this(test, severity, string, string2, string3, n, Collections.singletonList(osmPrimitive));
    }

    public String getMessage() {
        return this.message;
    }

    public String getDescription() {
        return this.description;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public Collection<? extends OsmPrimitive> getPrimitives() {
        return this.primitives;
    }

    public void setPrimitives(List<OsmPrimitive> list) {
        this.primitives = list;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public String getIgnoreState() {
        TreeSet<String> treeSet = new TreeSet<String>();
        String string = this.getIgnoreSubGroup();
        for (OsmPrimitive object : this.primitives) {
            if (object.isNew()) {
                return null;
            }
            String string2 = "u";
            if (object instanceof Way) {
                string2 = "w";
            } else if (object instanceof Relation) {
                string2 = "r";
            } else if (object instanceof Node) {
                string2 = "n";
            }
            treeSet.add(string2 + "_" + object.getId());
        }
        for (String string3 : treeSet) {
            string = string + ":" + string3;
        }
        return string;
    }

    public String getIgnoreSubGroup() {
        String string = this.getIgnoreGroup();
        if (this.description_en != null) {
            string = string + "_" + this.description_en;
        }
        return string;
    }

    public String getIgnoreGroup() {
        return Integer.toString(this.code);
    }

    public void setIgnored(boolean bl) {
        this.ignored = bl;
    }

    public Boolean getIgnored() {
        return this.ignored;
    }

    public Test getTester() {
        return this.tester;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isFixable() {
        return this.tester != null && this.tester.isFixable(this);
    }

    public Command getFix() {
        if (this.tester == null) {
            return null;
        }
        return this.tester.fixError(this);
    }

    public void paint(Graphics graphics, MapView mapView) {
        if (!this.ignored.booleanValue()) {
            PaintVisitor paintVisitor = new PaintVisitor(graphics, mapView);
            this.visitHighlighted(paintVisitor);
        }
    }

    public void visitHighlighted(ValidatorVisitor validatorVisitor) {
        for (Object obj : this.highlighted) {
            if (obj instanceof OsmPrimitive) {
                validatorVisitor.visit((OsmPrimitive)obj);
                continue;
            }
            if (obj instanceof WaySegment) {
                validatorVisitor.visit((WaySegment)obj);
                continue;
            }
            if (!(obj instanceof List)) continue;
            validatorVisitor.visit((List)obj);
        }
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PaintVisitor
    extends AbstractVisitor
    implements ValidatorVisitor {
        private final Graphics g;
        private final MapView mv;

        public PaintVisitor(Graphics graphics, MapView mapView) {
            this.g = graphics;
            this.mv = mapView;
        }

        @Override
        public void visit(OsmPrimitive osmPrimitive) {
            if (osmPrimitive.isUsable()) {
                osmPrimitive.visit(this);
            }
        }

        public void drawNode(Node node, Color color) {
            Point point = this.mv.getPoint(node);
            this.g.setColor(color);
            if (TestError.this.selected) {
                this.g.fillOval(point.x - 5, point.y - 5, 10, 10);
            } else {
                this.g.drawOval(point.x - 5, point.y - 5, 10, 10);
            }
        }

        public void drawSegment(Point point, Point point2, Color color) {
            this.g.setColor(color);
            double d = Math.atan2(point2.x - point.x, point2.y - point.y);
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            int n = (int)Math.toDegrees(d);
            if (TestError.this.selected) {
                int[] nArray = new int[]{(int)((double)point.x + 5.0 * d2), (int)((double)point2.x + 5.0 * d2), (int)((double)point2.x - 5.0 * d2), (int)((double)point.x - 5.0 * d2)};
                int[] nArray2 = new int[]{(int)((double)point.y - 5.0 * d3), (int)((double)point2.y - 5.0 * d3), (int)((double)point2.y + 5.0 * d3), (int)((double)point.y + 5.0 * d3)};
                this.g.fillPolygon(nArray, nArray2, 4);
                this.g.fillArc(point.x - 5, point.y - 5, 10, 10, n, 180);
                this.g.fillArc(point2.x - 5, point2.y - 5, 10, 10, n, -180);
            } else {
                this.g.drawLine((int)((double)point.x + 5.0 * d2), (int)((double)point.y - 5.0 * d3), (int)((double)point2.x + 5.0 * d2), (int)((double)point2.y - 5.0 * d3));
                this.g.drawLine((int)((double)point.x - 5.0 * d2), (int)((double)point.y + 5.0 * d3), (int)((double)point2.x - 5.0 * d2), (int)((double)point2.y + 5.0 * d3));
                this.g.drawArc(point.x - 5, point.y - 5, 10, 10, n, 180);
                this.g.drawArc(point2.x - 5, point2.y - 5, 10, 10, n, -180);
            }
        }

        public void drawSegment(Node node, Node node2, Color color) {
            this.drawSegment(this.mv.getPoint(node), this.mv.getPoint(node2), color);
        }

        @Override
        public void visit(Node node) {
            if (this.isNodeVisible(node)) {
                this.drawNode(node, TestError.this.severity.getColor());
            }
        }

        @Override
        public void visit(Way way) {
            this.visit(way.getNodes());
        }

        @Override
        public void visit(WaySegment waySegment) {
            Node node;
            if (waySegment.lowerIndex < 0 || waySegment.lowerIndex + 1 >= waySegment.way.getNodesCount()) {
                return;
            }
            Node node2 = waySegment.way.getNodes().get(waySegment.lowerIndex);
            if (this.isSegmentVisible(node2, node = waySegment.way.getNodes().get(waySegment.lowerIndex + 1))) {
                this.drawSegment(node2, node, TestError.this.severity.getColor());
            }
        }

        @Override
        public void visit(Relation relation) {
        }

        protected boolean isNodeVisible(Node node) {
            Point point = this.mv.getPoint(node);
            return point.x >= 0 && point.y >= 0 && point.x <= this.mv.getWidth() && point.y <= this.mv.getHeight();
        }

        protected boolean isSegmentVisible(Node node, Node node2) {
            Point point = this.mv.getPoint(node);
            Point point2 = this.mv.getPoint(node2);
            if (point.x < 0 && point2.x < 0) {
                return false;
            }
            if (point.y < 0 && point2.y < 0) {
                return false;
            }
            if (point.x > this.mv.getWidth() && point2.x > this.mv.getWidth()) {
                return false;
            }
            return point.y <= this.mv.getHeight() || point2.y <= this.mv.getHeight();
        }

        @Override
        public void visit(List<Node> list) {
            Node node = null;
            for (Node node2 : list) {
                if (node == null) {
                    node = node2;
                    continue;
                }
                if (node2.isDrawable() && this.isSegmentVisible(node, node2)) {
                    this.drawSegment(node, node2, TestError.this.severity.getColor());
                }
                node = node2;
            }
        }
    }
}

