/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ValidateAction;
import org.openstreetmap.josm.actions.upload.ValidateUploadHook;
import org.openstreetmap.josm.data.projection.Epsg4326;
import org.openstreetmap.josm.data.projection.Lambert;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.Coastlines;
import org.openstreetmap.josm.data.validation.tests.CrossingWays;
import org.openstreetmap.josm.data.validation.tests.DuplicateNode;
import org.openstreetmap.josm.data.validation.tests.DuplicateWay;
import org.openstreetmap.josm.data.validation.tests.DuplicatedWayNodes;
import org.openstreetmap.josm.data.validation.tests.MultipolygonTest;
import org.openstreetmap.josm.data.validation.tests.NameMismatch;
import org.openstreetmap.josm.data.validation.tests.NodesWithSameName;
import org.openstreetmap.josm.data.validation.tests.OverlappingWays;
import org.openstreetmap.josm.data.validation.tests.RelationChecker;
import org.openstreetmap.josm.data.validation.tests.SelfIntersectingWay;
import org.openstreetmap.josm.data.validation.tests.SimilarNamedWays;
import org.openstreetmap.josm.data.validation.tests.TagChecker;
import org.openstreetmap.josm.data.validation.tests.TurnrestrictionTest;
import org.openstreetmap.josm.data.validation.tests.UnclosedWays;
import org.openstreetmap.josm.data.validation.tests.UnconnectedWays;
import org.openstreetmap.josm.data.validation.tests.UntaggedNode;
import org.openstreetmap.josm.data.validation.tests.UntaggedWay;
import org.openstreetmap.josm.data.validation.tests.WronglyOrderedWays;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.ValidatorLayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmValidator
implements MapView.LayerChangeListener {
    public static ValidatorLayer errorLayer = null;
    public ValidateAction validateAction = new ValidateAction();
    public static double griddetail;
    public static Collection<String> ignoredErrors;
    public static Class<Test>[] allAvailableTests;
    private ValidateUploadHook uploadHook;

    public OsmValidator() {
        this.checkValidatorDir();
        this.initializeGridDetail();
        OsmValidator.initializeTests(OsmValidator.getTests());
        this.loadIgnoredErrors();
    }

    public static String getValidatorDir() {
        return Main.pref.getPreferencesDir() + "validator/";
    }

    private void checkValidatorDir() {
        try {
            File file = new File(OsmValidator.getValidatorDir());
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadIgnoredErrors() {
        ignoredErrors.clear();
        if (Main.pref.getBoolean("validator.ignore", true)) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(OsmValidator.getValidatorDir() + "ignorederrors"));
                String string = bufferedReader.readLine();
                while (string != null) {
                    ignoredErrors.add(string);
                    string = bufferedReader.readLine();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void addIgnoredError(String string) {
        ignoredErrors.add(string);
    }

    public static boolean hasIgnoredError(String string) {
        return ignoredErrors.contains(string);
    }

    public static void saveIgnoredErrors() {
        try {
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(OsmValidator.getValidatorDir() + "ignorederrors"), false);
            for (String string : ignoredErrors) {
                printWriter.println(string);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void initializeErrorLayer() {
        if (!Main.pref.getBoolean("validator.layer", true)) {
            return;
        }
        if (errorLayer == null) {
            errorLayer = new ValidatorLayer();
            Main.main.addLayer(errorLayer);
        }
    }

    public static Map<String, Test> getAllTestsMap() {
        HashMap<String, Test> hashMap = new HashMap<String, Test>();
        for (Class<Test> clazz : OsmValidator.getAllAvailableTests()) {
            try {
                Test test = clazz.newInstance();
                hashMap.put(clazz.getSimpleName(), test);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        OsmValidator.applyPrefs(hashMap, false);
        OsmValidator.applyPrefs(hashMap, true);
        return hashMap;
    }

    private static void applyPrefs(Map<String, Test> map, boolean bl) {
        Pattern pattern = Pattern.compile("(\\w+)=(true|false),?");
        Matcher matcher = pattern.matcher(Main.pref.get(bl ? "validator.testsBeforeUpload" : "validator.tests"));
        int n = 0;
        while (matcher.find(n)) {
            String string = matcher.group(1);
            Test test = map.get(string);
            if (test != null) {
                boolean bl2 = Boolean.valueOf(matcher.group(2));
                if (bl) {
                    test.testBeforeUpload = bl2;
                } else {
                    test.enabled = bl2;
                }
            }
            n = matcher.end();
        }
    }

    public static Collection<Test> getTests() {
        return OsmValidator.getAllTestsMap().values();
    }

    public static Collection<Test> getEnabledTests(boolean bl) {
        Collection<Test> collection = OsmValidator.getTests();
        for (Test test : new ArrayList<Test>(collection)) {
            if (bl ? test.testBeforeUpload : test.enabled) continue;
            collection.remove(test);
        }
        return collection;
    }

    public static Class<Test>[] getAllAvailableTests() {
        return allAvailableTests;
    }

    public void initializeGridDetail() {
        if (((Object)Main.proj).toString().equals(new Epsg4326().toString())) {
            griddetail = 10000.0;
        } else if (((Object)Main.proj).toString().equals(new Mercator().toString())) {
            griddetail = 100000.0;
        } else if (((Object)Main.proj).toString().equals(new Lambert().toString())) {
            griddetail = 0.1;
        }
    }

    public static void initializeTests(Collection<Test> collection) {
        for (Test test : collection) {
            try {
                if (!test.enabled) continue;
                test.initialize();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error initializing test {0}:\n {1}", test.getClass().getSimpleName(), exception), I18n.tr("Error"), 0);
            }
        }
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
    }

    @Override
    public void layerAdded(Layer layer) {
    }

    @Override
    public void layerRemoved(Layer layer) {
        if (layer instanceof OsmDataLayer && Main.map.mapView.getActiveLayer() == layer) {
            Main.map.validatorDialog.tree.setErrorList(new ArrayList<TestError>());
        }
        if (layer == errorLayer) {
            errorLayer = null;
            return;
        }
        if (Main.map.mapView.getLayersOfType(OsmDataLayer.class).isEmpty() && errorLayer != null) {
            Main.map.mapView.removeLayer(errorLayer);
        }
    }

    static {
        ignoredErrors = new TreeSet<String>();
        allAvailableTests = new Class[]{DuplicateNode.class, OverlappingWays.class, UntaggedNode.class, UntaggedWay.class, SelfIntersectingWay.class, DuplicatedWayNodes.class, CrossingWays.class, SimilarNamedWays.class, NodesWithSameName.class, Coastlines.class, WronglyOrderedWays.class, UnclosedWays.class, TagChecker.class, UnconnectedWays.class, DuplicateWay.class, NameMismatch.class, MultipolygonTest.class, RelationChecker.class, TurnrestrictionTest.class};
    }
}

