/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.openstreetmap.josm.data.projection.NTV2GridShift;
import org.openstreetmap.josm.data.projection.NTV2SubGrid;
import org.openstreetmap.josm.data.projection.NTV2Util;

public class NTV2GridShiftFile
implements Serializable {
    private String overviewHeaderCountId;
    private int overviewHeaderCount;
    private int subGridHeaderCount;
    private int subGridCount;
    private String shiftType;
    private String version;
    private String fromEllipsoid = "";
    private String toEllipsoid = "";
    private double fromSemiMajorAxis;
    private double fromSemiMinorAxis;
    private double toSemiMajorAxis;
    private double toSemiMinorAxis;
    private NTV2SubGrid[] topLevelSubGrid;
    private NTV2SubGrid lastSubGrid;

    public void loadGridShiftFile(InputStream inputStream, boolean bl) throws IOException {
        byte[] byArray = new byte[8];
        boolean bl2 = true;
        this.fromEllipsoid = "";
        this.toEllipsoid = "";
        this.topLevelSubGrid = null;
        inputStream.read(byArray);
        this.overviewHeaderCountId = new String(byArray);
        if (!"NUM_OREC".equals(this.overviewHeaderCountId)) {
            throw new IllegalArgumentException("Input file is not an NTv2 grid shift file");
        }
        inputStream.read(byArray);
        this.overviewHeaderCount = NTV2Util.getIntBE(byArray, 0);
        if (this.overviewHeaderCount == 11) {
            bl2 = true;
        } else {
            this.overviewHeaderCount = NTV2Util.getIntLE(byArray, 0);
            if (this.overviewHeaderCount == 11) {
                bl2 = false;
            } else {
                throw new IllegalArgumentException("Input file is not an NTv2 grid shift file");
            }
        }
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.subGridHeaderCount = NTV2Util.getInt(byArray, bl2);
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.subGridCount = NTV2Util.getInt(byArray, bl2);
        NTV2SubGrid[] nTV2SubGridArray = new NTV2SubGrid[this.subGridCount];
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.shiftType = new String(byArray);
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.version = new String(byArray);
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.fromEllipsoid = new String(byArray);
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.toEllipsoid = new String(byArray);
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.fromSemiMajorAxis = NTV2Util.getDouble(byArray, bl2);
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.fromSemiMinorAxis = NTV2Util.getDouble(byArray, bl2);
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.toSemiMajorAxis = NTV2Util.getDouble(byArray, bl2);
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.toSemiMinorAxis = NTV2Util.getDouble(byArray, bl2);
        for (int i = 0; i < this.subGridCount; ++i) {
            nTV2SubGridArray[i] = new NTV2SubGrid(inputStream, bl2, bl);
        }
        this.topLevelSubGrid = this.createSubGridTree(nTV2SubGridArray);
        this.lastSubGrid = this.topLevelSubGrid[0];
        inputStream.close();
    }

    private NTV2SubGrid[] createSubGridTree(NTV2SubGrid[] nTV2SubGridArray) {
        int n = 0;
        HashMap hashMap = new HashMap();
        for (int i = 0; i < nTV2SubGridArray.length; ++i) {
            if (nTV2SubGridArray[i].getParentSubGridName().equalsIgnoreCase("NONE")) {
                ++n;
            }
            hashMap.put(nTV2SubGridArray[i].getSubGridName(), new ArrayList());
        }
        NTV2SubGrid[] nTV2SubGridArray2 = new NTV2SubGrid[n];
        n = 0;
        for (int i = 0; i < nTV2SubGridArray.length; ++i) {
            if (nTV2SubGridArray[i].getParentSubGridName().equalsIgnoreCase("NONE")) {
                nTV2SubGridArray2[n++] = nTV2SubGridArray[i];
                continue;
            }
            ArrayList arrayList = (ArrayList)hashMap.get(nTV2SubGridArray[i].getParentSubGridName());
            arrayList.add(nTV2SubGridArray[i]);
        }
        NTV2SubGrid[] nTV2SubGridArray3 = new NTV2SubGrid[]{};
        for (int i = 0; i < nTV2SubGridArray.length; ++i) {
            ArrayList arrayList = (ArrayList)hashMap.get(nTV2SubGridArray[i].getSubGridName());
            if (arrayList.size() <= 0) continue;
            NTV2SubGrid[] nTV2SubGridArray4 = arrayList.toArray(nTV2SubGridArray3);
            nTV2SubGridArray[i].setSubGridArray(nTV2SubGridArray4);
        }
        return nTV2SubGridArray2;
    }

    public boolean gridShiftForward(NTV2GridShift nTV2GridShift) {
        NTV2SubGrid nTV2SubGrid = this.lastSubGrid.getSubGridForCoord(nTV2GridShift.getLonPositiveWestSeconds(), nTV2GridShift.getLatSeconds());
        if (nTV2SubGrid == null) {
            nTV2SubGrid = this.getSubGrid(nTV2GridShift.getLonPositiveWestSeconds(), nTV2GridShift.getLatSeconds());
        }
        if (nTV2SubGrid == null) {
            return false;
        }
        nTV2SubGrid.interpolateGridShift(nTV2GridShift);
        nTV2GridShift.setSubGridName(nTV2SubGrid.getSubGridName());
        this.lastSubGrid = nTV2SubGrid;
        return true;
    }

    public boolean gridShiftReverse(NTV2GridShift nTV2GridShift) {
        NTV2GridShift nTV2GridShift2 = new NTV2GridShift();
        nTV2GridShift2.setLonPositiveWestSeconds(nTV2GridShift.getLonPositiveWestSeconds());
        nTV2GridShift2.setLatSeconds(nTV2GridShift.getLatSeconds());
        for (int i = 0; i < 4; ++i) {
            if (!this.gridShiftForward(nTV2GridShift2)) {
                return false;
            }
            nTV2GridShift2.setLonPositiveWestSeconds(nTV2GridShift.getLonPositiveWestSeconds() - nTV2GridShift2.getLonShiftPositiveWestSeconds());
            nTV2GridShift2.setLatSeconds(nTV2GridShift.getLatSeconds() - nTV2GridShift2.getLatShiftSeconds());
        }
        nTV2GridShift.setLonShiftPositiveWestSeconds(-nTV2GridShift2.getLonShiftPositiveWestSeconds());
        nTV2GridShift.setLatShiftSeconds(-nTV2GridShift2.getLatShiftSeconds());
        nTV2GridShift.setLonAccuracyAvailable(nTV2GridShift2.isLonAccuracyAvailable());
        if (nTV2GridShift2.isLonAccuracyAvailable()) {
            nTV2GridShift.setLonAccuracySeconds(nTV2GridShift2.getLonAccuracySeconds());
        }
        nTV2GridShift.setLatAccuracyAvailable(nTV2GridShift2.isLatAccuracyAvailable());
        if (nTV2GridShift2.isLatAccuracyAvailable()) {
            nTV2GridShift.setLatAccuracySeconds(nTV2GridShift2.getLatAccuracySeconds());
        }
        return true;
    }

    private NTV2SubGrid getSubGrid(double d, double d2) {
        NTV2SubGrid nTV2SubGrid = null;
        for (int i = 0; i < this.topLevelSubGrid.length && (nTV2SubGrid = this.topLevelSubGrid[i].getSubGridForCoord(d, d2)) == null; ++i) {
        }
        return nTV2SubGrid;
    }

    public boolean isLoaded() {
        return this.topLevelSubGrid != null;
    }

    public void unload() {
        this.topLevelSubGrid = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Headers  : ");
        stringBuffer.append(this.overviewHeaderCount);
        stringBuffer.append("\nSub Hdrs : ");
        stringBuffer.append(this.subGridHeaderCount);
        stringBuffer.append("\nSub Grids: ");
        stringBuffer.append(this.subGridCount);
        stringBuffer.append("\nType     : ");
        stringBuffer.append(this.shiftType);
        stringBuffer.append("\nVersion  : ");
        stringBuffer.append(this.version);
        stringBuffer.append("\nFr Ellpsd: ");
        stringBuffer.append(this.fromEllipsoid);
        stringBuffer.append("\nTo Ellpsd: ");
        stringBuffer.append(this.toEllipsoid);
        stringBuffer.append("\nFr Maj Ax: ");
        stringBuffer.append(this.fromSemiMajorAxis);
        stringBuffer.append("\nFr Min Ax: ");
        stringBuffer.append(this.fromSemiMinorAxis);
        stringBuffer.append("\nTo Maj Ax: ");
        stringBuffer.append(this.toSemiMajorAxis);
        stringBuffer.append("\nTo Min Ax: ");
        stringBuffer.append(this.toSemiMinorAxis);
        return stringBuffer.toString();
    }

    public NTV2SubGrid[] getSubGridTree() {
        NTV2SubGrid[] nTV2SubGridArray = new NTV2SubGrid[this.topLevelSubGrid.length];
        for (int i = 0; i < this.topLevelSubGrid.length; ++i) {
            nTV2SubGridArray[i] = (NTV2SubGrid)this.topLevelSubGrid[i].clone();
        }
        return nTV2SubGridArray;
    }

    public String getFromEllipsoid() {
        return this.fromEllipsoid;
    }

    public String getToEllipsoid() {
        return this.toEllipsoid;
    }
}

