/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveCommand
extends Command {
    private Collection<Node> nodes = new LinkedList<Node>();
    private double x;
    private double y;
    private List<OldState> oldState = new LinkedList<OldState>();

    public MoveCommand(OsmPrimitive osmPrimitive, double d, double d2) {
        this(Collections.singleton(osmPrimitive), d, d2);
    }

    public MoveCommand(Node node, LatLon latLon) {
        this(Collections.singleton(node), node.getEastNorth().sub(new CachedLatLon(latLon).getEastNorth()));
    }

    public MoveCommand(Collection<OsmPrimitive> collection, EastNorth eastNorth) {
        this(collection, eastNorth.getX(), eastNorth.getY());
    }

    public MoveCommand(Collection<OsmPrimitive> collection, double d, double d2) {
        this.x = d;
        this.y = d2;
        this.nodes = AllNodesVisitor.getAllNodes(collection);
        for (Node node : this.nodes) {
            OldState oldState = new OldState();
            oldState.latlon = new LatLon(node.getCoor());
            oldState.modified = node.isModified();
            this.oldState.add(oldState);
        }
    }

    public void moveAgain(double d, double d2) {
        for (Node node : this.nodes) {
            node.setEastNorth(node.getEastNorth().add(d, d2));
        }
        this.x += d;
        this.y += d2;
    }

    public void moveAgainTo(double d, double d2) {
        this.moveAgain(d - this.x, d2 - this.y);
    }

    @Override
    public boolean executeCommand() {
        for (Node node : this.nodes) {
            if (node == null) {
                throw new AssertionError((Object)"null detected in node list");
            }
            if (node.getEastNorth() == null) {
                throw new AssertionError((Object)node.get3892DebugInfo());
            }
            node.setEastNorth(node.getEastNorth().add(this.x, this.y));
            node.setModified(true);
        }
        return true;
    }

    @Override
    public void undoCommand() {
        Iterator<OldState> iterator = this.oldState.iterator();
        for (Node node : this.nodes) {
            OldState oldState = iterator.next();
            node.setCoor(oldState.latlon);
            node.setModified(oldState.modified);
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        for (Node node : this.nodes) {
            collection.add(node);
        }
    }

    @Override
    public JLabel getDescription() {
        return new JLabel(I18n.trn("Move {0} node", "Move {0} nodes", this.nodes.size(), this.nodes.size()), ImageProvider.get("data", "node"), 0);
    }

    @Deprecated
    public Collection<Node> getMovedNodes() {
        return this.nodes;
    }

    public Collection<Node> getParticipatingPrimitives() {
        return this.nodes;
    }

    public static class OldState {
        LatLon latlon;
        boolean modified;
    }
}

