/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.tools.I18n;

public class TaggingPresetSearchDialog
extends ExtendedDialog {
    private int CLASSIFICATION_NAME_MATCH = 300;
    private int CLASSIFICATION_GROUP_MATCH = 200;
    private int CLASSIFICATION_TAGS_MATCH = 100;
    private JTextField edSearchText;
    private JList lsResult;
    private JCheckBox ckOnlyApplicable;
    private JCheckBox ckSearchInTags;
    private final EnumSet<TaggingPreset.PresetType> typesInSelection = EnumSet.noneOf(TaggingPreset.PresetType.class);
    private final List<PresetClasification> classifications = new ArrayList<PresetClasification>();
    private ResultListModel lsResultModel = new ResultListModel();

    public TaggingPresetSearchDialog(Component component) {
        super(component, I18n.tr("Presets"), new String[]{I18n.tr("Select"), I18n.tr("Cancel")});
        this.getTypesInSelection();
        for (TaggingPreset taggingPreset : TaggingPresetPreference.taggingPresets) {
            if (taggingPreset instanceof TaggingPresetSeparator || taggingPreset instanceof TaggingPresetMenu) continue;
            this.classifications.add(new PresetClasification(taggingPreset));
        }
        this.build();
        this.filterPresets("");
    }

    private void build() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.edSearchText = new JTextField();
        this.edSearchText.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                TaggingPresetSearchDialog.this.filterPresets(TaggingPresetSearchDialog.this.edSearchText.getText());
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                TaggingPresetSearchDialog.this.filterPresets(TaggingPresetSearchDialog.this.edSearchText.getText());
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                TaggingPresetSearchDialog.this.filterPresets(TaggingPresetSearchDialog.this.edSearchText.getText());
            }
        });
        this.edSearchText.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 40: {
                        TaggingPresetSearchDialog.this.selectPreset(TaggingPresetSearchDialog.this.lsResult.getSelectedIndex() + 1);
                        break;
                    }
                    case 38: {
                        TaggingPresetSearchDialog.this.selectPreset(TaggingPresetSearchDialog.this.lsResult.getSelectedIndex() - 1);
                        break;
                    }
                    case 34: {
                        TaggingPresetSearchDialog.this.selectPreset(TaggingPresetSearchDialog.this.lsResult.getSelectedIndex() + 10);
                        break;
                    }
                    case 33: {
                        TaggingPresetSearchDialog.this.selectPreset(TaggingPresetSearchDialog.this.lsResult.getSelectedIndex() - 10);
                        break;
                    }
                    case 36: {
                        TaggingPresetSearchDialog.this.selectPreset(0);
                        break;
                    }
                    case 35: {
                        TaggingPresetSearchDialog.this.selectPreset(TaggingPresetSearchDialog.this.lsResultModel.getSize());
                    }
                }
            }
        });
        jPanel.add((Component)this.edSearchText, "North");
        this.lsResult = new JList();
        this.lsResult.setModel(this.lsResultModel);
        this.lsResult.setCellRenderer(new ResultListCellRenderer());
        this.lsResult.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    TaggingPresetSearchDialog.this.buttonAction(0, null);
                }
            }
        });
        jPanel.add((Component)new JScrollPane(this.lsResult), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.ckOnlyApplicable = new JCheckBox();
        this.ckOnlyApplicable.setText(I18n.tr("Show only applicable to selection"));
        jPanel2.add(this.ckOnlyApplicable);
        if (this.typesInSelection.isEmpty()) {
            this.ckOnlyApplicable.setSelected(false);
            this.ckOnlyApplicable.setEnabled(false);
        } else {
            this.ckOnlyApplicable.setSelected(true);
            this.ckOnlyApplicable.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    TaggingPresetSearchDialog.this.filterPresets(TaggingPresetSearchDialog.this.edSearchText.getText());
                }
            });
        }
        this.ckSearchInTags = new JCheckBox();
        this.ckSearchInTags.setText(I18n.tr("Search in tags"));
        this.ckSearchInTags.setSelected(Main.pref.getBoolean("taggingpreset.dialog.search-in-tags", true));
        this.ckSearchInTags.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TaggingPresetSearchDialog.this.filterPresets(TaggingPresetSearchDialog.this.edSearchText.getText());
            }
        });
        jPanel2.add(this.ckSearchInTags);
        jPanel.add((Component)jPanel2, "South");
        jPanel.setPreferredSize(new Dimension(400, 300));
        this.setContent(jPanel);
    }

    private void selectPreset(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.lsResultModel.getSize() - 1) {
            n = this.lsResultModel.getSize() - 1;
        }
        this.lsResult.setSelectedIndex(n);
        this.lsResult.ensureIndexIsVisible(n);
    }

    private void filterPresets(String string) {
        String[] stringArray;
        String[] stringArray2;
        if ((string = string.toLowerCase()).contains("/")) {
            stringArray2 = string.substring(0, string.lastIndexOf(47)).split("[\\s/]");
            stringArray = string.substring(string.indexOf(47) + 1).split("\\s");
        } else {
            stringArray2 = null;
            stringArray = string.split("\\s");
        }
        boolean bl = this.ckOnlyApplicable.isSelected();
        boolean bl2 = this.ckSearchInTags.isSelected();
        ArrayList<PresetClasification> arrayList = new ArrayList<PresetClasification>();
        for (PresetClasification presetClasification : this.classifications) {
            int n;
            TaggingPreset taggingPreset = presetClasification.preset;
            presetClasification.classification = 0;
            if (bl && taggingPreset.types != null) {
                n = 0;
                for (TaggingPreset.PresetType presetType : taggingPreset.types) {
                    if (!this.typesInSelection.contains((Object)presetType)) continue;
                    n = 1;
                    break;
                }
                if (n == 0) continue;
            }
            if (stringArray2 != null && presetClasification.isMatchingGroup(stringArray2) == 0) continue;
            n = presetClasification.isMatchingName(stringArray);
            if (n == 0) {
                int n2;
                int n3;
                if (stringArray2 == null && (n3 = presetClasification.isMatchingGroup(stringArray)) > 0) {
                    presetClasification.classification = this.CLASSIFICATION_GROUP_MATCH + n3;
                }
                if (presetClasification.classification == 0 && bl2 && (n2 = presetClasification.isMatchingTags(stringArray)) > 0) {
                    presetClasification.classification = this.CLASSIFICATION_TAGS_MATCH + n2;
                }
            } else {
                presetClasification.classification = this.CLASSIFICATION_NAME_MATCH + n;
            }
            if (presetClasification.classification <= 0) continue;
            arrayList.add(presetClasification);
        }
        Collections.sort(arrayList);
        this.lsResultModel.setPresets(arrayList);
        if (!this.buttons.isEmpty()) {
            ((JButton)this.buttons.get(0)).setEnabled(!arrayList.isEmpty());
        }
    }

    private void getTypesInSelection() {
        for (OsmPrimitive osmPrimitive : Main.main.getCurrentDataSet().getSelected()) {
            if (osmPrimitive instanceof Node) {
                this.typesInSelection.add(TaggingPreset.PresetType.NODE);
                continue;
            }
            if (osmPrimitive instanceof Way) {
                this.typesInSelection.add(TaggingPreset.PresetType.WAY);
                if (!((Way)osmPrimitive).isClosed()) continue;
                this.typesInSelection.add(TaggingPreset.PresetType.CLOSEDWAY);
                continue;
            }
            if (!(osmPrimitive instanceof Relation)) continue;
            this.typesInSelection.add(TaggingPreset.PresetType.RELATION);
        }
    }

    protected void buttonAction(int n, ActionEvent actionEvent) {
        super.buttonAction(n, actionEvent);
        if (n == 0) {
            int n2 = this.lsResult.getSelectedIndex();
            if (n2 == -1) {
                n2 = 0;
            }
            this.lsResultModel.getPresets().get((int)n2).preset.actionPerformed(null);
        }
        Main.pref.put("taggingpreset.dialog.search-in-tags", this.ckSearchInTags.isSelected());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PresetClasification
    implements Comparable<PresetClasification> {
        public final TaggingPreset preset;
        public int classification;
        private final Collection<String> groups = new HashSet<String>();
        private final Collection<String> names = new HashSet<String>();
        private final Collection<String> tags = new HashSet<String>();

        PresetClasification(TaggingPreset taggingPreset) {
            this.preset = taggingPreset;
            TaggingPresetMenu taggingPresetMenu = taggingPreset.group;
            while (taggingPresetMenu != null) {
                for (String object : taggingPresetMenu.getLocaleName().toLowerCase().split("\\s")) {
                    this.groups.add(object);
                }
                taggingPresetMenu = taggingPresetMenu.group;
            }
            for (String string : taggingPreset.getLocaleName().toLowerCase().split("\\s")) {
                this.names.add(string);
            }
            for (TaggingPreset.Item item : taggingPreset.data) {
                if (item instanceof TaggingPreset.Check) {
                    this.tags.add(((TaggingPreset.Check)item).key.toLowerCase());
                    continue;
                }
                if (item instanceof TaggingPreset.Combo) {
                    this.tags.add(((TaggingPreset.Combo)item).key);
                    continue;
                }
                if (item instanceof TaggingPreset.Key) {
                    this.tags.add(((TaggingPreset.Key)item).key);
                    String string = ((TaggingPreset.Key)item).value;
                    if (string == null) continue;
                    this.tags.add(string);
                    continue;
                }
                if (item instanceof TaggingPreset.Text) {
                    this.tags.add(((TaggingPreset.Text)item).key);
                    continue;
                }
                if (!(item instanceof TaggingPreset.Roles)) continue;
                for (TaggingPreset.Role role : ((TaggingPreset.Roles)item).roles) {
                    this.tags.add(role.key);
                }
            }
        }

        private int isMatching(Collection<String> collection, String[] stringArray) {
            int n = 0;
            for (String string : stringArray) {
                boolean bl = false;
                boolean bl2 = false;
                for (String string2 : collection) {
                    int n2 = string2.indexOf(string);
                    if (n2 == 0) {
                        bl2 = true;
                        break;
                    }
                    if (n2 <= 0) continue;
                    bl = true;
                }
                if (bl2) {
                    n += 2;
                    continue;
                }
                if (bl) {
                    ++n;
                    continue;
                }
                return 0;
            }
            return n;
        }

        int isMatchingGroup(String[] stringArray) {
            return this.isMatching(this.groups, stringArray);
        }

        int isMatchingName(String[] stringArray) {
            return this.isMatching(this.names, stringArray);
        }

        int isMatchingTags(String[] stringArray) {
            return this.isMatching(this.tags, stringArray);
        }

        @Override
        public int compareTo(PresetClasification presetClasification) {
            int n = presetClasification.classification - this.classification;
            if (n == 0) {
                return this.preset.getName().compareTo(presetClasification.preset.getName());
            }
            return n;
        }

        public String toString() {
            return this.classification + " " + this.preset.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultListModel
    extends AbstractListModel {
        private List<PresetClasification> presets = new ArrayList<PresetClasification>();

        private ResultListModel() {
        }

        public void setPresets(List<PresetClasification> list) {
            this.presets = list;
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }

        public List<PresetClasification> getPresets() {
            return this.presets;
        }

        @Override
        public Object getElementAt(int n) {
            return this.presets.get((int)n).preset;
        }

        @Override
        public int getSize() {
            return this.presets.size();
        }
    }

    private static class ResultListCellRenderer
    extends DefaultListCellRenderer {
        private ResultListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            TaggingPreset taggingPreset = (TaggingPreset)object;
            jLabel.setText(taggingPreset.getName());
            jLabel.setIcon((Icon)taggingPreset.getValue("SmallIcon"));
            return jLabel;
        }
    }
}

