/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTaskList;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.JpgImporter;
import org.openstreetmap.josm.tools.AudioUtil;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.UrlLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GpxLayer
extends Layer {
    private static final String PREF_DOWNLOAD_ALONG_TRACK_DISTANCE = "gpxLayer.downloadAlongTrack.distance";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_AREA = "gpxLayer.downloadAlongTrack.area";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_NEAR = "gpxLayer.downloadAlongTrack.near";
    public GpxData data;
    protected static final double PHI = Math.toRadians(15.0);
    private boolean computeCacheInSync;
    private int computeCacheMaxLineLengthUsed;
    private Color computeCacheColorUsed;
    private colorModes computeCacheColored;
    private int computeCacheColorTracksTune;
    private boolean isLocalFile;
    private final List<GpxTrack> lastTracks = new ArrayList<GpxTrack>();
    private int lastUpdateCount;
    private static Color[] colors = new Color[256];
    private static int ll0;
    private static int sl4;
    private static int sl9;
    private static int[][] dir;

    public GpxLayer(GpxData gpxData) {
        super((String)gpxData.attr.get("name"));
        this.data = gpxData;
        this.computeCacheInSync = false;
    }

    public GpxLayer(GpxData gpxData, String string) {
        this(gpxData);
        this.setName(string);
    }

    public GpxLayer(GpxData gpxData, String string, boolean bl) {
        this(gpxData);
        this.setName(string);
        this.isLocalFile = bl;
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "gpx_small");
    }

    @Override
    public Object getInfoComponent() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.data.attr.containsKey("name")) {
            stringBuilder.append(I18n.tr("Name: {0}", this.data.attr.get("meta.name"))).append("<br>");
        }
        if (this.data.attr.containsKey("desc")) {
            stringBuilder.append(I18n.tr("Description: {0}", this.data.attr.get("meta.desc"))).append("<br>");
        }
        if (this.data.tracks.size() > 0) {
            stringBuilder.append("<table><thead align='center'><tr><td colspan='5'>" + I18n.trn("{0} track", "{0} tracks", this.data.tracks.size(), this.data.tracks.size()) + "</td></tr><tr align='center'><td>" + I18n.tr("Name") + "</td><td>" + I18n.tr("Description") + "</td><td>" + I18n.tr("Timespan") + "</td><td>" + I18n.tr("Length") + "</td><td>" + I18n.tr("URL") + "</td></tr></thead>");
            for (GpxTrack gpxTrack : this.data.tracks) {
                Object object;
                Object object2;
                WayPoint wayPoint = null;
                WayPoint wayPoint2 = null;
                stringBuilder.append("<tr><td>");
                if (gpxTrack.getAttributes().containsKey("name")) {
                    stringBuilder.append(gpxTrack.getAttributes().get("name"));
                }
                stringBuilder.append("</td><td>");
                if (gpxTrack.getAttributes().containsKey("desc")) {
                    stringBuilder.append(" ").append(gpxTrack.getAttributes().get("desc"));
                }
                stringBuilder.append("</td><td>");
                for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                    object2 = gpxTrackSegment.getWayPoints().iterator();
                    while (object2.hasNext()) {
                        object = object2.next();
                        if (wayPoint2 == null) {
                            wayPoint2 = wayPoint = object;
                            continue;
                        }
                        if (((WayPoint)object).compareTo(wayPoint) < 0) {
                            wayPoint = object;
                            continue;
                        }
                        wayPoint2 = object;
                    }
                }
                if (wayPoint != null && wayPoint2 != null) {
                    DateFormat dateFormat = DateFormat.getDateInstance(3);
                    String string = dateFormat.format(wayPoint.getTime());
                    if (string.equals(object2 = dateFormat.format(wayPoint2.getTime()))) {
                        object = DateFormat.getTimeInstance(3);
                        stringBuilder.append(string).append(" ");
                        stringBuilder.append(((DateFormat)object).format(wayPoint.getTime())).append(" - ").append(((DateFormat)object).format(wayPoint2.getTime()));
                    } else {
                        object = DateFormat.getDateTimeInstance(3, 3);
                        stringBuilder.append(((DateFormat)object).format(wayPoint.getTime())).append(" - ").append(((DateFormat)object).format(wayPoint2.getTime()));
                    }
                    int n = (int)(wayPoint2.time - wayPoint.time);
                    stringBuilder.append(String.format(" (%d:%02d)", n / 3600, n % 3600 / 60));
                }
                stringBuilder.append("</td><td>");
                stringBuilder.append(NavigatableComponent.getSystemOfMeasurement().getDistText(gpxTrack.length()));
                stringBuilder.append("</td><td>");
                if (gpxTrack.getAttributes().containsKey("url")) {
                    stringBuilder.append(gpxTrack.getAttributes().get("url"));
                }
                stringBuilder.append("</td></tr>");
            }
            stringBuilder.append("</table><br><br>");
        }
        stringBuilder.append(I18n.tr("Length: {0}", NavigatableComponent.getSystemOfMeasurement().getDistText(this.data.length()))).append("<br>");
        stringBuilder.append(I18n.trn("{0} route, ", "{0} routes, ", this.data.routes.size(), this.data.routes.size())).append(I18n.trn("{0} waypoint", "{0} waypoints", this.data.waypoints.size(), this.data.waypoints.size())).append("<br>");
        final JScrollPane jScrollPane = new JScrollPane(new HtmlPanel(stringBuilder.toString()), 20, 30);
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, 350));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jScrollPane.getVerticalScrollBar().setValue(0);
            }
        });
        return jScrollPane;
    }

    public static Color getColor(String string) {
        return Main.pref.getColor(I18n.marktr("gps point"), string != null ? "layer " + string : null, Color.gray);
    }

    @Override
    public Action[] getMenuEntries() {
        if (Main.applet) {
            return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new CustomizeColor(), new CustomizeLineDrawing(), new ConvertToDataLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
        }
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new Layer.LayerSaveAction(this), new Layer.LayerSaveAsAction(this), new CustomizeColor(), new CustomizeLineDrawing(), new ImportImages(), new ImportAudio(), new MarkersFromNamedPoins(), new ConvertToDataLayerAction(), new DownloadAlongTrackAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
    }

    @Override
    public String getToolTipText() {
        StringBuilder stringBuilder = new StringBuilder().append("<html>");
        if (this.data.attr.containsKey("name")) {
            stringBuilder.append(I18n.tr("Name: {0}", this.data.attr.get("meta.name"))).append("<br>");
        }
        if (this.data.attr.containsKey("desc")) {
            stringBuilder.append(I18n.tr("Description: {0}", this.data.attr.get("meta.desc"))).append("<br>");
        }
        stringBuilder.append(I18n.trn("{0} track, ", "{0} tracks, ", this.data.tracks.size(), this.data.tracks.size()));
        stringBuilder.append(I18n.trn("{0} route, ", "{0} routes, ", this.data.routes.size(), this.data.routes.size()));
        stringBuilder.append(I18n.trn("{0} waypoint", "{0} waypoints", this.data.waypoints.size(), this.data.waypoints.size())).append("<br>");
        stringBuilder.append(I18n.tr("Length: {0}", NavigatableComponent.getSystemOfMeasurement().getDistText(this.data.length())));
        stringBuilder.append("<br>");
        return stringBuilder.append("</html>").toString();
    }

    @Override
    public boolean isMergable(Layer layer) {
        return layer instanceof GpxLayer;
    }

    private int sumUpdateCount() {
        int n = 0;
        for (GpxTrack gpxTrack : this.data.tracks) {
            n += gpxTrack.getUpdateCount();
        }
        return n;
    }

    @Override
    public boolean isChanged() {
        if (((Object)this.data.tracks).equals(this.lastTracks)) {
            return this.sumUpdateCount() != this.lastUpdateCount;
        }
        return true;
    }

    @Override
    public void mergeFrom(Layer layer) {
        this.data.mergeFrom(((GpxLayer)layer).data);
        this.computeCacheInSync = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        Object object;
        Iterator iterator;
        Object object2;
        Point2D point2D;
        Object object6;
        this.lastUpdateCount = this.sumUpdateCount();
        this.lastTracks.clear();
        this.lastTracks.addAll(this.data.tracks);
        Color color = GpxLayer.getColor(this.getName());
        boolean bl = Main.pref.getBoolean("draw.rawgps.lines.force");
        boolean bl2 = Main.pref.getBoolean("draw.rawgps.direction");
        int n = Main.pref.getInteger("draw.rawgps.linewidth", 0);
        int n2 = this.isLocalFile ? Main.pref.getInteger("draw.rawgps.max-line-length.local", -1) : Main.pref.getInteger("draw.rawgps.max-line-length", 200);
        boolean bl3 = Main.pref.getBoolean("draw.rawgps.lines", true) || Main.pref.getBoolean("draw.rawgps.lines.localfiles") && this.isLocalFile;
        String string = "draw.rawgps.lines.layer " + this.getName();
        if (Main.pref.hasKey(string)) {
            bl3 = Main.pref.getBoolean(string);
        }
        boolean bl4 = Main.pref.getBoolean("draw.rawgps.large");
        boolean bl5 = Main.pref.getBoolean("draw.rawgps.hdopcircle", true);
        colorModes colorModes2 = colorModes.none;
        try {
            colorModes2 = colorModes.values()[Main.pref.getInteger("draw.rawgps.colors", 0)];
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl6 = Main.pref.getBoolean("draw.rawgps.alternatedirection");
        int n3 = Main.pref.getInteger("draw.rawgps.min-arrow-distance", 0);
        int n4 = Main.pref.getInteger("draw.rawgps.colorTracksTune", 45);
        if (n != 0) {
            graphics2D.setStroke(new BasicStroke(n, 1, 1));
        }
        if (this.computeCacheMaxLineLengthUsed != n2 || !color.equals(this.computeCacheColorUsed) || this.computeCacheColored != colorModes2 || this.computeCacheColorTracksTune != n4) {
            this.computeCacheMaxLineLengthUsed = n2;
            this.computeCacheInSync = false;
            this.computeCacheColorUsed = color;
            this.computeCacheColored = colorModes2;
            this.computeCacheColorTracksTune = n4;
        }
        if (!this.computeCacheInSync) {
            object6 = null;
            for (GpxTrack object52 : this.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : object52.getSegments()) {
                    if (!bl) {
                        object6 = null;
                    }
                    for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                        point2D = wayPoint.getCoor();
                        if (Double.isNaN(((LatLon)point2D).lat()) || Double.isNaN(((LatLon)point2D).lon())) continue;
                        wayPoint.customColoring = color;
                        if (object6 != null) {
                            double d = ((LatLon)point2D).greatCircleDistance(((WayPoint)object6).getCoor());
                            switch (colorModes2) {
                                case velocity: {
                                    double d2 = wayPoint.time - ((WayPoint)object6).time;
                                    double d3 = d / d2;
                                    double d4 = d3 / (double)n4 * 255.0;
                                    if (d2 <= 0.0 || d3 < 0.0 || d4 > 255.0) {
                                        wayPoint.customColoring = colors[255];
                                        break;
                                    }
                                    wayPoint.customColoring = colors[(int)d4];
                                    break;
                                }
                                case dilution: {
                                    int n5;
                                    if (wayPoint.attr.get("hdop") == null) break;
                                    float f = ((Float)wayPoint.attr.get("hdop")).floatValue();
                                    if (f < 0.0f) {
                                        f = 0.0f;
                                    }
                                    int n6 = 255 - ((n5 = Math.round(f * (float)Main.pref.getInteger("hdop.factor", 25))) > 255 ? 255 : n5);
                                    wayPoint.customColoring = colors[n6];
                                }
                            }
                            if (n2 == -1 || d <= (double)n2) {
                                wayPoint.drawLine = true;
                                wayPoint.dir = (int)((WayPoint)object6).getCoor().heading(wayPoint.getCoor());
                            } else {
                                wayPoint.drawLine = false;
                            }
                        } else {
                            wayPoint.drawLine = false;
                        }
                        object6 = wayPoint;
                    }
                }
            }
            this.computeCacheInSync = true;
        }
        object6 = new ArrayList<Collection<WayPoint>>();
        for (GpxTrack gpxTrack : this.data.tracks) {
            for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                if (gpxTrackSegment.getBounds() == null || !gpxTrackSegment.getBounds().intersects(bounds)) continue;
                object6.add(gpxTrackSegment.getWayPoints());
            }
        }
        if (bl3) {
            object2 = null;
            Iterator iterator2 = object6.iterator();
            while (iterator2.hasNext()) {
                iterator = (Collection)iterator2.next();
                Iterator iterator3 = iterator.iterator();
                while (iterator3.hasNext()) {
                    object = (WayPoint)iterator3.next();
                    LatLon latLon = ((WayPoint)object).getCoor();
                    if (Double.isNaN(latLon.lat()) || Double.isNaN(latLon.lon())) continue;
                    point2D = mapView.getPoint(((WayPoint)object).getEastNorth());
                    if (((WayPoint)object).drawLine && object2 != null && (((Point)object2).x != ((Point)point2D).x || ((Point)object2).y != ((Point)point2D).y)) {
                        graphics2D.setColor(((WayPoint)object).customColoring);
                        graphics2D.drawLine(((Point)object2).x, ((Point)object2).y, ((Point)point2D).x, ((Point)point2D).y);
                    }
                    object2 = point2D;
                }
            }
        }
        if (bl3 && bl2 && !bl6) {
            object2 = null;
            Object var19_25 = null;
            iterator = object6.iterator();
            while (iterator.hasNext()) {
                Collection collection = (Collection)iterator.next();
                for (WayPoint wayPoint : collection) {
                    void var19_26;
                    point2D = wayPoint.getCoor();
                    if (Double.isNaN(((LatLon)point2D).lat()) || Double.isNaN(((LatLon)point2D).lon()) || !wayPoint.drawLine) continue;
                    Point point = mapView.getPoint(wayPoint.getEastNorth());
                    if (object2 != null && (var19_26 == null || point.x < var19_26.x - n3 || point.x > var19_26.x + n3 || point.y < var19_26.y - n3 || point.y > var19_26.y + n3)) {
                        graphics2D.setColor(wayPoint.customColoring);
                        double d = Math.atan2(point.y - ((Point)object2).y, point.x - ((Point)object2).x) + Math.PI;
                        graphics2D.drawLine(point.x, point.y, (int)((double)point.x + 10.0 * Math.cos(d - PHI)), (int)((double)point.y + 10.0 * Math.sin(d - PHI)));
                        graphics2D.drawLine(point.x, point.y, (int)((double)point.x + 10.0 * Math.cos(d + PHI)), (int)((double)point.y + 10.0 * Math.sin(d + PHI)));
                        Point point2 = point;
                    }
                    object2 = point;
                }
            }
        }
        if (bl3 && bl2 && bl6) {
            object2 = null;
            Object var19_29 = null;
            iterator = object6.iterator();
            while (iterator.hasNext()) {
                Collection collection = (Collection)iterator.next();
                for (WayPoint wayPoint : collection) {
                    void var19_30;
                    point2D = wayPoint.getCoor();
                    if (Double.isNaN(((LatLon)point2D).lat()) || Double.isNaN(((LatLon)point2D).lon()) || !wayPoint.drawLine) continue;
                    Point point = mapView.getPoint(wayPoint.getEastNorth());
                    if (object2 != null && (var19_30 == null || point.x < var19_30.x - n3 || point.x > var19_30.x + n3 || point.y < var19_30.y - n3 || point.y > var19_30.y + n3)) {
                        graphics2D.setColor(wayPoint.customColoring);
                        graphics2D.drawLine(point.x, point.y, point.x + dir[wayPoint.dir][0], point.y + dir[wayPoint.dir][1]);
                        graphics2D.drawLine(point.x, point.y, point.x + dir[wayPoint.dir][2], point.y + dir[wayPoint.dir][3]);
                        Point point3 = point;
                    }
                    object2 = point;
                }
            }
        }
        if (bl4 || bl5) {
            graphics2D.setColor(color);
            object2 = object6.iterator();
            while (object2.hasNext()) {
                Collection collection = (Collection)((Object)object2.next());
                for (WayPoint wayPoint : collection) {
                    object = wayPoint.getCoor();
                    if (Double.isNaN(((LatLon)object).lat()) || Double.isNaN(((LatLon)object).lon())) continue;
                    Point point = mapView.getPoint(wayPoint.getEastNorth());
                    graphics2D.setColor(wayPoint.customColoring);
                    if (bl5 && wayPoint.attr.get("hdop") != null) {
                        float f = ((Float)wayPoint.attr.get("hdop")).floatValue();
                        if (f < 0.0f) {
                            f = 0.0f;
                        }
                        int n7 = mapView.getPoint((LatLon)new LatLon((double)wayPoint.getCoor().lat(), (double)(wayPoint.getCoor().lon() + (double)(12.0f * f * 360.0f / 4.0E7f)))).x - point.x;
                        graphics2D.drawArc(point.x - n7 / 2, point.y - n7 / 2, n7, n7, 0, 360);
                    }
                    if (!bl4) continue;
                    graphics2D.fillRect(point.x - 1, point.y - 1, 3, 3);
                }
            }
        }
        if (!bl4 && bl3) {
            graphics2D.setColor(color);
            object2 = object6.iterator();
            while (object2.hasNext()) {
                Collection collection = (Collection)((Object)object2.next());
                for (WayPoint wayPoint : collection) {
                    object = wayPoint.getCoor();
                    if (Double.isNaN(((LatLon)object).lat()) || Double.isNaN(((LatLon)object).lon()) || wayPoint.drawLine) continue;
                    Point point = mapView.getPoint(wayPoint.getEastNorth());
                    graphics2D.drawRect(point.x, point.y, 0, 0);
                }
            }
        }
        if (!bl4 && !bl3) {
            graphics2D.setColor(color);
            object2 = object6.iterator();
            while (object2.hasNext()) {
                Collection collection = (Collection)((Object)object2.next());
                for (WayPoint wayPoint : collection) {
                    object = wayPoint.getCoor();
                    if (Double.isNaN(((LatLon)object).lat()) || Double.isNaN(((LatLon)object).lon())) continue;
                    Point point = mapView.getPoint(wayPoint.getEastNorth());
                    graphics2D.setColor(wayPoint.customColoring);
                    graphics2D.drawRect(point.x, point.y, 0, 0);
                }
            }
        }
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        boundingXYVisitor.visit(this.data.recalculateBounds());
    }

    @Override
    public File getAssociatedFile() {
        return this.data.storageFile;
    }

    @Override
    public void setAssociatedFile(File file) {
        this.data.storageFile = file;
    }

    private static void addToDownload(Area area, Rectangle2D rectangle2D, Collection<Rectangle2D> collection, double d) {
        Area area2 = new Area(rectangle2D);
        area2.intersect(area);
        if (area2.isEmpty()) {
            return;
        }
        Rectangle2D rectangle2D2 = area2.getBounds2D();
        if (rectangle2D2.getWidth() * rectangle2D2.getHeight() > d) {
            Rectangle2D.Double double_;
            Rectangle2D.Double double_2;
            if (rectangle2D2.getWidth() > rectangle2D2.getHeight()) {
                double_2 = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth() / 2.0, rectangle2D2.getHeight());
                double_ = new Rectangle2D.Double(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0, rectangle2D2.getY(), rectangle2D2.getWidth() / 2.0, rectangle2D2.getHeight());
            } else {
                double_2 = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight() / 2.0);
                double_ = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0, rectangle2D2.getWidth(), rectangle2D2.getHeight() / 2.0);
            }
            GpxLayer.addToDownload(area, double_2, collection, d);
            GpxLayer.addToDownload(area, double_, collection, d);
        } else {
            collection.add(rectangle2D2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void importAudio(File file, MarkerLayer markerLayer, double d, Markers markers) {
        WayPoint wayPoint;
        WayPoint wayPoint2;
        String string = "file:".concat(file.getAbsolutePath());
        ArrayList<WayPoint> arrayList = new ArrayList<WayPoint>();
        boolean bl = false;
        boolean bl2 = false;
        double d2 = Main.pref.getDouble("marker.audiofromuntimedwaypoints.distance", 0.001);
        WayPoint wayPoint3 = null;
        double d3 = -1.0;
        if (this.data.tracks != null && !this.data.tracks.isEmpty()) {
            for (GpxTrack object2 : this.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : object2.getSegments()) {
                    Iterator<WayPoint> iterator = gpxTrackSegment.getWayPoints().iterator();
                    if (iterator.hasNext()) {
                        WayPoint wayPoint4 = iterator.next();
                        d3 = wayPoint4.time;
                    }
                    if (!(d3 >= 0.0)) continue;
                    break;
                }
                if (!(d3 >= 0.0)) continue;
                break;
            }
        }
        if (d3 < 0.0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No GPX track available in layer to associate audio with."), I18n.tr("Error"), 0);
            return;
        }
        if (Main.pref.getBoolean("marker.audiofromexplicitwaypoints", true) && this.data.waypoints != null && !this.data.waypoints.isEmpty()) {
            for (WayPoint wayPoint5 : this.data.waypoints) {
                if (wayPoint5.time > d3) {
                    arrayList.add(wayPoint5);
                    continue;
                }
                if (!(wayPoint5.time > 0.0)) continue;
                bl = true;
            }
        }
        if (Main.pref.getBoolean("marker.audiofromuntimedwaypoints", true) && this.data.waypoints != null && !this.data.waypoints.isEmpty()) {
            for (WayPoint wayPoint6 : this.data.waypoints) {
                if (arrayList.contains(wayPoint6)) continue;
                WayPoint wayPoint7 = this.nearestPointOnTrack(wayPoint6.getEastNorth(), d2);
                if (wayPoint7 != null) {
                    WayPoint wayPoint8 = new WayPoint(wayPoint6.getCoor());
                    wayPoint8.time = wayPoint7.time;
                    if (wayPoint6.attr.containsKey("name")) {
                        wayPoint8.attr.put("name", wayPoint6.getString("name"));
                    }
                    arrayList.add(wayPoint8);
                    continue;
                }
                bl2 = true;
            }
        }
        if (Main.pref.getBoolean("marker.audiofromnamedtrackpoints", false) && this.data.tracks != null && !this.data.tracks.isEmpty()) {
            for (GpxTrack gpxTrack : this.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                    for (WayPoint wayPoint9 : gpxTrackSegment.getWayPoints()) {
                        if (!wayPoint9.attr.containsKey("name") && !wayPoint9.attr.containsKey("desc")) continue;
                        arrayList.add(wayPoint9);
                    }
                }
            }
        }
        if (Main.pref.getBoolean("marker.audiofromwavtimestamps", false) && this.data.tracks != null && !this.data.tracks.isEmpty()) {
            double d4 = (double)file.lastModified() / 1000.0;
            double d5 = AudioUtil.getCalibratedDuration(file);
            double d6 = d4 - d5;
            d6 = d + (d6 - d) / Main.pref.getDouble("audio.calibration", "1.0");
            wayPoint2 = null;
            wayPoint = null;
            block7: for (GpxTrack gpxTrack : this.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                    for (WayPoint wayPoint10 : gpxTrackSegment.getWayPoints()) {
                        if (d6 < wayPoint10.time) {
                            wayPoint = wayPoint10;
                            break;
                        }
                        wayPoint2 = wayPoint10;
                    }
                    if (wayPoint == null) continue;
                    continue block7;
                }
            }
            if (wayPoint2 == null || wayPoint == null) {
                bl = true;
            } else {
                wayPoint3 = new WayPoint(wayPoint2.getCoor().interpolate(wayPoint.getCoor(), (d6 - wayPoint2.time) / (wayPoint.time - wayPoint2.time)));
                wayPoint3.time = d6;
                Object object = file.getName();
                int n = ((String)object).lastIndexOf(".");
                if (n > 0) {
                    object = ((String)object).substring(0, n);
                }
                wayPoint3.attr.put("name", object);
                arrayList.add(wayPoint3);
            }
        }
        if ((Main.pref.getBoolean("marker.audiofromstart") || arrayList.isEmpty()) && this.data.tracks != null && !this.data.tracks.isEmpty()) {
            boolean bl3 = false;
            for (GpxTrack gpxTrack : this.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                    Iterator<WayPoint> iterator = gpxTrackSegment.getWayPoints().iterator();
                    if (iterator.hasNext()) {
                        wayPoint2 = iterator.next();
                        wayPoint = new WayPoint(wayPoint2.getCoor());
                        wayPoint.attr.put("name", "start");
                        wayPoint.time = wayPoint2.time;
                        arrayList.add(wayPoint);
                        bl3 = true;
                    }
                    if (!bl3) continue;
                    break;
                }
                if (!bl3) continue;
                break;
            }
        }
        Collections.sort(arrayList, new Comparator<WayPoint>(){

            @Override
            public int compare(WayPoint wayPoint, WayPoint wayPoint2) {
                return wayPoint.time <= wayPoint2.time ? -1 : 1;
            }
        });
        d3 = -1.0;
        for (WayPoint wayPoint11 : arrayList) {
            void var19_53;
            if (d3 < 0.0) {
                d3 = wayPoint11.time;
            }
            double d7 = wayPoint11.time - d3;
            if (wayPoint11.attr.containsKey("name")) {
                String string2 = wayPoint11.getString("name");
            } else if (wayPoint11.attr.containsKey("desc")) {
                String string3 = wayPoint11.getString("desc");
            } else {
                String string4 = AudioMarker.inventName(d7);
            }
            AudioMarker audioMarker = AudioMarker.create(wayPoint11.getCoor(), (String)var19_53, string, markerLayer, wayPoint11.time, d7);
            if (wayPoint11 == wayPoint3) {
                audioMarker.timeFromAudio = true;
            }
            markerLayer.data.add(audioMarker);
        }
        if (bl && !markers.timedMarkersOmitted) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Some waypoints with timestamps from before the start of the track or after the end were omitted or moved to the start."));
            markers.timedMarkersOmitted = bl;
        }
        if (bl2 && !markers.untimedMarkersOmitted) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Some waypoints which were too far from the track to sensibly estimate their time were omitted."));
            markers.untimedMarkersOmitted = bl2;
        }
    }

    public WayPoint nearestPointOnTrack(EastNorth eastNorth, double d) {
        double d2 = d * d;
        Object object = null;
        double d3 = 0.0;
        double d4 = eastNorth.east();
        double d5 = eastNorth.north();
        double d6 = 0.0;
        double d7 = 0.0;
        if (this.data.tracks == null) {
            return null;
        }
        for (GpxTrack gpxTrack : this.data.tracks) {
            for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                double d8;
                double d9;
                double d10;
                WayPoint wayPoint = null;
                Object object2 = gpxTrackSegment.getWayPoints().iterator();
                while (object2.hasNext()) {
                    double d11;
                    WayPoint wayPoint2 = object2.next();
                    EastNorth eastNorth2 = wayPoint2.getEastNorth();
                    if (wayPoint == null) {
                        wayPoint = wayPoint2;
                        d6 = eastNorth2.east();
                        d10 = d4 - d6;
                        d11 = d10 * d10 + (d9 = d5 - (d7 = eastNorth2.north())) * d9;
                        if (!(d11 < d2)) continue;
                        d2 = d11;
                        object = eastNorth2;
                        d3 = wayPoint.time;
                        continue;
                    }
                    double d12 = eastNorth2.east();
                    double d13 = eastNorth2.north();
                    d11 = d13 - d7;
                    double d14 = d6 - d12;
                    double d15 = -d11 * d6 - d14 * d7;
                    double d16 = d11 * d11 + d14 * d14;
                    if (d16 == 0.0) continue;
                    double d17 = d11 * d4 + d14 * d5 + d15;
                    if ((d17 = d17 * d17 / d16) < d2) {
                        d10 = d4 - d6;
                        d9 = d5 - d7;
                        double d18 = d10 * d10 + d9 * d9;
                        d10 = d4 - d12;
                        d9 = d5 - d13;
                        double d19 = d10 * d10 + d9 * d9;
                        if (d18 - d17 <= d16 && d19 - d17 <= d16) {
                            double d20 = Math.sqrt((d18 - d17) / d16);
                            double d21 = d6 - d20 * d14;
                            double d22 = d7 + d20 * d11;
                            object = new EastNorth(d21, d22);
                            d3 = wayPoint.time + d20 * (wayPoint2.time - wayPoint.time);
                            d2 = d17;
                        }
                    }
                    wayPoint = wayPoint2;
                    d6 = d12;
                    d7 = d13;
                }
                if (wayPoint == null || !((d8 = (d10 = d4 - (d6 = ((EastNorth)(object2 = wayPoint.getEastNorth())).east())) * d10 + (d9 = d5 - (d7 = ((EastNorth)object2).north())) * d9) < d2)) continue;
                d2 = d8;
                object = object2;
                d3 = wayPoint.time;
            }
        }
        if (object == null) {
            return null;
        }
        WayPoint wayPoint = new WayPoint(Main.proj.eastNorth2latlon((EastNorth)object));
        wayPoint.time = d3;
        return wayPoint;
    }

    static {
        for (int i = 0; i < colors.length; ++i) {
            GpxLayer.colors[i] = Color.getHSBColor((float)i / 300.0f, 1.0f, 1.0f);
        }
        ll0 = 9;
        sl4 = 5;
        sl9 = 3;
        dir = new int[][]{{sl4, ll0, ll0, sl4}, {-sl9, ll0, sl9, ll0}, {-ll0, sl4, -sl4, ll0}, {-ll0, -sl9, -ll0, sl9}, {-sl4, -ll0, -ll0, -sl4}, {sl9, -ll0, -sl9, -ll0}, {ll0, -sl4, sl4, -ll0}, {ll0, sl9, ll0, -sl9}, {sl4, ll0, ll0, sl4}, {-sl9, ll0, sl9, ll0}, {-ll0, sl4, -sl4, ll0}, {-ll0, -sl9, -ll0, sl9}};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImportImages
    extends AbstractAction {
        public ImportImages() {
            super(I18n.tr("Import images"), ImageProvider.get("dialogs/geoimage"));
            this.putValue("help", HelpUtil.ht("/Action/ImportImages"));
        }

        private void warnCantImportIntoServerLayer(GpxLayer gpxLayer) {
            String string = I18n.tr("<html>The data in the GPX layer ''{0}'' has been downloaded from the server.<br>Because its way points do not include a timestamp we cannot correlate them with images.</html>", gpxLayer.getName());
            HelpAwareOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Import not possible"), 2, HelpUtil.ht("/Action/ImportImages#CantImportIntoGpxLayerFromServer"));
        }

        private void addRecursiveFiles(LinkedList<File> linkedList, File[] fileArray) {
            for (File file : fileArray) {
                if (file.isDirectory()) {
                    this.addRecursiveFiles(linkedList, file.listFiles());
                    continue;
                }
                if (!file.getName().toLowerCase().endsWith(".jpg")) continue;
                linkedList.add(file);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (GpxLayer.this.data.fromServer) {
                this.warnCantImportIntoServerLayer(GpxLayer.this);
                return;
            }
            String string = Main.pref.get("geoimage.lastdirectory", Main.pref.get("lastDirectory"));
            if (string.equals("")) {
                string = ".";
            }
            JFileChooser jFileChooser = new JFileChooser(new File(string));
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            JpgImporter jpgImporter = new JpgImporter(GpxLayer.this);
            jFileChooser.setFileFilter(jpgImporter.filter);
            jFileChooser.showOpenDialog(Main.parent);
            LinkedList<File> linkedList = new LinkedList<File>();
            File[] fileArray = jFileChooser.getSelectedFiles();
            if (fileArray == null || fileArray.length == 0) {
                return;
            }
            if (!jFileChooser.getCurrentDirectory().getAbsolutePath().equals(string)) {
                Main.pref.put("geoimage.lastdirectory", jFileChooser.getCurrentDirectory().getAbsolutePath());
            }
            this.addRecursiveFiles(linkedList, fileArray);
            jpgImporter.importDataHandleExceptions(linkedList, NullProgressMonitor.INSTANCE);
        }
    }

    private class ImportAudio
    extends AbstractAction {
        public ImportAudio() {
            super(I18n.tr("Import Audio"), ImageProvider.get("importaudio"));
            this.putValue("help", "ImportAudio");
        }

        private void warnCantImportIntoServerLayer(GpxLayer gpxLayer) {
            String string = I18n.tr("<html>The data in the GPX layer ''{0}'' has been downloaded from the server.<br>Because its way points do not include a timestamp we cannot correlate them with audio data.</html>", gpxLayer.getName());
            HelpAwareOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Import not possible"), 2, HelpUtil.ht("/Action/ImportImages#CantImportIntoGpxLayerFromServer"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (GpxLayer.this.data.fromServer) {
                this.warnCantImportIntoServerLayer(GpxLayer.this);
                return;
            }
            String string = Main.pref.get("markers.lastaudiodirectory");
            JFileChooser jFileChooser = new JFileChooser(string);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".wav");
                }

                public String getDescription() {
                    return I18n.tr("Wave Audio files (*.wav)");
                }
            });
            jFileChooser.setMultiSelectionEnabled(true);
            if (jFileChooser.showOpenDialog(Main.parent) == 0) {
                File[] fileArray;
                if (!jFileChooser.getCurrentDirectory().getAbsolutePath().equals(string)) {
                    Main.pref.put("markers.lastaudiodirectory", jFileChooser.getCurrentDirectory().getAbsolutePath());
                }
                if ((fileArray = jFileChooser.getSelectedFiles()).length > 1) {
                    Arrays.sort(fileArray, new Comparator<File>(){

                        @Override
                        public int compare(File file, File file2) {
                            return file.lastModified() <= file2.lastModified() ? -1 : 1;
                        }
                    });
                }
                String string2 = null;
                for (int i = 0; i < fileArray.length; ++i) {
                    string2 = string2 == null ? " (" : string2 + ", ";
                    string2 = string2 + fileArray[i].getName();
                }
                string2 = string2 != null ? string2 + ")" : "";
                MarkerLayer markerLayer = new MarkerLayer(new GpxData(), I18n.tr("Audio markers from {0}", GpxLayer.this.getName()) + string2, GpxLayer.this.getAssociatedFile(), GpxLayer.this);
                double d = (double)fileArray[0].lastModified() / 1000.0 - AudioUtil.getCalibratedDuration(fileArray[0]);
                Markers markers = new Markers();
                for (int i = 0; i < fileArray.length; ++i) {
                    GpxLayer.this.importAudio(fileArray[i], markerLayer, d, markers);
                }
                Main.main.addLayer(markerLayer);
                Main.map.repaint();
            }
        }
    }

    private class MarkersFromNamedPoins
    extends AbstractAction {
        public MarkersFromNamedPoins() {
            super(I18n.tr("Markers From Named Points"), ImageProvider.get("addmarkers"));
            this.putValue("help", "Action/MarkersFromNamedPoints");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GpxData gpxData = new GpxData();
            for (GpxTrack gpxTrack : GpxLayer.this.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                    for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                        if (!wayPoint.attr.containsKey("name") && !wayPoint.attr.containsKey("desc")) continue;
                        gpxData.waypoints.add(wayPoint);
                    }
                }
            }
            MarkerLayer markerLayer = new MarkerLayer(gpxData, I18n.tr("Named Trackpoints from {0}", GpxLayer.this.getName()), GpxLayer.this.getAssociatedFile(), GpxLayer.this);
            if (markerLayer.data.size() > 0) {
                Main.main.addLayer(markerLayer);
            }
        }
    }

    private class CustomizeColor
    extends AbstractAction {
        public CustomizeColor() {
            super(I18n.tr("Customize Color"), ImageProvider.get("colorchooser"));
            this.putValue("help", "Action/LayerCustomizeColor");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JColorChooser jColorChooser = new JColorChooser(GpxLayer.getColor(GpxLayer.this.getName()));
            Object[] objectArray = new Object[]{I18n.tr("OK"), I18n.tr("Cancel"), I18n.tr("Default")};
            int n = JOptionPane.showOptionDialog(Main.parent, jColorChooser, I18n.tr("Choose a color"), 2, -1, null, objectArray, objectArray[0]);
            switch (n) {
                case 0: {
                    Main.pref.putColor("layer " + GpxLayer.this.getName(), jColorChooser.getColor());
                    break;
                }
                case 1: {
                    return;
                }
                case 2: {
                    Main.pref.putColor("layer " + GpxLayer.this.getName(), null);
                }
            }
            Main.map.repaint();
        }
    }

    private class CustomizeLineDrawing
    extends AbstractAction {
        CustomizeLineDrawing() {
            super(I18n.tr("Customize line drawing"), ImageProvider.get("mapmode/addsegment"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton[] jRadioButtonArray = new JRadioButton[]{new JRadioButton(I18n.tr("Use global settings.")), new JRadioButton(I18n.tr("Draw lines between points for this layer.")), new JRadioButton(I18n.tr("Do not draw lines between points for this layer."))};
            ButtonGroup buttonGroup = new ButtonGroup();
            Box box = Box.createVerticalBox();
            for (JRadioButton jRadioButton : jRadioButtonArray) {
                buttonGroup.add(jRadioButton);
                box.add(jRadioButton);
            }
            String string = "draw.rawgps.lines.layer " + GpxLayer.this.getName();
            if (Main.pref.hasKey(string)) {
                buttonGroup.setSelected(jRadioButtonArray[Main.pref.getBoolean(string) ? 1 : 2].getModel(), true);
            } else {
                buttonGroup.setSelected(jRadioButtonArray[0].getModel(), true);
            }
            int n = JOptionPane.showConfirmDialog(Main.parent, box, I18n.tr("Select line drawing options"), 2, 3);
            switch (n) {
                case -1: 
                case 2: {
                    return;
                }
            }
            if (buttonGroup.getSelection() == jRadioButtonArray[0].getModel()) {
                Main.pref.put(string, null);
            } else {
                Main.pref.put(string, buttonGroup.getSelection() == jRadioButtonArray[1].getModel());
            }
            Main.map.repaint();
        }
    }

    public class DownloadAlongTrackAction
    extends AbstractAction {
        public DownloadAlongTrackAction() {
            super(I18n.tr("Download from OSM along this track"), ImageProvider.get("downloadalongtrack"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Future<?> future;
            JPanel jPanel = new JPanel(new GridBagLayout());
            Integer[] integerArray = new Integer[]{5000, 500, 50};
            Integer[] integerArray2 = new Integer[]{20, 10, 5, 1};
            jPanel.add((Component)new JLabel(I18n.tr("Download everything within:")), GBC.eol());
            String[] stringArray = new String[integerArray.length];
            for (int i = 0; i < integerArray.length; ++i) {
                stringArray[i] = I18n.tr("{0} meters", integerArray[i]);
            }
            JList<String> jList = new JList<String>(stringArray);
            jList.setSelectedIndex(Main.pref.getInteger(GpxLayer.PREF_DOWNLOAD_ALONG_TRACK_DISTANCE, 0));
            jPanel.add(jList, GBC.eol());
            jPanel.add((Component)new JLabel(I18n.tr("Maximum area per request:")), GBC.eol());
            stringArray = new String[integerArray2.length];
            for (int i = 0; i < integerArray2.length; ++i) {
                stringArray[i] = I18n.tr("{0} sq km", integerArray2[i]);
            }
            JList<String> jList2 = new JList<String>(stringArray);
            jList2.setSelectedIndex(Main.pref.getInteger(GpxLayer.PREF_DOWNLOAD_ALONG_TRACK_AREA, 0));
            jPanel.add(jList2, GBC.eol());
            jPanel.add((Component)new JLabel(I18n.tr("Download near:")), GBC.eol());
            JList<String> jList3 = new JList<String>(new String[]{I18n.tr("track only"), I18n.tr("waypoints only"), I18n.tr("track and waypoints")});
            int n = 0;
            int n2 = 1;
            int n3 = 2;
            jList3.setSelectedIndex(Main.pref.getInteger(GpxLayer.PREF_DOWNLOAD_ALONG_TRACK_NEAR, 0));
            jPanel.add(jList3, GBC.eol());
            int n4 = JOptionPane.showConfirmDialog(Main.parent, jPanel, I18n.tr("Download from OSM along this track"), 2, 3);
            switch (n4) {
                case -1: 
                case 2: {
                    return;
                }
            }
            Main.pref.putInteger(GpxLayer.PREF_DOWNLOAD_ALONG_TRACK_DISTANCE, jList.getSelectedIndex());
            Main.pref.putInteger(GpxLayer.PREF_DOWNLOAD_ALONG_TRACK_AREA, jList2.getSelectedIndex());
            int n5 = jList3.getSelectedIndex();
            Main.pref.putInteger(GpxLayer.PREF_DOWNLOAD_ALONG_TRACK_NEAR, n5);
            double d = 0.0;
            int n6 = 0;
            if (n5 == n || n5 == n3) {
                for (GpxTrack object2 : GpxLayer.this.data.tracks) {
                    for (GpxTrackSegment gpxTrackSegment : object2.getSegments()) {
                        for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                            d += wayPoint.getCoor().lat();
                            ++n6;
                        }
                    }
                }
            }
            if (n5 == n2 || n5 == n3) {
                for (WayPoint wayPoint : GpxLayer.this.data.waypoints) {
                    d += wayPoint.getCoor().lat();
                    ++n6;
                }
            }
            double d2 = d / (double)n6;
            double d3 = Math.cos(Math.toRadians(d2));
            Object object = jList.getSelectedIndex();
            int n7 = integerArray[(Integer)object < 0 ? 0 : (Integer)object];
            double d4 = (double)n7 / 100000.0;
            double d5 = d4 / d3;
            object = jList2.getSelectedIndex();
            double d6 = (double)integerArray2[(Integer)object < 0 ? 0 : (Integer)object].intValue() / 10000.0 / d3;
            Area area = new Area();
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            Object object2 = null;
            if (n5 == n || n5 == n3) {
                for (GpxTrack gpxTrack : GpxLayer.this.data.tracks) {
                    for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                        for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                            LatLon latLon = wayPoint.getCoor();
                            if (object2 != null && !(latLon.greatCircleDistance((LatLon)object2) > (double)n7)) continue;
                            ((Rectangle2D)double_).setRect(latLon.lon() - d5, latLon.lat() - d4, 2.0 * d5, 2.0 * d4);
                            area.add(new Area(double_));
                            object2 = latLon;
                        }
                    }
                }
            }
            if (n5 == n2 || n5 == n3) {
                for (WayPoint wayPoint : GpxLayer.this.data.waypoints) {
                    future = wayPoint.getCoor();
                    if (object2 != null && !(((LatLon)((Object)future)).greatCircleDistance((LatLon)object2) > (double)n7)) continue;
                    ((Rectangle2D)double_).setRect(((LatLon)((Object)future)).lon() - d5, ((LatLon)((Object)future)).lat() - d4, 2.0 * d5, 2.0 * d4);
                    area.add(new Area(double_));
                    object2 = future;
                }
            }
            ArrayList arrayList = new ArrayList();
            GpxLayer.addToDownload(area, area.getBounds(), arrayList, d6);
            jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JLabel(I18n.tr("<html>This action will require {0} individual<br>download requests. Do you wish<br>to continue?</html>", arrayList.size())), GBC.eol());
            if (arrayList.size() > 1) {
                n4 = JOptionPane.showConfirmDialog(Main.parent, jPanel, I18n.tr("Download from OSM along this track"), 2, -1);
                switch (n4) {
                    case -1: 
                    case 2: {
                        return;
                    }
                }
            }
            final PleaseWaitProgressMonitor pleaseWaitProgressMonitor = new PleaseWaitProgressMonitor(I18n.tr("Download data"));
            future = new DownloadOsmTaskList().download(false, arrayList, (ProgressMonitor)pleaseWaitProgressMonitor);
            Main.worker.submit(new Runnable(){

                public void run() {
                    try {
                        future.get();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                    pleaseWaitProgressMonitor.close();
                }
            });
        }
    }

    public class ConvertToDataLayerAction
    extends AbstractAction {
        public ConvertToDataLayerAction() {
            super(I18n.tr("Convert to data layer"), ImageProvider.get("converttoosm"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JLabel(I18n.tr("<html>Upload of unprocessed GPS data as map data is considered harmful.<br>If you want to upload traces, look here:")), GBC.eol());
            jPanel.add((Component)new UrlLabel(I18n.tr("http://www.openstreetmap.org/traces")), GBC.eop());
            if (!ConditionalOptionPaneUtil.showConfirmationDialog("convert_to_data", Main.parent, jPanel, I18n.tr("Warning"), 2, 2, 0)) {
                return;
            }
            DataSet dataSet = new DataSet();
            for (GpxTrack gpxTrack : GpxLayer.this.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                    ArrayList<Node> arrayList = new ArrayList<Node>();
                    for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                        Node node = new Node(wayPoint.getCoor());
                        String string = wayPoint.getString("time");
                        if (string != null) {
                            node.setTimestamp(DateUtils.fromString(string));
                        }
                        dataSet.addPrimitive(node);
                        arrayList.add(node);
                    }
                    Way way = new Way();
                    way.setNodes(arrayList);
                    dataSet.addPrimitive(way);
                }
            }
            Main.main.addLayer(new OsmDataLayer(dataSet, I18n.tr("Converted from: {0}", GpxLayer.this.getName()), GpxLayer.this.getAssociatedFile()));
            Main.main.removeLayer(GpxLayer.this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum colorModes {
        none,
        velocity,
        dilution;

    }

    private static class Markers {
        public boolean timedMarkersOmitted = false;
        public boolean untimedMarkersOmitted = false;

        private Markers() {
        }
    }
}

