/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.UrlLabel;

public class VersionInfoPanel
extends JPanel
implements Observer {
    private static final Logger logger = Logger.getLogger(VersionInfoPanel.class.getName());
    private PointInTimeType pointInTimeType;
    private HistoryBrowserModel model;
    private JMultilineLabel lblInfo;
    private UrlLabel lblUser;
    private UrlLabel lblChangeset;
    private JPanel pnlUserAndChangeset;

    protected void build() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.lblInfo = new JMultilineLabel("");
        jPanel.add((Component)this.lblInfo, "Center");
        this.pnlUserAndChangeset = new JPanel();
        this.pnlUserAndChangeset.setLayout(new FlowLayout(0));
        this.lblUser = new UrlLabel();
        this.pnlUserAndChangeset.add(new JLabel(I18n.tr("User")));
        this.pnlUserAndChangeset.add(this.lblUser);
        this.pnlUserAndChangeset.add(new JLabel(I18n.tr("Changeset")));
        this.lblChangeset = new UrlLabel();
        this.pnlUserAndChangeset.add(this.lblChangeset);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.pnlUserAndChangeset, gridBagConstraints);
    }

    protected HistoryOsmPrimitive getPrimitive() {
        if (this.model == null || this.pointInTimeType == null) {
            return null;
        }
        return this.model.getPointInTime(this.pointInTimeType);
    }

    protected OsmDataLayer getEditLayer() {
        try {
            return Main.map.mapView.getEditLayer();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    protected String getInfoText() {
        HistoryOsmPrimitive historyOsmPrimitive = this.getPrimitive();
        if (historyOsmPrimitive == null) {
            return "";
        }
        String string = this.model.isLatest(historyOsmPrimitive) ? I18n.tr("<html>Version <strong>{0}</strong> currently edited in layer ''{1}''</html>", Long.toString(historyOsmPrimitive.getVersion()), this.getEditLayer() == null ? I18n.tr("unknown") : this.getEditLayer().getName()) : I18n.tr("<html>Version <strong>{0}</strong> created on <strong>{1}</strong></html>", Long.toString(historyOsmPrimitive.getVersion()), new SimpleDateFormat().format(historyOsmPrimitive.getTimestamp()));
        return string;
    }

    public VersionInfoPanel() {
        this.pointInTimeType = null;
        this.model = null;
        this.build();
    }

    public VersionInfoPanel(HistoryBrowserModel historyBrowserModel, PointInTimeType pointInTimeType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        CheckParameterUtil.ensureParameterNotNull(historyBrowserModel, "model");
        this.model = historyBrowserModel;
        this.pointInTimeType = pointInTimeType;
        historyBrowserModel.addObserver(this);
        this.build();
    }

    public void update(Observable observable, Object object) {
        this.lblInfo.setText(this.getInfoText());
        if (!this.model.isLatest(this.getPrimitive())) {
            String string = AbstractInfoAction.getBaseBrowseUrl() + "/changeset/" + this.getPrimitive().getChangesetId();
            this.lblChangeset.setUrl(string);
            this.lblChangeset.setDescription(Long.toString(this.getPrimitive().getChangesetId()));
            try {
                if (this.getPrimitive().getUid() != -1L) {
                    string = AbstractInfoAction.getBaseUserUrl() + "/" + URLEncoder.encode(this.getPrimitive().getUser(), "UTF-8").replaceAll("\\+", "%20");
                    this.lblUser.setUrl(string);
                } else {
                    this.lblUser.setUrl(null);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                this.lblUser.setUrl(null);
            }
            String string2 = this.getPrimitive().getUser();
            this.lblUser.setDescription(string2);
        } else {
            String string = Main.pref.get("osm-server.username");
            if (string == null) {
                this.lblUser.setDescription(I18n.tr("anonymous"));
            } else {
                try {
                    String string3 = AbstractInfoAction.getBaseUserUrl() + "/" + URLEncoder.encode(string, "UTF-8").replaceAll("\\+", "%20");
                    this.lblUser.setUrl(string3);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                    this.lblUser.setUrl(null);
                }
                this.lblUser.setDescription(string);
            }
            this.lblChangeset.setDescription(I18n.tr("none"));
            this.lblChangeset.setUrl(null);
        }
    }
}

