/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.CopyAction;
import org.openstreetmap.josm.actions.PasteTagsAction;
import org.openstreetmap.josm.actions.mapmode.DeleteAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ConflictAddCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.properties.PresetListPanel;
import org.openstreetmap.josm.gui.dialogs.relation.ChildRelationBrowser;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.ReferringRelationsBrowser;
import org.openstreetmap.josm.gui.dialogs.relation.ReferringRelationsBrowserModel;
import org.openstreetmap.josm.gui.dialogs.relation.RelationDialogManager;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTable;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableModel;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericRelationEditor
extends RelationEditor {
    private static final Logger logger = Logger.getLogger(GenericRelationEditor.class.getName());
    private TagEditorPanel tagEditorPanel;
    private ReferringRelationsBrowser referrerBrowser;
    private ReferringRelationsBrowserModel referrerModel;
    private MemberTable memberTable;
    private MemberTableModel memberTableModel;
    private SelectionTable selectionTable;
    private SelectionTableModel selectionTableModel;
    private AutoCompletingTextField tfRole;

    public GenericRelationEditor(OsmDataLayer osmDataLayer, Relation relation, Collection<RelationMember> collection) {
        super(osmDataLayer, relation, collection);
        this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(700, 650)));
        this.memberTableModel = new MemberTableModel(this.getLayer());
        this.memberTableModel.register();
        this.selectionTableModel = new SelectionTableModel(this.getLayer());
        this.selectionTableModel.register();
        this.referrerModel = new ReferringRelationsBrowserModel(relation);
        this.tagEditorPanel = new TagEditorPanel(new PresetListPanel.PresetHandler(){

            @Override
            public void updateTags(List<Tag> list) {
                GenericRelationEditor.this.updateTags(list);
            }

            @Override
            public Collection<OsmPrimitive> getSelection() {
                Relation relation = new Relation();
                GenericRelationEditor.this.tagEditorPanel.getModel().applyToPrimitive(relation);
                return Collections.singletonList(relation);
            }
        });
        if (relation != null) {
            this.tagEditorPanel.getModel().initFromPrimitive(relation);
            this.memberTableModel.populate(relation);
            if (!this.getLayer().data.getRelations().contains(relation)) {
                this.setRelation(null);
            }
        } else {
            this.tagEditorPanel.getModel().clear();
            this.memberTableModel.populate(null);
        }
        this.tagEditorPanel.getModel().ensureOneTag();
        JSplitPane jSplitPane = this.buildSplitPane();
        jSplitPane.setPreferredSize(new Dimension(100, 100));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jSplitPane, "Center");
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.getContentPane().setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(I18n.tr("Tags and Members"), jPanel);
        this.referrerBrowser = new ReferringRelationsBrowser(this.getLayer(), this.referrerModel, this);
        jTabbedPane.add(I18n.tr("Parent Relations"), this.referrerBrowser);
        jTabbedPane.add(I18n.tr("Child Relations"), new ChildRelationBrowser(this.getLayer(), relation));
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n;
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                String string = jTabbedPane.getTitleAt(n = jTabbedPane.getSelectedIndex());
                if (string.equals(I18n.tr("Parent Relations"))) {
                    GenericRelationEditor.this.referrerBrowser.init();
                }
            }
        });
        this.getContentPane().add((Component)this.buildToolBar(), "North");
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.getContentPane().add((Component)this.buildOkCancelButtonPanel(), "South");
        this.setSize(this.findMaxDialogSize());
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                GenericRelationEditor.this.cleanSelfReferences();
            }
        });
        this.memberTableModel.setSelectedMembers(collection);
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/RelationEditor"));
    }

    protected JToolBar buildToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(new ApplyAction());
        jToolBar.add(new DuplicateRelationAction());
        DeleteCurrentRelationAction deleteCurrentRelationAction = new DeleteCurrentRelationAction();
        this.addPropertyChangeListener(deleteCurrentRelationAction);
        jToolBar.add(deleteCurrentRelationAction);
        return jToolBar;
    }

    protected JPanel buildOkCancelButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(new SideButton(new OKAction()));
        jPanel.add(new SideButton(new CancelAction()));
        jPanel.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/RelationEditor"))));
        return jPanel;
    }

    protected JPanel buildTagEditorPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("Tags")), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.tagEditorPanel, gridBagConstraints);
        return jPanel;
    }

    protected JPanel buildMemberEditorPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.memberTable = new MemberTable(this.getLayer(), this.memberTableModel);
        this.memberTable.addMouseListener(new MemberTableDblClickAdapter());
        this.memberTableModel.addMemberModelListener(this.memberTable);
        JScrollPane jScrollPane = new JScrollPane(this.memberTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr("Members")), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.buildLeftButtonPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel(I18n.tr("Apply Role:")));
        this.tfRole = new AutoCompletingTextField(10);
        this.tfRole.setToolTipText(I18n.tr("Enter a role and apply it to the selected relation members"));
        this.tfRole.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                GenericRelationEditor.this.tfRole.selectAll();
            }
        });
        this.tfRole.setAutoCompletionList(new AutoCompletionList());
        this.tfRole.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                AutoCompletionList autoCompletionList = GenericRelationEditor.this.tfRole.getAutoCompletionList();
                autoCompletionList.clear();
                GenericRelationEditor.this.getLayer().data.getAutoCompletionManager().populateWithMemberRoles(autoCompletionList);
            }
        });
        this.tfRole.setText(Main.pref.get("relation.editor.generic.lastrole", ""));
        jPanel2.add(this.tfRole);
        SetRoleAction setRoleAction = new SetRoleAction();
        this.memberTableModel.getSelectionModel().addListSelectionListener(setRoleAction);
        this.tfRole.getDocument().addDocumentListener(setRoleAction);
        this.tfRole.addActionListener(setRoleAction);
        this.memberTableModel.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                GenericRelationEditor.this.tfRole.setEnabled(GenericRelationEditor.this.memberTable.getSelectedRowCount() > 0);
            }
        });
        this.tfRole.setEnabled(this.memberTable.getSelectedRowCount() > 0);
        SideButton sideButton = new SideButton(setRoleAction);
        sideButton.setPreferredSize(new Dimension(20, 20));
        sideButton.setText("");
        jPanel2.add(sideButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel3.add((Component)new JLabel(I18n.tr("Selection")), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)this.buildSelectionControlButtonPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel3.add((Component)this.buildSelectionTablePanel(), gridBagConstraints);
        final JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(jPanel);
        jSplitPane.setRightComponent(jPanel3);
        jSplitPane.setOneTouchExpandable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                jSplitPane.setDividerLocation(0.6);
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jSplitPane, "Center");
        new PasteMembersAction();
        new CopyMembersAction();
        new PasteTagsAction();
        return jPanel4;
    }

    protected JPanel buildSelectionTablePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.selectionTable = new SelectionTable(this.selectionTableModel, new SelectionTableColumnModel(this.memberTableModel));
        this.selectionTable.setMemberTableModel(this.memberTableModel);
        JScrollPane jScrollPane = new JScrollPane(this.selectionTable);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected JSplitPane buildSplitPane() {
        final JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent(this.buildTagEditorPanel());
        jSplitPane.setBottomComponent(this.buildMemberEditorPanel());
        jSplitPane.setOneTouchExpandable(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                jSplitPane.setDividerLocation(0.3);
            }
        });
        return jSplitPane;
    }

    protected JToolBar buildLeftButtonPanel() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOrientation(1);
        jToolBar.setFloatable(false);
        MoveUpAction moveUpAction = new MoveUpAction();
        this.memberTableModel.getSelectionModel().addListSelectionListener(moveUpAction);
        jToolBar.add(moveUpAction);
        MoveDownAction moveDownAction = new MoveDownAction();
        this.memberTableModel.getSelectionModel().addListSelectionListener(moveDownAction);
        jToolBar.add(moveDownAction);
        jToolBar.addSeparator();
        EditAction editAction = new EditAction();
        this.memberTableModel.getSelectionModel().addListSelectionListener(editAction);
        jToolBar.add(editAction);
        RemoveAction removeAction = new RemoveAction();
        this.memberTable.getSelectionModel().addListSelectionListener(removeAction);
        jToolBar.add(removeAction);
        jToolBar.addSeparator();
        SortAction sortAction = new SortAction();
        this.memberTableModel.addTableModelListener(sortAction);
        jToolBar.add(sortAction);
        ReverseAction reverseAction = new ReverseAction();
        this.memberTableModel.addTableModelListener(reverseAction);
        jToolBar.add(reverseAction);
        jToolBar.addSeparator();
        DownloadIncompleteMembersAction downloadIncompleteMembersAction = new DownloadIncompleteMembersAction();
        this.memberTable.getModel().addTableModelListener(downloadIncompleteMembersAction);
        jToolBar.add(downloadIncompleteMembersAction);
        DownloadSelectedIncompleteMembersAction downloadSelectedIncompleteMembersAction = new DownloadSelectedIncompleteMembersAction();
        this.memberTable.getModel().addTableModelListener(downloadSelectedIncompleteMembersAction);
        this.memberTable.getSelectionModel().addListSelectionListener(downloadSelectedIncompleteMembersAction);
        jToolBar.add(downloadSelectedIncompleteMembersAction);
        return jToolBar;
    }

    protected JToolBar buildSelectionControlButtonPanel() {
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        AddSelectedAtStartAction addSelectedAtStartAction = new AddSelectedAtStartAction();
        this.selectionTableModel.addTableModelListener(addSelectedAtStartAction);
        jToolBar.add(addSelectedAtStartAction);
        AddSelectedBeforeSelection addSelectedBeforeSelection = new AddSelectedBeforeSelection();
        this.selectionTableModel.addTableModelListener(addSelectedBeforeSelection);
        this.memberTableModel.getSelectionModel().addListSelectionListener(addSelectedBeforeSelection);
        jToolBar.add(addSelectedBeforeSelection);
        AddSelectedAfterSelection addSelectedAfterSelection = new AddSelectedAfterSelection();
        this.selectionTableModel.addTableModelListener(addSelectedAfterSelection);
        this.memberTableModel.getSelectionModel().addListSelectionListener(addSelectedAfterSelection);
        jToolBar.add(addSelectedAfterSelection);
        AddSelectedAtEndAction addSelectedAtEndAction = new AddSelectedAtEndAction();
        this.selectionTableModel.addTableModelListener(addSelectedAtEndAction);
        jToolBar.add(addSelectedAtEndAction);
        jToolBar.addSeparator();
        SelectedMembersForSelectionAction selectedMembersForSelectionAction = new SelectedMembersForSelectionAction();
        this.selectionTableModel.addTableModelListener(selectedMembersForSelectionAction);
        this.memberTableModel.addTableModelListener(selectedMembersForSelectionAction);
        jToolBar.add(selectedMembersForSelectionAction);
        SelectPrimitivesForSelectedMembersAction selectPrimitivesForSelectedMembersAction = new SelectPrimitivesForSelectedMembersAction();
        this.memberTable.getSelectionModel().addListSelectionListener(selectPrimitivesForSelectedMembersAction);
        jToolBar.add(selectPrimitivesForSelectedMembersAction);
        jToolBar.addSeparator();
        RemoveSelectedAction removeSelectedAction = new RemoveSelectedAction();
        this.selectionTableModel.addTableModelListener(removeSelectedAction);
        jToolBar.add(removeSelectedAction);
        return jToolBar;
    }

    @Override
    protected Dimension findMaxDialogSize() {
        return new Dimension(700, 650);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.tagEditorPanel.initAutoCompletion(this.getLayer());
        }
        super.setVisible(bl);
        if (bl) {
            RelationDialogManager.getRelationDialogManager().positionOnScreen(this);
        } else {
            this.selectionTableModel.unregister();
            this.memberTableModel.unregister();
            this.memberTable.unlinkAsListener();
            this.dispose();
        }
    }

    protected void cleanSelfReferences() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        arrayList.add(this.getRelation());
        if (this.memberTableModel.hasMembersReferringTo(arrayList)) {
            int n = ConditionalOptionPaneUtil.showOptionDialog("clean_relation_self_references", Main.parent, I18n.tr("<html>There is at least one member in this relation referring<br>to the relation itself.<br>This creates circular dependencies and is discouraged.<br>How do you want to proceed with circular dependencies?</html>"), I18n.tr("Warning"), 0, 2, new String[]{I18n.tr("Remove them, clean up relation"), I18n.tr("Ignore them, leave relation as is")}, I18n.tr("Remove them, clean up relation"));
            switch (n) {
                case -2147483648: {
                    return;
                }
                case -1: {
                    return;
                }
                case 1: {
                    return;
                }
                case 0: {
                    this.memberTableModel.removeMembersReferringTo(arrayList);
                }
            }
        }
    }

    private void registerCopyPasteAction(AbstractAction abstractAction, Object object, KeyStroke keyStroke) {
        this.getRootPane().getActionMap().put(object, abstractAction);
        this.getRootPane().getInputMap(2).put(keyStroke, object);
        this.memberTable.getInputMap(0).put(keyStroke, object);
        this.memberTable.getInputMap(1).put(keyStroke, object);
        this.memberTable.getInputMap(2).put(keyStroke, object);
        this.selectionTable.getInputMap(0).put(keyStroke, object);
        this.selectionTable.getInputMap(1).put(keyStroke, object);
        this.selectionTable.getInputMap(2).put(keyStroke, object);
    }

    protected void updateTags(List<Tag> list) {
        if (list.isEmpty()) {
            return;
        }
        HashMap<String, TagModel> hashMap = new HashMap<String, TagModel>();
        for (int i = 0; i < this.tagEditorPanel.getModel().getRowCount(); ++i) {
            TagModel object = this.tagEditorPanel.getModel().get(i);
            hashMap.put(object.getName(), object);
        }
        for (Tag tag : list) {
            TagModel tagModel = (TagModel)hashMap.get(tag.getKey());
            if (tag.getValue().isEmpty()) {
                if (tagModel == null) continue;
                this.tagEditorPanel.getModel().delete(tag.getKey());
                continue;
            }
            if (tagModel != null) {
                this.tagEditorPanel.getModel().updateTagValue(tagModel, tag.getValue());
                continue;
            }
            this.tagEditorPanel.getModel().add(tag.getKey(), tag.getValue());
        }
    }

    class MemberTableDblClickAdapter
    extends MouseAdapter {
        MemberTableDblClickAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                new EditAction().run();
            }
        }
    }

    class PasteTagsAction
    extends AbstractAction {
        public PasteTagsAction() {
            GenericRelationEditor.this.registerCopyPasteAction(this, "PASTE_TAGS", Shortcut.registerShortcut("system:pastestyle", I18n.tr("Edit: {0}", I18n.tr("Paste Tags")), 86, 2, 1).getKeyStroke());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Relation relation = new Relation();
            GenericRelationEditor.this.tagEditorPanel.getModel().applyToPrimitive(relation);
            PasteTagsAction.TagPaster tagPaster = new PasteTagsAction.TagPaster(Main.pasteBuffer.getDirectlyAdded(), Collections.singletonList(relation));
            GenericRelationEditor.this.updateTags(tagPaster.execute());
        }
    }

    class CopyMembersAction
    extends AbstractAction {
        public CopyMembersAction() {
            GenericRelationEditor.this.registerCopyPasteAction(this, "COPY_MEMBERS", Shortcut.getCopyKeyStroke());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (RelationMember relationMember : GenericRelationEditor.this.memberTableModel.getSelectedMembers()) {
                hashSet.add(relationMember.getMember());
            }
            if (!hashSet.isEmpty()) {
                CopyAction.copy(GenericRelationEditor.this.getLayer(), hashSet);
            }
        }
    }

    class PasteMembersAction
    extends AddFromSelectionAction {
        public PasteMembersAction() {
            GenericRelationEditor.this.registerCopyPasteAction(this, "PASTE_MEMBERS", Shortcut.getPasteKeyStroke());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                List<PrimitiveData> list = Main.pasteBuffer.getDirectlyAdded();
                DataSet dataSet = GenericRelationEditor.this.getLayer().data;
                List<OsmPrimitive> list2 = new ArrayList<OsmPrimitive>();
                boolean bl = false;
                for (PrimitiveData primitiveData : list) {
                    OsmPrimitive osmPrimitive = dataSet.getPrimitiveById(primitiveData);
                    if (osmPrimitive != null) {
                        list2.add(osmPrimitive);
                        continue;
                    }
                    if (!primitiveData.isNew()) {
                        OsmPrimitive osmPrimitive2 = primitiveData.getType().newInstance(primitiveData.getUniqueId(), true);
                        dataSet.addPrimitive(osmPrimitive2);
                        list2.add(osmPrimitive2);
                        continue;
                    }
                    bl = true;
                    break;
                }
                if (bl) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Members from paste buffer cannot be added because they are not included in current layer"));
                    return;
                }
                list2 = this.filterConfirmedPrimitives(list2);
                GenericRelationEditor.this.memberTableModel.addMembersAfterIdx(list2, GenericRelationEditor.this.memberTableModel.getSelectionModel().getMaxSelectionIndex());
                GenericRelationEditor.this.tfRole.requestFocusInWindow();
            }
            catch (AddAbortException addAbortException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EditAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditAction() {
            this.putValue("ShortDescription", I18n.tr("Edit the relation the currently selected relation member refers to"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.memberTable.getSelectedRowCount() == 1 && GenericRelationEditor.this.memberTableModel.isEditableRelation(GenericRelationEditor.this.memberTable.getSelectedRow()));
        }

        protected Collection<RelationMember> getMembersForCurrentSelection(Relation relation) {
            HashSet<RelationMember> hashSet = new HashSet<RelationMember>();
            Collection<OsmPrimitive> collection = GenericRelationEditor.this.getLayer().data.getSelected();
            for (RelationMember relationMember : relation.getMembers()) {
                if (!collection.contains(relationMember.getMember())) continue;
                hashSet.add(relationMember);
            }
            return hashSet;
        }

        public void run() {
            int n = GenericRelationEditor.this.memberTable.getSelectedRow();
            if (n < 0) {
                return;
            }
            OsmPrimitive osmPrimitive = GenericRelationEditor.this.memberTableModel.getReferredPrimitive(n);
            if (!(osmPrimitive instanceof Relation)) {
                return;
            }
            Relation relation = (Relation)osmPrimitive;
            if (relation.isIncomplete()) {
                return;
            }
            RelationEditor relationEditor = RelationEditor.getEditor(GenericRelationEditor.this.getLayer(), relation, this.getMembersForCurrentSelection(relation));
            relationEditor.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.run();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.refreshEnabled();
        }
    }

    class DuplicateRelationAction
    extends AbstractAction {
        public DuplicateRelationAction() {
            this.putValue("ShortDescription", I18n.tr("Create a copy of this relation and open it in another editor window"));
            this.putValue("SmallIcon", ImageProvider.get("duplicate"));
            this.putValue("Name", I18n.tr("Duplicate"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Relation relation = new Relation();
            GenericRelationEditor.this.tagEditorPanel.getModel().applyToPrimitive(relation);
            GenericRelationEditor.this.memberTableModel.applyToRelation(relation);
            RelationEditor relationEditor = RelationEditor.getEditor(GenericRelationEditor.this.getLayer(), relation, GenericRelationEditor.this.memberTableModel.getSelectedMembers());
            relationEditor.setVisible(true);
        }
    }

    class SetRoleAction
    extends AbstractAction
    implements ListSelectionListener,
    DocumentListener {
        public SetRoleAction() {
            this.putValue("ShortDescription", I18n.tr("Sets a role for the selected members"));
            this.putValue("SmallIcon", ImageProvider.get("apply"));
            this.putValue("Name", I18n.tr("Apply Role"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.memberTable.getSelectedRowCount() > 0);
        }

        protected boolean isEmptyRole() {
            return GenericRelationEditor.this.tfRole.getText() == null || GenericRelationEditor.this.tfRole.getText().trim().equals("");
        }

        protected boolean confirmSettingEmptyRole(int n) {
            String string = "<html>" + I18n.trn("You are setting an empty role on {0} primitive.", "You are setting an empty role on {0} primitives.", n, n) + "<br>" + I18n.tr("This is equal to deleting the roles of these primitives.") + "<br>" + I18n.tr("Do you really want to apply the new role?") + "</html>";
            Object[] objectArray = new String[]{I18n.tr("Yes, apply it"), I18n.tr("No, do not apply")};
            int n2 = ConditionalOptionPaneUtil.showOptionDialog("relation_editor.confirm_applying_empty_role", Main.parent, string, I18n.tr("Confirm empty role"), 0, 2, objectArray, objectArray[0]);
            switch (n2) {
                case 0: {
                    return true;
                }
                case -2147483648: {
                    return true;
                }
            }
            return false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isEmptyRole() && !this.confirmSettingEmptyRole(GenericRelationEditor.this.memberTable.getSelectedRowCount())) {
                return;
            }
            GenericRelationEditor.this.memberTableModel.updateRole(GenericRelationEditor.this.memberTable.getSelectedRows(), GenericRelationEditor.this.tfRole.getText());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.refreshEnabled();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.refreshEnabled();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.refreshEnabled();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.refreshEnabled();
        }
    }

    class DownloadSelectedIncompleteMembersAction
    extends AbstractAction
    implements ListSelectionListener,
    TableModelListener {
        public DownloadSelectedIncompleteMembersAction() {
            this.putValue("ShortDescription", I18n.tr("Download selected incomplete members"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "downloadincompleteselected"));
            this.putValue("Name", I18n.tr("Download Members"));
            Shortcut.registerShortcut("relationeditor:downloadincomplete", I18n.tr("Relation Editor: Download Members"), 75, 6);
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            Main.worker.submit(new DownloadRelationMemberTask(GenericRelationEditor.this.getRelation(), GenericRelationEditor.this.memberTableModel.getSelectedIncompleteMemberPrimitives(), GenericRelationEditor.this.getLayer(), GenericRelationEditor.this));
        }

        protected void updateEnabledState() {
            this.setEnabled(GenericRelationEditor.this.getRelation() != null && GenericRelationEditor.this.memberTableModel.hasIncompleteSelectedMembers());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.updateEnabledState();
        }
    }

    class DownloadIncompleteMembersAction
    extends AbstractAction
    implements TableModelListener {
        public DownloadIncompleteMembersAction() {
            this.putValue("ShortDescription", I18n.tr("Download all incomplete members"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "downloadincomplete"));
            this.putValue("Name", I18n.tr("Download Members"));
            Shortcut.registerShortcut("relationeditor:downloadincomplete", I18n.tr("Relation Editor: Download Members"), 75, 6);
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            Main.worker.submit(new DownloadRelationMemberTask(GenericRelationEditor.this.getRelation(), GenericRelationEditor.this.memberTableModel.getIncompleteMemberPrimitives(), GenericRelationEditor.this.getLayer(), GenericRelationEditor.this));
        }

        protected void updateEnabledState() {
            this.setEnabled(GenericRelationEditor.this.getRelation() != null && GenericRelationEditor.this.memberTableModel.hasIncompleteMembers());
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.updateEnabledState();
        }
    }

    class AddTagAction
    extends AbstractAction {
        public AddTagAction() {
            this.putValue("ShortDescription", I18n.tr("Add an empty tag"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.tagEditorPanel.getModel().appendNewTag();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel the updates and close the dialog"));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("Name", I18n.tr("Cancel"));
            GenericRelationEditor.this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
            GenericRelationEditor.this.getRootPane().getActionMap().put("ESCAPE", this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.setVisible(false);
        }
    }

    class OKAction
    extends SavingAction {
        public OKAction() {
            this.putValue("ShortDescription", I18n.tr("Apply the updates and close the dialog"));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.putValue("Name", I18n.tr("OK"));
            this.setEnabled(true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            Main.pref.put("relation.editor.generic.lastrole", GenericRelationEditor.this.tfRole.getText());
            if (GenericRelationEditor.this.getRelation() == null) {
                this.applyNewRelation();
            } else if (!GenericRelationEditor.this.memberTableModel.hasSameMembersAs(GenericRelationEditor.this.getRelationSnapshot()) || GenericRelationEditor.this.tagEditorPanel.getModel().isDirty()) {
                if (GenericRelationEditor.this.isDirtyRelation()) {
                    if (!this.confirmClosingBecauseOfDirtyState()) return;
                    if (GenericRelationEditor.this.getLayer().getConflicts().hasConflictForMy(GenericRelationEditor.this.getRelation())) {
                        this.warnDoubleConflict();
                        return;
                    }
                    this.applyExistingConflictingRelation();
                } else {
                    this.applyExistingNonConflictingRelation();
                }
            }
            GenericRelationEditor.this.setVisible(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }
    }

    class ApplyAction
    extends SavingAction {
        public ApplyAction() {
            this.putValue("ShortDescription", I18n.tr("Apply the current updates"));
            this.putValue("SmallIcon", ImageProvider.get("save"));
            this.putValue("Name", I18n.tr("Apply"));
            this.setEnabled(true);
        }

        public void run() {
            if (GenericRelationEditor.this.getRelation() == null) {
                this.applyNewRelation();
            } else if (!GenericRelationEditor.this.memberTableModel.hasSameMembersAs(GenericRelationEditor.this.getRelationSnapshot()) || GenericRelationEditor.this.tagEditorPanel.getModel().isDirty()) {
                if (GenericRelationEditor.this.isDirtyRelation()) {
                    if (this.confirmClosingBecauseOfDirtyState()) {
                        if (GenericRelationEditor.this.getLayer().getConflicts().hasConflictForMy(GenericRelationEditor.this.getRelation())) {
                            this.warnDoubleConflict();
                            return;
                        }
                        this.applyExistingConflictingRelation();
                        GenericRelationEditor.this.setVisible(false);
                    }
                } else {
                    this.applyExistingNonConflictingRelation();
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }
    }

    abstract class SavingAction
    extends AbstractAction {
        SavingAction() {
        }

        protected void applyNewRelation() {
            Relation relation = new Relation();
            GenericRelationEditor.this.tagEditorPanel.getModel().applyToPrimitive(relation);
            GenericRelationEditor.this.memberTableModel.applyToRelation(relation);
            ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
            for (RelationMember relationMember : relation.getMembers()) {
                if (relationMember.getMember().isDeleted()) continue;
                arrayList.add(relationMember);
            }
            if (relation.getMembersCount() != arrayList.size()) {
                relation.setMembers(arrayList);
                String string = I18n.tr("One or more members of this new relation have been deleted while the relation editor\nwas open. They have been removed from the relation members list.");
                JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Warning"), 2);
            }
            if (relation.getMembersCount() == 0 && !relation.hasKeys()) {
                return;
            }
            Main.main.undoRedo.add(new AddCommand(GenericRelationEditor.this.getLayer(), relation));
            GenericRelationEditor.this.getLayer().data.fireSelectionChanged();
            GenericRelationEditor.this.setRelation(relation);
            RelationDialogManager.getRelationDialogManager().updateContext(GenericRelationEditor.this.getLayer(), GenericRelationEditor.this.getRelation(), GenericRelationEditor.this);
        }

        protected void applyExistingConflictingRelation() {
            Relation relation = new Relation(GenericRelationEditor.this.getRelation());
            GenericRelationEditor.this.tagEditorPanel.getModel().applyToPrimitive(relation);
            GenericRelationEditor.this.memberTableModel.applyToRelation(relation);
            Conflict<Relation> conflict = new Conflict<Relation>(GenericRelationEditor.this.getRelation(), relation);
            Main.main.undoRedo.add(new ConflictAddCommand(GenericRelationEditor.this.getLayer(), conflict));
        }

        protected void applyExistingNonConflictingRelation() {
            Relation relation = new Relation(GenericRelationEditor.this.getRelation());
            GenericRelationEditor.this.tagEditorPanel.getModel().applyToPrimitive(relation);
            GenericRelationEditor.this.memberTableModel.applyToRelation(relation);
            Main.main.undoRedo.add(new ChangeCommand(GenericRelationEditor.this.getRelation(), relation));
            GenericRelationEditor.this.getLayer().data.fireSelectionChanged();
            GenericRelationEditor.this.setRelation(GenericRelationEditor.this.getRelation());
        }

        protected boolean confirmClosingBecauseOfDirtyState() {
            HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Yes, create a conflict and close"), ImageProvider.get("ok"), I18n.tr("Click to create a conflict and close this relation editor"), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("No, continue editing"), ImageProvider.get("cancel"), I18n.tr("Click to return to the relation editor and to resume relation editing"), null)};
            int n = HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>This relation has been changed outside of the editor.<br>You cannot apply your changes and continue editing.<br><br>Do you want to create a conflict and close the editor?</html>"), I18n.tr("Conflict in data"), 2, null, buttonSpecArray, buttonSpecArray[0], "/Dialog/RelationEditor#RelationChangedOutsideOfEditor");
            return n == 0;
        }

        protected void warnDoubleConflict() {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Layer ''{0}'' already has a conflict for primitive<br>''{1}''.<br>Please resolve this conflict first, then try again.</html>", GenericRelationEditor.this.getLayer().getName(), GenericRelationEditor.this.getRelation().getDisplayName(DefaultNameFormatter.getInstance())), I18n.tr("Double conflict"), 2);
        }
    }

    class DeleteCurrentRelationAction
    extends AbstractAction
    implements PropertyChangeListener {
        public DeleteCurrentRelationAction() {
            this.putValue("ShortDescription", I18n.tr("Delete the currently edited relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("Name", I18n.tr("Delete"));
            this.updateEnabledState();
        }

        public void run() {
            Relation relation = GenericRelationEditor.this.getRelation();
            if (relation == null) {
                return;
            }
            DeleteAction.deleteRelation(GenericRelationEditor.this.getLayer(), relation);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        protected void updateEnabledState() {
            this.setEnabled(GenericRelationEditor.this.getRelationSnapshot() != null);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(RelationEditor.RELATION_SNAPSHOT_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    class RemoveAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveAction() {
            this.putValue("ShortDescription", I18n.tr("Remove the currently selected members from this relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "remove"));
            Shortcut.registerShortcut("relationeditor:remove", I18n.tr("Relation Editor: Remove"), 74, 6);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.memberTableModel.remove(GenericRelationEditor.this.memberTable.getSelectedRows());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(GenericRelationEditor.this.memberTableModel.canRemove(GenericRelationEditor.this.memberTable.getSelectedRows()));
        }
    }

    class MoveDownAction
    extends AbstractAction
    implements ListSelectionListener {
        public MoveDownAction() {
            this.putValue("ShortDescription", I18n.tr("Move the currently selected members down"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "movedown"));
            Shortcut.registerShortcut("relationeditor:moveup", I18n.tr("Relation Editor: Move Down"), 74, 6);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.memberTableModel.moveDown(GenericRelationEditor.this.memberTable.getSelectedRows());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(GenericRelationEditor.this.memberTableModel.canMoveDown(GenericRelationEditor.this.memberTable.getSelectedRows()));
        }
    }

    class MoveUpAction
    extends AbstractAction
    implements ListSelectionListener {
        public MoveUpAction() {
            this.putValue("ShortDescription", I18n.tr("Move the currently selected members up"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "moveup"));
            Shortcut.registerShortcut("relationeditor:moveup", I18n.tr("Relation Editor: Move Up"), 78, 6);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.memberTableModel.moveUp(GenericRelationEditor.this.memberTable.getSelectedRows());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(GenericRelationEditor.this.memberTableModel.canMoveUp(GenericRelationEditor.this.memberTable.getSelectedRows()));
        }
    }

    class ReverseAction
    extends AbstractAction
    implements TableModelListener {
        public ReverseAction() {
            this.putValue("ShortDescription", I18n.tr("Reverse the order of the relation members"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "reverse"));
            this.putValue("Name", I18n.tr("Reverse"));
            Shortcut.registerShortcut("relationeditor:reverse", I18n.tr("Relation Editor: Reverse"), 82, 6);
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.memberTableModel.reverse();
        }

        protected void updateEnabledState() {
            this.setEnabled(GenericRelationEditor.this.memberTableModel.getRowCount() > 0);
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.updateEnabledState();
        }
    }

    class SortAction
    extends AbstractAction
    implements TableModelListener {
        public SortAction() {
            this.putValue("ShortDescription", I18n.tr("Sort the relation members"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "sort"));
            this.putValue("Name", I18n.tr("Sort"));
            Shortcut.registerShortcut("relationeditor:sort", I18n.tr("Relation Editor: Sort"), 84, 6);
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.memberTableModel.sort();
        }

        protected void updateEnabledState() {
            this.setEnabled(GenericRelationEditor.this.memberTableModel.getRowCount() > 0);
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.updateEnabledState();
        }
    }

    class SelectPrimitivesForSelectedMembersAction
    extends AbstractAction
    implements ListSelectionListener {
        public SelectPrimitivesForSelectedMembersAction() {
            this.putValue("ShortDescription", I18n.tr("Select primitives for selected relation members"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "selectprimitives"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(GenericRelationEditor.this.memberTable.getSelectedRowCount() > 0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.getLayer().data.setSelected(GenericRelationEditor.this.memberTableModel.getSelectedChildPrimitives());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class SelectedMembersForSelectionAction
    extends AbstractAction
    implements TableModelListener {
        public SelectedMembersForSelectionAction() {
            this.putValue("ShortDescription", I18n.tr("Select relation members which refer to primitives in the current selection"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "selectmembers"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            boolean bl;
            boolean bl2 = bl = GenericRelationEditor.this.selectionTableModel.getRowCount() > 0 && !GenericRelationEditor.this.memberTableModel.getChildPrimitives(GenericRelationEditor.this.getLayer().data.getSelected()).isEmpty();
            if (bl) {
                this.putValue("ShortDescription", I18n.tr("Select relation members which refer to {0} primitives in the current selection", GenericRelationEditor.this.memberTableModel.getChildPrimitives(GenericRelationEditor.this.getLayer().data.getSelected()).size()));
            } else {
                this.putValue("ShortDescription", I18n.tr("Select relation members which refer to primitives in the current selection"));
            }
            this.setEnabled(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.memberTableModel.selectMembersReferringTo(GenericRelationEditor.this.getLayer().data.getSelected());
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.updateEnabledState();
        }
    }

    class RemoveSelectedAction
    extends AbstractAction
    implements TableModelListener {
        public RemoveSelectedAction() {
            this.putValue("ShortDescription", I18n.tr("Remove all members referring to one of the selected primitives"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "deletemembers"));
            Shortcut.registerShortcut("relationeditor:removeselected", I18n.tr("Relation Editor: Remove Selected"), 83, 6);
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            DataSet dataSet = GenericRelationEditor.this.getLayer().data;
            if (dataSet == null || dataSet.getSelected().isEmpty()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(GenericRelationEditor.this.memberTableModel.hasMembersReferringTo(dataSet.getSelected()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GenericRelationEditor.this.memberTableModel.removeMembersReferringTo(GenericRelationEditor.this.selectionTableModel.getSelection());
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.updateEnabledState();
        }
    }

    class AddSelectedAfterSelection
    extends AddFromSelectionAction
    implements TableModelListener,
    ListSelectionListener {
        public AddSelectedAfterSelection() {
            this.putValue("ShortDescription", I18n.tr("Add all primitives selected in the current dataset after the last selected member"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "copyaftercurrentright"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.selectionTableModel.getRowCount() > 0 && GenericRelationEditor.this.memberTableModel.getSelectionModel().getMinSelectionIndex() >= 0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                List<OsmPrimitive> list = this.filterConfirmedPrimitives(GenericRelationEditor.this.selectionTableModel.getSelection());
                GenericRelationEditor.this.memberTableModel.addMembersAfterIdx(list, GenericRelationEditor.this.memberTableModel.getSelectionModel().getMaxSelectionIndex());
            }
            catch (AddAbortException addAbortException) {
                // empty catch block
            }
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.refreshEnabled();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.refreshEnabled();
        }
    }

    class AddSelectedBeforeSelection
    extends AddFromSelectionAction
    implements TableModelListener,
    ListSelectionListener {
        public AddSelectedBeforeSelection() {
            this.putValue("ShortDescription", I18n.tr("Add all primitives selected in the current dataset before the first selected member"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "copybeforecurrentright"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.selectionTableModel.getRowCount() > 0 && GenericRelationEditor.this.memberTableModel.getSelectionModel().getMinSelectionIndex() >= 0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                List<OsmPrimitive> list = this.filterConfirmedPrimitives(GenericRelationEditor.this.selectionTableModel.getSelection());
                GenericRelationEditor.this.memberTableModel.addMembersBeforeIdx(list, GenericRelationEditor.this.memberTableModel.getSelectionModel().getMinSelectionIndex());
            }
            catch (AddAbortException addAbortException) {
                // empty catch block
            }
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.refreshEnabled();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.refreshEnabled();
        }
    }

    class AddSelectedAtEndAction
    extends AddFromSelectionAction
    implements TableModelListener {
        public AddSelectedAtEndAction() {
            this.putValue("ShortDescription", I18n.tr("Add all primitives selected in the current dataset after the last member"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "copyendright"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.selectionTableModel.getRowCount() > 0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                List<OsmPrimitive> list = this.filterConfirmedPrimitives(GenericRelationEditor.this.selectionTableModel.getSelection());
                GenericRelationEditor.this.memberTableModel.addMembersAtEnd(list);
            }
            catch (AddAbortException addAbortException) {
                // empty catch block
            }
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.refreshEnabled();
        }
    }

    class AddSelectedAtStartAction
    extends AddFromSelectionAction
    implements TableModelListener {
        public AddSelectedAtStartAction() {
            this.putValue("ShortDescription", I18n.tr("Add all primitives selected in the current dataset before the first member"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "copystartright"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.selectionTableModel.getRowCount() > 0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                List<OsmPrimitive> list = this.filterConfirmedPrimitives(GenericRelationEditor.this.selectionTableModel.getSelection());
                GenericRelationEditor.this.memberTableModel.addMembersAtBeginning(list);
            }
            catch (AddAbortException addAbortException) {
                // empty catch block
            }
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.refreshEnabled();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AddFromSelectionAction
    extends AbstractAction {
        AddFromSelectionAction() {
        }

        protected boolean isPotentialDuplicate(OsmPrimitive osmPrimitive) {
            return GenericRelationEditor.this.memberTableModel.hasMembersReferringTo(Collections.singleton(osmPrimitive));
        }

        protected boolean confirmAddingPrimtive(OsmPrimitive osmPrimitive) throws AddAbortException {
            String string = I18n.tr("<html>This relation already has one or more members referring to<br>the primitive ''{0}''<br><br>Do you really want to add another relation member?</html>", osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
            int n = ConditionalOptionPaneUtil.showOptionDialog("add_primitive_to_relation", Main.parent, string, I18n.tr("Multiple members referring to same primitive"), 1, 2, null, null);
            switch (n) {
                case -2147483648: {
                    return true;
                }
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case -1: {
                    return false;
                }
                case 2: {
                    throw new AddAbortException();
                }
            }
            return false;
        }

        protected void warnOfCircularReferences(OsmPrimitive osmPrimitive) {
            String string = I18n.tr("<html>You are trying to add a relation to itself.<br><br>This creates circular references and is therefore discouraged.<br>Skipping relation ''{0}''.</html>", osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
            JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Warning"), 2);
        }

        protected List<OsmPrimitive> filterConfirmedPrimitives(List<OsmPrimitive> list) throws AddAbortException {
            if (list == null || list.isEmpty()) {
                return list;
            }
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
            for (OsmPrimitive osmPrimitive : list) {
                if (osmPrimitive instanceof Relation && GenericRelationEditor.this.getRelation() != null && GenericRelationEditor.this.getRelation().equals(osmPrimitive)) {
                    this.warnOfCircularReferences(osmPrimitive);
                    continue;
                }
                if (this.isPotentialDuplicate(osmPrimitive)) {
                    if (!this.confirmAddingPrimtive(osmPrimitive)) continue;
                    arrayList.add(osmPrimitive);
                    continue;
                }
                arrayList.add(osmPrimitive);
            }
            return arrayList;
        }
    }

    static class AddAbortException
    extends Exception {
        AddAbortException() {
        }
    }
}

