/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.nodes;

import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.WayNodesConflictResolverCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.pair.ListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeListMergeModel
extends ListMergeModel<Node> {
    private DataSet myDataset;

    public void populate(Way way, Way way2) {
        this.myDataset = way.getDataSet();
        CheckParameterUtil.ensureParameterNotNull(way, "my");
        CheckParameterUtil.ensureParameterNotNull(way2, "their");
        this.getMergedEntries().clear();
        this.getMyEntries().clear();
        this.getTheirEntries().clear();
        for (Node node : way.getNodes()) {
            this.getMyEntries().add(node);
        }
        for (Node node : way2.getNodes()) {
            this.getTheirEntries().add(node);
        }
        if (this.myAndTheirEntriesEqual()) {
            this.entries.put(ListRole.MERGED_ENTRIES, new ArrayList(this.getMyEntries()));
            this.setFrozen(true);
        } else {
            this.setFrozen(false);
        }
        this.fireModelDataChanged();
    }

    public WayNodesConflictResolverCommand buildResolveCommand(Conflict<? extends OsmPrimitive> conflict) {
        if (!this.isFrozen()) {
            throw new IllegalArgumentException(I18n.tr("Merged nodes not frozen yet. Cannot build resolution command."));
        }
        return new WayNodesConflictResolverCommand(conflict, this.getMergedEntries());
    }

    @Override
    public boolean isEqualEntry(Node node, Node node2) {
        if (!node.isNew()) {
            return node.getId() == node2.getId();
        }
        return node == node2;
    }

    @Override
    protected void setValueAt(DefaultTableModel defaultTableModel, Object object, int n, int n2) {
    }

    @Override
    protected Node cloneEntryForMergedList(Node node) {
        return (Node)this.getMyPrimitive(node);
    }

    @Override
    protected OsmPrimitive getMyPrimitive(Node node) {
        return this.myDataset.getPrimitiveById(node);
    }
}

