/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Color;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;

public class MapPaintSettings
implements Preferences.PreferenceChangedListener {
    public static final MapPaintSettings INSTANCE = new MapPaintSettings();
    private boolean useRealWidth;
    private boolean showDirectionArrow;
    private boolean showRelevantDirectionsOnly;
    private int defaultSegmentWidth;
    private boolean showOrderNumber;
    private boolean showHeadArrowOnly;
    private int showNamesDistance;
    private int useStrokesDistance;
    private int showIconsDistance;
    private int selectedNodeSize;
    private int connectionNodeSize;
    private int unselectedNodeSize;
    private int taggedNodeSize;
    private boolean fillSelectedNode;
    private boolean fillUnselectedNode;
    private boolean fillTaggedNode;
    private boolean fillConnectionNode;
    private boolean outlineOnly;
    private Color selectedColor;
    private Color relationSelectedColor;
    private Color highlightColor;
    private Color inactiveColor;
    private Color nodeColor;
    private Color taggedColor;
    private Color connectionColor;
    private Color taggedConnectionColor;

    private MapPaintSettings() {
        this.load();
        Main.pref.addPreferenceChangeListener(this);
    }

    private void load() {
        this.showDirectionArrow = Main.pref.getBoolean("draw.segment.direction", true);
        this.showRelevantDirectionsOnly = Main.pref.getBoolean("draw.segment.relevant_directions_only", true);
        this.useRealWidth = Main.pref.getBoolean("mappaint.useRealWidth", false);
        this.defaultSegmentWidth = Main.pref.getInteger("mappaint.segment.default-width", 2);
        this.selectedColor = PaintColors.SELECTED.get();
        this.relationSelectedColor = PaintColors.RELATIONSELECTED.get();
        this.highlightColor = PaintColors.HIGHLIGHT.get();
        this.inactiveColor = PaintColors.INACTIVE.get();
        this.nodeColor = PaintColors.NODE.get();
        this.taggedColor = PaintColors.TAGGED.get();
        this.connectionColor = PaintColors.CONNECTION.get();
        this.taggedConnectionColor = this.taggedColor != this.nodeColor ? this.taggedColor : this.connectionColor;
        this.showOrderNumber = Main.pref.getBoolean("draw.segment.order_number", false);
        this.showHeadArrowOnly = Main.pref.getBoolean("draw.segment.head_only", false);
        this.showNamesDistance = Main.pref.getInteger("mappaint.shownames", 10000000);
        this.useStrokesDistance = Main.pref.getInteger("mappaint.strokes", 10000000);
        this.showIconsDistance = Main.pref.getInteger("mappaint.showicons", 10000000);
        this.selectedNodeSize = Main.pref.getInteger("mappaint.node.selected-size", 5);
        this.unselectedNodeSize = Main.pref.getInteger("mappaint.node.unselected-size", 3);
        this.connectionNodeSize = Main.pref.getInteger("mappaint.node.connection-size", 5);
        this.taggedNodeSize = Main.pref.getInteger("mappaint.node.tagged-size", 3);
        this.fillSelectedNode = Main.pref.getBoolean("mappaint.node.fill-selected", true);
        this.fillUnselectedNode = Main.pref.getBoolean("mappaint.node.fill-unselected", false);
        this.fillTaggedNode = Main.pref.getBoolean("mappaint.node.fill-tagged", true);
        this.fillConnectionNode = Main.pref.getBoolean("mappaint.node.fill-connection", false);
        this.outlineOnly = Main.pref.getBoolean("draw.data.area_outline_only", false);
    }

    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        this.load();
    }

    public boolean isUseRealWidth() {
        return this.useRealWidth;
    }

    public boolean isShowDirectionArrow() {
        return this.showDirectionArrow;
    }

    public boolean isShowRelevantDirectionsOnly() {
        return this.showRelevantDirectionsOnly;
    }

    public int getDefaultSegmentWidth() {
        return this.defaultSegmentWidth;
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public Color getRelationSelectedColor() {
        return this.relationSelectedColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public Color getInactiveColor() {
        return this.inactiveColor;
    }

    public Color getNodeColor() {
        return this.nodeColor;
    }

    public Color getTaggedColor() {
        return this.taggedColor;
    }

    public Color getConnectionColor() {
        return this.connectionColor;
    }

    public Color getTaggedConnectionColor() {
        return this.taggedConnectionColor;
    }

    public boolean isShowOrderNumber() {
        return this.showOrderNumber;
    }

    public void setShowHeadArrowOnly(boolean bl) {
        this.showHeadArrowOnly = bl;
    }

    public boolean isShowHeadArrowOnly() {
        return this.showHeadArrowOnly;
    }

    public int getShowNamesDistance() {
        return this.showNamesDistance;
    }

    public int getUseStrokesDistance() {
        return this.useStrokesDistance;
    }

    public int getShowIconsDistance() {
        return this.showIconsDistance;
    }

    public int getSelectedNodeSize() {
        return this.selectedNodeSize;
    }

    public int getConnectionNodeSize() {
        return this.connectionNodeSize;
    }

    public int getUnselectedNodeSize() {
        return this.unselectedNodeSize;
    }

    public int getTaggedNodeSize() {
        return this.taggedNodeSize;
    }

    public boolean isFillSelectedNode() {
        return this.fillSelectedNode;
    }

    public boolean isFillUnselectedNode() {
        return this.fillUnselectedNode;
    }

    public boolean isFillConnectionNode() {
        return this.fillConnectionNode;
    }

    public boolean isFillTaggedNode() {
        return this.fillTaggedNode;
    }

    public boolean isOutlineOnly() {
        return this.outlineOnly;
    }
}

