/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPrimitivesCommand
extends Command {
    private final List<PrimitiveData> data = new ArrayList<PrimitiveData>();

    public AddPrimitivesCommand(List<PrimitiveData> list) {
        this.data.addAll(list);
    }

    public AddPrimitivesCommand(List<PrimitiveData> list, OsmDataLayer osmDataLayer) {
        super(osmDataLayer);
        this.data.addAll(list);
    }

    @Override
    public boolean executeCommand() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(this.data.size());
        for (PrimitiveData primitiveData : this.data) {
            boolean bl;
            OsmPrimitive osmPrimitive = this.getLayer().data.getPrimitiveById(primitiveData);
            boolean bl2 = bl = osmPrimitive == null;
            if (bl) {
                osmPrimitive = primitiveData.getType().newInstance(primitiveData.getUniqueId(), true);
            }
            if (primitiveData instanceof NodeData) {
                osmPrimitive.load(primitiveData);
            }
            if (bl) {
                this.getLayer().data.addPrimitive(osmPrimitive);
            }
            arrayList.add(osmPrimitive);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) instanceof Node) continue;
            ((OsmPrimitive)arrayList.get(i)).load(this.data.get(i));
        }
        this.getLayer().data.setSelected(arrayList);
        return true;
    }

    @Override
    public void undoCommand() {
        for (PrimitiveData primitiveData : this.data) {
            this.getLayer().data.removePrimitive(primitiveData);
        }
    }

    @Override
    public JLabel getDescription() {
        return new JLabel(I18n.trn("Added {0} object", "Added {0} objects", this.data.size(), this.data.size()), null, 0);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (PrimitiveData primitiveData : this.data) {
            OsmPrimitive osmPrimitive = this.getLayer().data.getPrimitiveById(primitiveData);
            if (osmPrimitive == null) {
                throw new RuntimeException();
            }
            hashSet.add(osmPrimitive);
        }
        return hashSet;
    }
}

