/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class OsmApiException
extends OsmTransferException {
    private int responseCode;
    private String errorHeader;
    private String errorBody;
    private String accessedUrl;

    public OsmApiException() {
    }

    public OsmApiException(int n, String string, String string2) {
        this.responseCode = n;
        this.errorHeader = string;
        this.errorBody = string2;
    }

    public OsmApiException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public OsmApiException(String string) {
        super(string);
    }

    public OsmApiException(Throwable throwable) {
        super(throwable);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int n) {
        this.responseCode = n;
    }

    public String getErrorHeader() {
        return this.errorHeader;
    }

    public void setErrorHeader(String string) {
        this.errorHeader = string;
    }

    public String getErrorBody() {
        return this.errorBody;
    }

    public void setErrorBody(String string) {
        this.errorBody = string;
    }

    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ResponseCode=").append(this.responseCode);
        String string = "";
        try {
            if (this.errorHeader != null) {
                string = I18n.tr(this.errorHeader.trim());
            }
            if (!string.isEmpty()) {
                stringBuilder.append(", Error Header=<").append(string).append(">");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string2;
            String string3 = string2 = this.errorBody != null ? I18n.tr(this.errorBody.trim()) : "";
            if (!string2.isEmpty() && !string2.equals(string)) {
                stringBuilder.append(", Error Body=<").append(string2).append(">");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public String getDisplayMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.errorHeader != null) {
            stringBuilder.append(I18n.tr(this.errorHeader));
            stringBuilder.append(I18n.tr("(Code={0})", this.responseCode));
        } else if (this.errorBody != null && !this.errorBody.trim().equals("")) {
            this.errorBody = this.errorBody.trim();
            stringBuilder.append(I18n.tr(this.errorBody));
            stringBuilder.append(I18n.tr("(Code={0})", this.responseCode));
        } else {
            stringBuilder.append(I18n.tr("The server replied an error with code {0}.", this.responseCode));
        }
        return stringBuilder.toString();
    }

    public void setAccessedUrl(String string) {
        this.accessedUrl = string;
    }

    public String getAccessedUrl() {
        return this.accessedUrl;
    }
}

