/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmDataParsingException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffResultProcessor {
    private Map<PrimitiveId, DiffResultEntry> diffResults = new HashMap<PrimitiveId, DiffResultEntry>();
    private Set<OsmPrimitive> processed;
    private Collection<OsmPrimitive> primitives;

    public DiffResultProcessor(Collection<OsmPrimitive> collection) {
        if (collection == null) {
            collection = Collections.emptyList();
        }
        this.primitives = collection;
        this.processed = new HashSet<OsmPrimitive>();
    }

    public void parse(String string, ProgressMonitor progressMonitor) throws OsmDataParsingException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        CheckParameterUtil.ensureParameterNotNull(string, "diffUploadResponse");
        try {
            progressMonitor.beginTask(I18n.tr("Parsing response from server..."));
            InputSource inputSource = new InputSource(new StringReader(string));
            SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)new Parser());
        }
        catch (IOException iOException) {
            throw new OsmDataParsingException(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new OsmDataParsingException(parserConfigurationException);
        }
        catch (OsmDataParsingException osmDataParsingException) {
            throw osmDataParsingException;
        }
        catch (SAXException sAXException) {
            throw new OsmDataParsingException(sAXException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<OsmPrimitive> postProcess(Changeset changeset, ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask("Postprocessing uploaded data ...");
            progressMonitor.setTicksCount(this.primitives.size());
            progressMonitor.setTicks(0);
            for (OsmPrimitive osmPrimitive : this.primitives) {
                progressMonitor.worked(1);
                DiffResultEntry diffResultEntry = this.diffResults.get(osmPrimitive.getPrimitiveId());
                if (diffResultEntry == null) continue;
                this.processed.add(osmPrimitive);
                if (!osmPrimitive.isDeleted()) {
                    osmPrimitive.setOsmId(diffResultEntry.new_id, diffResultEntry.new_version);
                    osmPrimitive.setVisible(true);
                } else {
                    osmPrimitive.setVisible(false);
                }
                if (changeset == null || changeset.isNew()) continue;
                osmPrimitive.setChangesetId(changeset.getId());
            }
            Set<OsmPrimitive> set = this.processed;
            return set;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private class Parser
    extends DefaultHandler {
        private Locator locator;

        private Parser() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(String string) throws OsmDataParsingException {
            throw new OsmDataParsingException(string).rememberLocation(this.locator);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (!string3.equals("diffResult")) {
                    if (string3.equals("node") || string3.equals("way") || string3.equals("relation")) {
                        SimplePrimitiveId simplePrimitiveId = new SimplePrimitiveId(Long.parseLong(attributes.getValue("old_id")), OsmPrimitiveType.fromApiTypeName(string3));
                        DiffResultEntry diffResultEntry = new DiffResultEntry();
                        if (attributes.getValue("new_id") != null) {
                            diffResultEntry.new_id = Long.parseLong(attributes.getValue("new_id"));
                        }
                        if (attributes.getValue("new_version") != null) {
                            diffResultEntry.new_version = Integer.parseInt(attributes.getValue("new_version"));
                        }
                        DiffResultProcessor.this.diffResults.put(simplePrimitiveId, diffResultEntry);
                    } else {
                        this.throwException(I18n.tr("Unexpected XML element with name ''{0}''", string3));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new OsmDataParsingException(numberFormatException).rememberLocation(this.locator);
            }
        }
    }

    private static class DiffResultEntry {
        public long new_id;
        public int new_version;

        private DiffResultEntry() {
        }
    }
}

