/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import org.openstreetmap.josm.data.coor.EastNorth;

public class ProjectionBounds {
    public EastNorth min;
    public EastNorth max;

    public ProjectionBounds(EastNorth eastNorth, EastNorth eastNorth2) {
        this.min = eastNorth;
        this.max = eastNorth2;
    }

    public ProjectionBounds(EastNorth eastNorth) {
        this.min = eastNorth;
        this.max = eastNorth;
    }

    public ProjectionBounds(EastNorth eastNorth, double d, double d2) {
        this.min = new EastNorth(eastNorth.east() - d / 2.0, eastNorth.north() - d2 / 2.0);
        this.max = new EastNorth(eastNorth.east() + d / 2.0, eastNorth.north() + d2 / 2.0);
    }

    public void extend(EastNorth eastNorth) {
        if (eastNorth.east() < this.min.east() || eastNorth.north() < this.min.north()) {
            this.min = new EastNorth(Math.min(eastNorth.east(), this.min.east()), Math.min(eastNorth.north(), this.min.north()));
        }
        if (eastNorth.east() > this.max.east() || eastNorth.north() > this.max.north()) {
            this.max = new EastNorth(Math.max(eastNorth.east(), this.max.east()), Math.max(eastNorth.north(), this.max.north()));
        }
    }

    public EastNorth getCenter() {
        return this.min.getCenter(this.max);
    }

    public String toString() {
        return "ProjectionBounds[" + this.min.east() + "," + this.min.north() + "," + this.max.east() + "," + this.max.north() + "]";
    }
}

