/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class WireframeToggleAction
extends JosmAction {
    private final List<ButtonModel> buttonModels = new ArrayList<ButtonModel>();
    private boolean selected = Main.pref.getBoolean("draw.wireframe", false);

    public WireframeToggleAction() {
        super(I18n.tr("Wireframe View"), null, I18n.tr("Enable/disable rendering the map as wireframe only"), Shortcut.registerShortcut("menu:view:wireframe", I18n.tr("Toggle Wireframe view"), 87, 2), true);
        this.notifySelectedState();
    }

    public void addButtonModel(ButtonModel buttonModel) {
        if (buttonModel != null && !this.buttonModels.contains(buttonModel)) {
            this.buttonModels.add(buttonModel);
            buttonModel.setSelected(this.selected);
        }
    }

    public void removeButtonModel(ButtonModel buttonModel) {
        if (buttonModel != null && this.buttonModels.contains(buttonModel)) {
            this.buttonModels.remove(buttonModel);
        }
    }

    protected void notifySelectedState() {
        for (ButtonModel buttonModel : this.buttonModels) {
            if (buttonModel.isSelected() == this.selected) continue;
            buttonModel.setSelected(this.selected);
        }
    }

    protected void toggleSelectedState() {
        this.selected = !this.selected;
        Main.pref.put("draw.wireframe", this.selected);
        this.notifySelectedState();
        if (Main.map != null) {
            Main.map.mapView.repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.toggleSelectedState();
    }

    protected void updateEnabledState() {
        this.setEnabled(Main.map != null && Main.main.getEditLayer() != null);
    }
}

