/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadReferrersTask;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadReferrersAction
extends JosmAction {
    public DownloadReferrersAction() {
        super(I18n.tr("Download parent ways/relations..."), "downloadreferrers", I18n.tr("Download primitives referring to one of the selected primitives"), Shortcut.registerShortcut("file:downloadreferrers", I18n.tr("File: {0}", I18n.tr("Download parent ways/relations...")), 68, 15), true);
        this.putValue("help", HelpUtil.ht("/Action/Downloadreferrers"));
    }

    public static void downloadReferrers(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection) throws IllegalArgumentException {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Main.worker.submit(new DownloadReferrersTask(osmDataLayer, collection));
    }

    public static void downloadReferrers(OsmDataLayer osmDataLayer, Map<Long, OsmPrimitiveType> map) throws IllegalArgumentException {
        if (map == null || map.isEmpty()) {
            return;
        }
        Main.worker.submit(new DownloadReferrersTask(osmDataLayer, map));
    }

    public static void downloadReferrers(OsmDataLayer osmDataLayer, long l, OsmPrimitiveType osmPrimitiveType) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Id > 0 required, got {0}", l));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        Main.worker.submit(new DownloadReferrersTask(osmDataLayer, l, osmPrimitiveType));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled() || !Main.isDisplayingMapView()) {
            return;
        }
        OsmDataLayer osmDataLayer = Main.map.mapView.getEditLayer();
        if (osmDataLayer == null) {
            return;
        }
        Collection<OsmPrimitive> collection = osmDataLayer.data.getSelected();
        DownloadReferrersAction.downloadReferrers(osmDataLayer, collection);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }
}

