/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlObjectParser
implements Iterable<Object> {
    public static final String lang = LanguageInfo.getLanguageCodeXML();
    private Map<String, Entry> mapping = new HashMap<String, Entry>();
    private Parser parser;
    private BlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(10);
    private Object lookAhead = null;
    private Object EOS = new Object();

    public XmlObjectParser() {
        this.parser = new Parser();
    }

    private Iterable<Object> start(final Reader reader, final ContentHandler contentHandler) {
        new Thread("XML Reader"){

            public void run() {
                try {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    XMLReader xMLReader = sAXParser.getXMLReader();
                    xMLReader.setContentHandler(contentHandler);
                    xMLReader.parse(new InputSource(reader));
                }
                catch (Exception exception) {
                    try {
                        XmlObjectParser.this.queue.put(exception);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    XmlObjectParser.this.queue.put(XmlObjectParser.this.EOS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
        return this;
    }

    public Iterable<Object> start(Reader reader) {
        return this.start(reader, this.parser);
    }

    public Iterable<Object> startWithValidation(Reader reader, String string, Source source) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(source);
        ValidatorHandler validatorHandler = schema.newValidatorHandler();
        validatorHandler.setContentHandler(this.parser);
        validatorHandler.setErrorHandler(this.parser);
        AddNamespaceFilter addNamespaceFilter = new AddNamespaceFilter(string);
        addNamespaceFilter.setContentHandler(validatorHandler);
        return this.start(reader, addNamespaceFilter);
    }

    public void map(String string, Class<?> clazz) {
        this.mapping.put(string, new Entry(clazz, false, false));
    }

    public void mapOnStart(String string, Class<?> clazz) {
        this.mapping.put(string, new Entry(clazz, true, false));
    }

    public void mapBoth(String string, Class<?> clazz) {
        this.mapping.put(string, new Entry(clazz, false, true));
    }

    public Object next() throws SAXException {
        this.fillLookAhead();
        if (this.lookAhead == this.EOS) {
            throw new NoSuchElementException();
        }
        Object object = this.lookAhead;
        this.lookAhead = null;
        return object;
    }

    private void fillLookAhead() throws SAXException {
        if (this.lookAhead != null) {
            return;
        }
        try {
            this.lookAhead = this.queue.take();
            if (this.lookAhead instanceof SAXException) {
                throw (SAXException)this.lookAhead;
            }
            if (this.lookAhead instanceof RuntimeException) {
                throw (RuntimeException)this.lookAhead;
            }
            if (this.lookAhead instanceof Exception) {
                throw new SAXException((Exception)this.lookAhead);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("XmlObjectParser must not be interrupted.", interruptedException);
        }
    }

    public boolean hasNext() throws SAXException {
        this.fillLookAhead();
        return this.lookAhead != this.EOS;
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                try {
                    return XmlObjectParser.this.hasNext();
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                    throw new RuntimeException(sAXException);
                }
            }

            @Override
            public Object next() {
                try {
                    return XmlObjectParser.this.next();
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                    throw new RuntimeException(sAXException);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        Class<?> klass;
        boolean onStart;
        boolean both;

        public Entry(Class<?> clazz, boolean bl, boolean bl2) {
            this.klass = clazz;
            this.onStart = bl;
            this.both = bl2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Parser
    extends DefaultHandler {
        Stack<Object> current = new Stack();
        String characters = "";
        private Locator locator;

        private Parser() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(Exception exception) throws PresetParsingException {
            throw new PresetParsingException(exception).rememberLocation(this.locator);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (XmlObjectParser.this.mapping.containsKey(string3)) {
                Class<?> clazz = ((Entry)((XmlObjectParser)XmlObjectParser.this).mapping.get((Object)string3)).klass;
                try {
                    this.current.push(clazz.newInstance());
                }
                catch (Exception exception) {
                    this.throwException(exception);
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.setValue(attributes.getQName(i), attributes.getValue(i));
                }
                if (((Entry)((XmlObjectParser)XmlObjectParser.this).mapping.get((Object)string3)).onStart) {
                    this.report();
                }
                if (((Entry)((XmlObjectParser)XmlObjectParser.this).mapping.get((Object)string3)).both) {
                    try {
                        XmlObjectParser.this.queue.put(this.current.peek());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (XmlObjectParser.this.mapping.containsKey(string3) && !((Entry)((XmlObjectParser)XmlObjectParser.this).mapping.get((Object)string3)).onStart) {
                this.report();
            } else if (this.characters != null && !this.current.isEmpty()) {
                this.setValue(string3, this.characters.trim());
                this.characters = "";
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            String string = new String(cArray, n, n2);
            this.characters = this.characters + string;
        }

        private void report() {
            try {
                XmlObjectParser.this.queue.put(this.current.pop());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.characters = "";
        }

        private Object getValueForClass(Class<?> clazz, String string) {
            if (clazz == Boolean.TYPE) {
                return this.parseBoolean(string);
            }
            if (clazz == Integer.TYPE || clazz == Long.TYPE) {
                return Long.parseLong(string);
            }
            if (clazz == Float.TYPE || clazz == Double.TYPE) {
                return Double.parseDouble(string);
            }
            return string;
        }

        private void setValue(String string, String string2) throws SAXException {
            if (string.equals("class") || string.equals("default") || string.equals("throw") || string.equals("new") || string.equals("null")) {
                string = string + "_";
            }
            try {
                Field field;
                Object object;
                block12: {
                    object = this.current.peek();
                    field = null;
                    try {
                        field = object.getClass().getField(string);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        if (!string.startsWith(lang)) break block12;
                        Method[] methodArray = "locale_" + string.substring(lang.length());
                        try {
                            field = object.getClass().getField((String)methodArray);
                        }
                        catch (NoSuchFieldException noSuchFieldException2) {
                            // empty catch block
                        }
                    }
                }
                if (field != null && Modifier.isPublic(field.getModifiers())) {
                    field.set(object, this.getValueForClass(field.getType(), string2));
                } else {
                    Method[] methodArray;
                    if (string.startsWith(lang)) {
                        int n = lang.length();
                        string = "set" + string.substring(n, n + 1).toUpperCase() + string.substring(n + 1);
                    } else {
                        string = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
                    }
                    for (Method method : methodArray = object.getClass().getDeclaredMethods()) {
                        if (!method.getName().equals(string) || method.getParameterTypes().length != 1) continue;
                        method.invoke(object, this.getValueForClass(method.getParameterTypes()[0], string2));
                        return;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.throwException(exception);
            }
        }

        private boolean parseBoolean(String string) {
            return string != null && !string.equals("0") && !string.startsWith("off") && !string.startsWith("false") && !string.startsWith("no");
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            this.throwException(sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.throwException(sAXParseException);
        }
    }

    private static class AddNamespaceFilter
    extends XMLFilterImpl {
        private final String namespace;

        public AddNamespaceFilter(String string) {
            this.namespace = string;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("".equals(string)) {
                super.startElement(this.namespace, string2, string3, attributes);
            } else {
                super.startElement(string, string2, string3, attributes);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Uniform<T>
    implements Iterable<T> {
        private Iterator<Object> iterator;

        public Uniform(Reader reader, String string, Class<T> clazz) {
            XmlObjectParser xmlObjectParser = new XmlObjectParser();
            xmlObjectParser.map(string, clazz);
            xmlObjectParser.start(reader);
            this.iterator = xmlObjectParser.iterator();
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return Uniform.this.iterator.hasNext();
                }

                @Override
                public T next() {
                    return Uniform.this.iterator.next();
                }

                @Override
                public void remove() {
                    Uniform.this.iterator.remove();
                }
            };
        }
    }

    public static class PresetParsingException
    extends SAXException {
        private int columnNumber;
        private int lineNumber;

        public PresetParsingException() {
        }

        public PresetParsingException(Exception exception) {
            super(exception);
        }

        public PresetParsingException(String string, Exception exception) {
            super(string, exception);
        }

        public PresetParsingException(String string) {
            super(string);
        }

        public PresetParsingException rememberLocation(Locator locator) {
            if (locator == null) {
                return this;
            }
            this.columnNumber = locator.getColumnNumber();
            this.lineNumber = locator.getLineNumber();
            return this;
        }

        public String getMessage() {
            String string = super.getMessage();
            if (this.lineNumber == 0 && this.columnNumber == 0) {
                return string;
            }
            if (string == null) {
                string = this.getClass().getName();
            }
            string = string + " " + I18n.tr("(at line {0}, column {1})", this.lineNumber, this.columnNumber);
            return string;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

