/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.PluginDownloadException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginDownloadTask
extends PleaseWaitRunnable {
    private static final Logger logger = Logger.getLogger(PluginDownloadTask.class.getName());
    private final Collection<PluginInformation> toUpdate = new LinkedList<PluginInformation>();
    private final Collection<PluginInformation> failed = new LinkedList<PluginInformation>();
    private final Collection<PluginInformation> downloaded = new LinkedList<PluginInformation>();
    private Exception lastException;
    private boolean canceled;
    private HttpURLConnection downloadConnection;

    public PluginDownloadTask(Component component, Collection<PluginInformation> collection, String string) throws IllegalArgumentException {
        super(component, string == null ? "" : string, false);
        CheckParameterUtil.ensureParameterNotNull(collection, "toUpdate");
        this.toUpdate.addAll(collection);
    }

    public PluginDownloadTask(ProgressMonitor progressMonitor, Collection<PluginInformation> collection, String string) {
        super(string, progressMonitor == null ? NullProgressMonitor.INSTANCE : progressMonitor, false);
        CheckParameterUtil.ensureParameterNotNull(collection, "toUpdate");
        this.toUpdate.addAll(collection);
    }

    public void setPluginsToDownload(Collection<PluginInformation> collection) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(collection, "toUpdate");
        this.toUpdate.clear();
        this.toUpdate.addAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        PluginDownloadTask pluginDownloadTask = this;
        synchronized (pluginDownloadTask) {
            if (this.downloadConnection != null) {
                this.downloadConnection.disconnect();
            }
        }
    }

    @Override
    protected void finish() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void download(PluginInformation pluginInformation, File file) throws PluginDownloadException {
        Object object;
        if (pluginInformation.mainversion > Version.getInstance().getVersion()) {
            object = new ExtendedDialog(Main.parent, I18n.tr("Skip download"), new String[]{I18n.tr("Download Plugin"), I18n.tr("Skip Download")});
            ((ExtendedDialog)object).setContent(I18n.tr("JOSM version {0} required for plugin {1}.", pluginInformation.mainversion, pluginInformation.name));
            ((ExtendedDialog)object).setButtonIcons(new String[]{"download.png", "cancel.png"});
            ((ExtendedDialog)object).showDialog();
            int n = ((ExtendedDialog)object).getValue();
            if (n != 1) {
                throw new PluginDownloadException(I18n.tr("Download skipped"));
            }
        }
        object = null;
        InputStream inputStream = null;
        try {
            if (pluginInformation.downloadlink == null) {
                String string = I18n.tr("Warning: Cannot download plugin ''{0}''. Its download link is not known. Skipping download.", pluginInformation.name);
                System.err.println(string);
                throw new PluginDownloadException(string);
            }
            URL uRL = new URL(pluginInformation.downloadlink);
            Object object2 = this;
            synchronized (object2) {
                this.downloadConnection = (HttpURLConnection)uRL.openConnection();
                this.downloadConnection.setRequestProperty("Cache-Control", "no-cache");
                this.downloadConnection.setRequestProperty("User-Agent", Version.getInstance().getAgentString());
                this.downloadConnection.setRequestProperty("Host", uRL.getHost());
                this.downloadConnection.connect();
            }
            inputStream = this.downloadConnection.getInputStream();
            object = new FileOutputStream(file);
            object2 = new byte[8192];
            int n = inputStream.read((byte[])object2);
            while (n != -1) {
                ((OutputStream)object).write((byte[])object2, 0, n);
                n = inputStream.read((byte[])object2);
            }
            ((OutputStream)object).close();
            inputStream.close();
        }
        catch (MalformedURLException malformedURLException) {
            String string = I18n.tr("Warning: Cannot download plugin ''{0}''. Its download link ''{1}'' is not a valid URL. Skipping download.", pluginInformation.name, pluginInformation.downloadlink);
            System.err.println(string);
            throw new PluginDownloadException(string);
        }
        catch (IOException iOException) {
            if (this.canceled) {
                return;
            }
            throw new PluginDownloadException(iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            PluginDownloadTask pluginDownloadTask = this;
            synchronized (pluginDownloadTask) {
                this.downloadConnection = null;
            }
            if (object != null) {
                try {
                    ((OutputStream)object).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException {
        File file = Main.pref.getPluginsDirectory();
        if (!file.exists() && !file.mkdirs()) {
            this.lastException = new PluginDownloadException(I18n.tr("Failed to create plugin directory ''{0}''", file.toString()));
            this.failed.addAll(this.toUpdate);
            return;
        }
        this.getProgressMonitor().setTicksCount(this.toUpdate.size());
        for (PluginInformation pluginInformation : this.toUpdate) {
            if (this.canceled) {
                return;
            }
            this.progressMonitor.subTask(I18n.tr("Downloading Plugin {0}...", pluginInformation.name));
            this.progressMonitor.worked(1);
            File file2 = new File(file, pluginInformation.name + ".jar.new");
            try {
                this.download(pluginInformation, file2);
            }
            catch (PluginDownloadException pluginDownloadException) {
                pluginDownloadException.printStackTrace();
                this.failed.add(pluginInformation);
                continue;
            }
            this.downloaded.add(pluginInformation);
        }
        PluginHandler.installDownloadedPlugins(false);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Collection<PluginInformation> getFailedPlugins() {
        return this.failed;
    }

    public Collection<PluginInformation> getDownloadedPlugins() {
        return this.downloaded;
    }
}

