/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.server.AuthenticationPreferencesPanel;
import org.openstreetmap.josm.gui.preferences.server.OsmApiUrlInputPanel;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreferencesPanel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.tools.I18n;

public class ServerAccessPreference
implements PreferenceSetting {
    private OsmApiUrlInputPanel pnlApiUrlPreferences;
    private JTabbedPane tpServerPreferences;
    private AuthenticationPreferencesPanel pnlAuthPreferences;
    private ProxyPreferencesPanel pnlProxyPreferences;

    protected JScrollPane wrapVerticallyScrollablePanel(VerticallyScrollablePanel verticallyScrollablePanel) {
        JScrollPane jScrollPane = new JScrollPane(verticallyScrollablePanel);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        return jScrollPane;
    }

    protected JPanel buildTabbedServerPreferences() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tpServerPreferences = new JTabbedPane();
        this.pnlAuthPreferences = new AuthenticationPreferencesPanel();
        this.tpServerPreferences.add(this.wrapVerticallyScrollablePanel(this.pnlAuthPreferences));
        this.pnlProxyPreferences = new ProxyPreferencesPanel();
        this.tpServerPreferences.add(this.wrapVerticallyScrollablePanel(this.pnlProxyPreferences));
        this.tpServerPreferences.setTitleAt(0, I18n.tr("Authentication"));
        this.tpServerPreferences.setTitleAt(1, I18n.tr("Proxy settings"));
        this.tpServerPreferences.setToolTipTextAt(0, I18n.tr("Configure your identity and how to authenticate at the OSM server"));
        this.tpServerPreferences.setToolTipTextAt(1, I18n.tr("Configure whether to use a proxy server"));
        jPanel.add((Component)this.tpServerPreferences, "Center");
        return jPanel;
    }

    protected JPanel buildContentPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.pnlApiUrlPreferences = new OsmApiUrlInputPanel();
        jPanel.add((Component)this.pnlApiUrlPreferences, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 3, 3);
        jPanel.add((Component)this.buildTabbedServerPreferences(), gridBagConstraints);
        this.pnlApiUrlPreferences.addPropertyChangeListener(this.pnlAuthPreferences);
        HelpUtil.setHelpContext(jPanel, HelpUtil.ht("/Preferences/Connection"));
        return jPanel;
    }

    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        preferenceTabbedPane.connection.add((Component)this.buildContentPanel(), gridBagConstraints);
        this.initFromPreferences();
    }

    public void initFromPreferences() {
        this.pnlApiUrlPreferences.initFromPreferences();
        this.pnlAuthPreferences.initFromPreferences();
        this.pnlProxyPreferences.initFromPreferences();
    }

    public boolean ok() {
        this.pnlApiUrlPreferences.saveToPreferences();
        this.pnlAuthPreferences.saveToPreferences();
        this.pnlProxyPreferences.saveToPreferences();
        return false;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new ServerAccessPreference();
        }
    }
}

