/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.UrlLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawGpsLayer
extends Layer
implements Preferences.PreferenceChangedListener {
    public final Collection<Collection<GpsPoint>> data;
    public final boolean fromServer;

    public RawGpsLayer(boolean bl, Collection<Collection<GpsPoint>> collection, String string, File file) {
        super(string);
        this.fromServer = bl;
        this.setAssociatedFile(file);
        this.data = collection;
        Main.pref.addPreferenceChangeListener(this);
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "rawgps_small");
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        graphics2D.setColor(Main.pref.getColor(I18n.marktr("gps point"), "layer " + this.getName(), Color.gray));
        Point point = null;
        boolean bl = Main.pref.getBoolean("draw.rawgps.lines.force");
        boolean bl2 = Main.pref.getBoolean("draw.rawgps.lines", true);
        String string = "draw.rawgps.lines.layer " + this.getName();
        if (Main.pref.hasKey(string)) {
            bl2 = Main.pref.getBoolean(string);
        }
        boolean bl3 = Main.pref.getBoolean("draw.rawgps.large");
        for (Collection<GpsPoint> collection : this.data) {
            if (!bl) {
                point = null;
            }
            for (GpsPoint gpsPoint : collection) {
                Point point2 = mapView.getPoint(gpsPoint.eastNorth);
                if (bl2 && point != null) {
                    graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
                } else if (!bl3) {
                    graphics2D.drawRect(point2.x, point2.y, 0, 0);
                }
                if (bl3) {
                    graphics2D.fillRect(point2.x - 1, point2.y - 1, 3, 3);
                }
                point = point2;
            }
        }
    }

    @Override
    public String getToolTipText() {
        int n = 0;
        for (Collection<GpsPoint> object2 : this.data) {
            n += object2.size();
        }
        Object object3 = this.data.size() + " " + I18n.trnc("gps", "track", "tracks", this.data.size()) + " " + n + " " + I18n.trn("point", "points", n);
        File file = this.getAssociatedFile();
        if (file != null) {
            object3 = "<html>" + (String)object3 + "<br>" + file.getPath() + "</html>";
        }
        return object3;
    }

    @Override
    public void mergeFrom(Layer layer) {
        RawGpsLayer rawGpsLayer = (RawGpsLayer)layer;
        this.data.addAll(rawGpsLayer.data);
    }

    @Override
    public boolean isMergable(Layer layer) {
        return layer instanceof RawGpsLayer;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (Collection<GpsPoint> collection : this.data) {
            for (GpsPoint gpsPoint : collection) {
                boundingXYVisitor.visit(gpsPoint.eastNorth);
            }
        }
    }

    @Override
    public Object getInfoComponent() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Collection<GpsPoint> collection : this.data) {
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + I18n.trn("a track with {0} point", "a track with {0} points", collection.size(), collection.size()) + "<br>");
            n += collection.size();
        }
        stringBuilder.append("</html>");
        return "<html>" + I18n.trn("{0} consists of {1} track", "{0} consists of {1} tracks", this.data.size(), this.getName(), this.data.size()) + " (" + I18n.trn("{0} point", "{0} points", n, n) + ")<br>" + stringBuilder.toString();
    }

    @Override
    public Action[] getMenuEntries() {
        if (Main.applet) {
            return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new CustomizeColor(), new CustomizeLineDrawing(), new ConvertToDataLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
        }
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new Layer.LayerGpxExportAction(this), new CustomizeColor(), new CustomizeLineDrawing(), new ConvertToDataLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        if (Main.map != null && (preferenceChangeEvent.getKey().equals("draw.rawgps.lines") || preferenceChangeEvent.getKey().equals("draw.rawgps.lines.force"))) {
            Main.map.repaint();
        }
    }

    @Override
    public void destroy() {
        Main.pref.removePreferenceChangeListener(this);
    }

    private class CustomizeColor
    extends AbstractAction {
        public CustomizeColor() {
            super(I18n.tr("Customize Color"), ImageProvider.get("colorchooser"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JColorChooser jColorChooser = new JColorChooser(Main.pref.getColor(I18n.marktr("gps point"), "layer " + RawGpsLayer.this.getName(), Color.gray));
            Object[] objectArray = new Object[]{I18n.tr("OK"), I18n.tr("Cancel"), I18n.tr("Default")};
            int n = JOptionPane.showOptionDialog(Main.parent, jColorChooser, I18n.tr("Choose a color"), 2, -1, null, objectArray, objectArray[0]);
            switch (n) {
                case 0: {
                    Main.pref.putColor("layer " + RawGpsLayer.this.getName(), jColorChooser.getColor());
                    break;
                }
                case 1: {
                    return;
                }
                case 2: {
                    Main.pref.putColor("layer " + RawGpsLayer.this.getName(), null);
                }
            }
            Main.map.repaint();
        }
    }

    private class CustomizeLineDrawing
    extends AbstractAction {
        public CustomizeLineDrawing() {
            super(I18n.tr("Customize line drawing"), ImageProvider.get("mapmode/addsegment"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton[] jRadioButtonArray = new JRadioButton[]{new JRadioButton(I18n.tr("Use global settings.")), new JRadioButton(I18n.tr("Draw lines between points for this layer.")), new JRadioButton(I18n.tr("Do not draw lines between points for this layer."))};
            ButtonGroup buttonGroup = new ButtonGroup();
            Box box = Box.createVerticalBox();
            for (JRadioButton jRadioButton : jRadioButtonArray) {
                buttonGroup.add(jRadioButton);
                box.add(jRadioButton);
            }
            String string = "draw.rawgps.lines.layer " + RawGpsLayer.this.getName();
            if (Main.pref.hasKey(string)) {
                buttonGroup.setSelected(jRadioButtonArray[Main.pref.getBoolean(string) ? 1 : 2].getModel(), true);
            } else {
                buttonGroup.setSelected(jRadioButtonArray[0].getModel(), true);
            }
            int n = JOptionPane.showConfirmDialog(Main.parent, box, I18n.tr("Select line drawing options"), 2, -1);
            if (n == 2) {
                return;
            }
            if (buttonGroup.getSelection() == jRadioButtonArray[0].getModel()) {
                Main.pref.put(string, null);
            } else {
                Main.pref.put(string, buttonGroup.getSelection() == jRadioButtonArray[1].getModel());
            }
            Main.map.repaint();
        }
    }

    public static class GpsPoint {
        public final LatLon latlon;
        public final EastNorth eastNorth;
        public final String time;

        public GpsPoint(LatLon latLon, String string) {
            this.latlon = latLon;
            this.eastNorth = Main.proj.latlon2eastNorth(latLon);
            this.time = string;
        }
    }

    public class ConvertToDataLayerAction
    extends AbstractAction {
        public ConvertToDataLayerAction() {
            super(I18n.tr("Convert to data layer"), ImageProvider.get("converttoosm"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JLabel(I18n.tr("<html>Upload of unprocessed GPS data as map data is considered harmful.<br>If you want to upload traces, look here:</html>")), GBC.eol());
            jPanel.add((Component)new UrlLabel(I18n.tr("http://www.openstreetmap.org/traces")), GBC.eop());
            if (!ConditionalOptionPaneUtil.showConfirmationDialog("convert_to_data", Main.parent, jPanel, I18n.tr("Warning"), 2, 2, 0)) {
                return;
            }
            DataSet dataSet = new DataSet();
            for (Collection<GpsPoint> collection : RawGpsLayer.this.data) {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                for (GpsPoint gpsPoint : collection) {
                    Node node = new Node(gpsPoint.latlon);
                    dataSet.addPrimitive(node);
                    arrayList.add(node);
                }
                Way way = new Way();
                way.setNodes(arrayList);
                dataSet.addPrimitive(way);
            }
            Main.main.addLayer(new OsmDataLayer(dataSet, I18n.tr("Converted from: {0}", RawGpsLayer.this.getName()), null));
            Main.main.removeLayer(RawGpsLayer.this);
        }
    }
}

