/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.io.ChangesetCommentModel;
import org.openstreetmap.josm.gui.io.UploadParameterSummaryPanel;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class BasicUploadSettingsPanel
extends JPanel {
    public static final String HISTORY_KEY = "upload.comment.history";
    public static final String HISTORY_LAST_USED_KEY = "upload.comment.last-used";
    private HistoryComboBox hcbUploadComment;
    private UploadParameterSummaryPanel pnlUploadParameterSummary;
    private ChangesetCommentModel changesetCommentModel;

    protected JPanel buildUploadCommentPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Provide a brief comment for the changes you are uploading:")), GBC.eol().insets(0, 5, 10, 3));
        this.hcbUploadComment = new HistoryComboBox();
        this.hcbUploadComment.setToolTipText(I18n.tr("Enter an upload comment"));
        LinkedList<String> linkedList = new LinkedList<String>(Main.pref.getCollection(HISTORY_KEY, new LinkedList<String>()));
        Collections.reverse(linkedList);
        this.hcbUploadComment.setPossibleItems(linkedList);
        this.hcbUploadComment.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicUploadSettingsPanel.this.changesetCommentModel.setComment(BasicUploadSettingsPanel.this.hcbUploadComment.getText());
            }
        });
        this.hcbUploadComment.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                BasicUploadSettingsPanel.this.changesetCommentModel.setComment(BasicUploadSettingsPanel.this.hcbUploadComment.getText());
            }
        });
        jPanel.add((Component)this.hcbUploadComment, GBC.eol().fill(2));
        return jPanel;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.add((Component)this.buildUploadCommentPanel(), "North");
        this.pnlUploadParameterSummary = new UploadParameterSummaryPanel();
        this.add((Component)this.pnlUploadParameterSummary, "Center");
    }

    public BasicUploadSettingsPanel(ChangesetCommentModel changesetCommentModel) {
        CheckParameterUtil.ensureParameterNotNull(changesetCommentModel, "changesetCommentModel");
        this.changesetCommentModel = changesetCommentModel;
        changesetCommentModel.addObserver(new ChangesetCommentObserver());
        this.build();
    }

    public void setUploadCommentDownFocusTraversalHandler(final Action action) {
        this.hcbUploadComment.getEditor().addActionListener(action);
        this.hcbUploadComment.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9) {
                    action.actionPerformed(new ActionEvent(BasicUploadSettingsPanel.this.hcbUploadComment, 0, "focusDown"));
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
            }
        });
    }

    public void rememberUserInput() {
        this.hcbUploadComment.addCurrentItemToHistory();
        Main.pref.putCollection(HISTORY_KEY, this.hcbUploadComment.getHistory());
        Main.pref.putInteger(HISTORY_LAST_USED_KEY, (int)(System.currentTimeMillis() / 1000L));
    }

    public void startUserInput() {
        List<String> list = this.hcbUploadComment.getHistory();
        int n = (int)(System.currentTimeMillis() / 1000L - (long)Main.pref.getInteger(HISTORY_LAST_USED_KEY, 0));
        if (n < 14400000 && list != null && !list.isEmpty()) {
            this.hcbUploadComment.setText(list.get(0));
        }
        this.hcbUploadComment.requestFocusInWindow();
        this.hcbUploadComment.getEditor().getEditorComponent().requestFocusInWindow();
    }

    public void initEditingOfUploadComment() {
        this.hcbUploadComment.getEditor().selectAll();
        this.hcbUploadComment.requestFocusInWindow();
    }

    public UploadParameterSummaryPanel getUploadParameterSummaryPanel() {
        return this.pnlUploadParameterSummary;
    }

    class ChangesetCommentObserver
    implements Observer {
        ChangesetCommentObserver() {
        }

        public void update(Observable observable, Object object) {
            if (!(observable instanceof ChangesetCommentModel)) {
                return;
            }
            String string = (String)object;
            if (!BasicUploadSettingsPanel.this.hcbUploadComment.getText().equals(string)) {
                BasicUploadSettingsPanel.this.hcbUploadComment.setText(string);
            }
        }
    }
}

