/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PlaceSelection
implements DownloadSelection {
    private static final String HISTORY_KEY = "download.places.history";
    private HistoryComboBox cbSearchExpression;
    private JButton btnSearch;
    private NamedResultTableModel model;
    private NamedResultTableColumnModel columnmodel;
    private JTable tblSearchResults;
    private DownloadDialog parent;
    private static final Server[] servers = new Server[]{new Server("Nominatim", "http://nominatim.openstreetmap.org/search?format=xml&q=", I18n.tr("Class Type"), I18n.tr("Bounds")), new Server("Namefinder", "http://gazetteer.openstreetmap.org/namefinder/search.xml?find=", I18n.tr("Near"), I18n.trc("placeselection", "Zoom"))};
    private final JComboBox server = new JComboBox<Server>(servers);

    protected JPanel buildSearchPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel.add(new JLabel(I18n.tr("Choose the server for searching:")));
        jPanel.add(this.server);
        String string = Main.pref.get("namefinder.server", PlaceSelection.servers[0].name);
        for (int i = 0; i < servers.length; ++i) {
            if (!PlaceSelection.servers[i].name.equals(string)) continue;
            this.server.setSelectedIndex(i);
        }
        jPanel.add(new JLabel(I18n.tr("Enter a place name to search for:")));
        this.cbSearchExpression = new HistoryComboBox();
        this.cbSearchExpression.setToolTipText(I18n.tr("Enter a place name to search for"));
        LinkedList<String> linkedList = new LinkedList<String>(Main.pref.getCollection(HISTORY_KEY, new LinkedList<String>()));
        Collections.reverse(linkedList);
        this.cbSearchExpression.setPossibleItems(linkedList);
        jPanel.add(this.cbSearchExpression);
        jPanel2.add((Component)jPanel, GBC.std().fill(2).insets(5, 5, 0, 5));
        SearchAction searchAction = new SearchAction();
        this.btnSearch = new JButton(searchAction);
        ((JTextField)this.cbSearchExpression.getEditor().getEditorComponent()).getDocument().addDocumentListener(searchAction);
        ((JTextField)this.cbSearchExpression.getEditor().getEditorComponent()).addActionListener(searchAction);
        jPanel2.add((Component)this.btnSearch, GBC.eol().insets(5, 5, 0, 5));
        return jPanel2;
    }

    public void addGui(DownloadDialog downloadDialog) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.buildSearchPanel(), "North");
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.model = new NamedResultTableModel(defaultListSelectionModel);
        this.columnmodel = new NamedResultTableColumnModel();
        this.tblSearchResults = new JTable(this.model, this.columnmodel);
        this.tblSearchResults.setSelectionModel(defaultListSelectionModel);
        JScrollPane jScrollPane = new JScrollPane(this.tblSearchResults);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        jPanel.add((Component)jScrollPane, "Center");
        downloadDialog.addDownloadAreaSelector(jPanel, I18n.tr("Areas around places"));
        jScrollPane.setPreferredSize(jScrollPane.getPreferredSize());
        this.tblSearchResults.getSelectionModel().setSelectionMode(0);
        this.tblSearchResults.getSelectionModel().addListSelectionListener(new ListSelectionHandler());
        this.tblSearchResults.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    SearchResult searchResult = PlaceSelection.this.model.getSelectedSearchResult();
                    if (searchResult == null) {
                        return;
                    }
                    PlaceSelection.this.parent.startDownload(searchResult.getDownloadArea());
                }
            }
        });
        this.parent = downloadDialog;
    }

    public void setDownloadArea(Bounds bounds) {
        this.tblSearchResults.clearSelection();
    }

    static class NamedResultCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public NamedResultCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }

        protected void reset() {
            this.setText("");
            this.setIcon(null);
        }

        protected void renderColor(boolean bl) {
            if (bl) {
                this.setForeground(UIManager.getColor("Table.selectionForeground"));
                this.setBackground(UIManager.getColor("Table.selectionBackground"));
            } else {
                this.setForeground(UIManager.getColor("Table.foreground"));
                this.setBackground(UIManager.getColor("Table.background"));
            }
        }

        protected String lineWrapDescription(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken();
                if (stringBuffer2.length() == 0) {
                    stringBuffer2.append(string2);
                    continue;
                }
                if (stringBuffer2.length() < 80) {
                    stringBuffer2.append(" ").append(string2);
                    continue;
                }
                stringBuffer2.append(" ").append(string2).append("<br>");
                stringBuffer.append(stringBuffer2);
                stringBuffer2 = new StringBuffer();
            }
            stringBuffer.insert(0, "<html>");
            stringBuffer.append("</html>");
            return stringBuffer.toString();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.reset();
            this.renderColor(bl);
            if (object == null) {
                return this;
            }
            SearchResult searchResult = (SearchResult)object;
            switch (n2) {
                case 0: {
                    this.setText(searchResult.name);
                    break;
                }
                case 1: {
                    this.setText(searchResult.info);
                    break;
                }
                case 2: {
                    this.setText(searchResult.nearestPlace);
                    break;
                }
                case 3: {
                    if (searchResult.bounds != null) {
                        this.setText(searchResult.bounds.toShortString(new DecimalFormat("0.000")));
                        break;
                    }
                    this.setText(searchResult.zoom != 0 ? Integer.toString(searchResult.zoom) : I18n.tr("unknown"));
                }
            }
            this.setToolTipText(this.lineWrapDescription(searchResult.description));
            return this;
        }
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        ListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            SearchResult searchResult = PlaceSelection.this.model.getSelectedSearchResult();
            if (searchResult != null) {
                PlaceSelection.this.parent.boundingBoxChanged(searchResult.getDownloadArea(), PlaceSelection.this);
            }
        }
    }

    static class NamedResultTableColumnModel
    extends DefaultTableColumnModel {
        TableColumn col3 = null;
        TableColumn col4 = null;

        protected void createColumns() {
            TableColumn tableColumn = null;
            NamedResultCellRenderer namedResultCellRenderer = new NamedResultCellRenderer();
            tableColumn = new TableColumn(0);
            tableColumn.setHeaderValue(I18n.tr("Name"));
            tableColumn.setResizable(true);
            tableColumn.setPreferredWidth(200);
            tableColumn.setCellRenderer(namedResultCellRenderer);
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(1);
            tableColumn.setHeaderValue(I18n.tr("Type"));
            tableColumn.setResizable(true);
            tableColumn.setPreferredWidth(100);
            tableColumn.setCellRenderer(namedResultCellRenderer);
            this.addColumn(tableColumn);
            this.col3 = new TableColumn(2);
            this.col3.setHeaderValue(servers[0].thirdcol);
            this.col3.setResizable(true);
            this.col3.setPreferredWidth(100);
            this.col3.setCellRenderer(namedResultCellRenderer);
            this.addColumn(this.col3);
            this.col4 = new TableColumn(3);
            this.col4.setHeaderValue(servers[0].fourthcol);
            this.col4.setResizable(true);
            this.col4.setPreferredWidth(50);
            this.col4.setCellRenderer(namedResultCellRenderer);
            this.addColumn(this.col4);
        }

        public void setHeadlines(String string, String string2) {
            this.col3.setHeaderValue(string);
            this.col4.setHeaderValue(string2);
            this.fireColumnMarginChanged();
        }

        public NamedResultTableColumnModel() {
            this.createColumns();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NamedResultTableModel
    extends DefaultTableModel {
        private ArrayList<SearchResult> data = new ArrayList();
        private ListSelectionModel selectionModel;

        public NamedResultTableModel(ListSelectionModel listSelectionModel) {
            this.selectionModel = listSelectionModel;
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.data == null) {
                return null;
            }
            return this.data.get(n);
        }

        public void setData(List<SearchResult> list) {
            if (list == null) {
                this.data.clear();
            } else {
                this.data = new ArrayList<SearchResult>(list);
            }
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public SearchResult getSelectedSearchResult() {
            if (this.selectionModel.getMinSelectionIndex() < 0) {
                return null;
            }
            return this.data.get(this.selectionModel.getMinSelectionIndex());
        }
    }

    class NameQueryTask
    extends PleaseWaitRunnable {
        private String searchExpression;
        private HttpURLConnection connection;
        private List<SearchResult> data;
        private boolean canceled;
        private Server useserver;
        private Exception lastException;

        public NameQueryTask(String string) {
            super(I18n.tr("Querying name server"), false);
            this.canceled = false;
            this.searchExpression = string;
            this.useserver = (Server)PlaceSelection.this.server.getSelectedItem();
            Main.pref.put("namefinder.server", this.useserver.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cancel() {
            this.canceled = true;
            NameQueryTask nameQueryTask = this;
            synchronized (nameQueryTask) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
            }
        }

        protected void finish() {
            if (this.canceled) {
                return;
            }
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
                return;
            }
            PlaceSelection.this.columnmodel.setHeadlines(this.useserver.thirdcol, this.useserver.fourthcol);
            PlaceSelection.this.model.setData(this.data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            String string = this.useserver.url + URLEncoder.encode(this.searchExpression, "UTF-8");
            try {
                this.getProgressMonitor().indeterminateSubTask(I18n.tr("Querying name server ..."));
                URL uRL = new URL(string);
                Object object = this;
                synchronized (object) {
                    this.connection = (HttpURLConnection)uRL.openConnection();
                }
                this.connection.setConnectTimeout(15000);
                object = this.connection.getInputStream();
                InputSource inputSource = new InputSource(new InputStreamReader((InputStream)object, "UTF-8"));
                NameFinderResultParser nameFinderResultParser = new NameFinderResultParser();
                SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)nameFinderResultParser);
                this.data = nameFinderResultParser.getResult();
            }
            catch (Exception exception) {
                if (this.canceled) {
                    return;
                }
                OsmTransferException osmTransferException = new OsmTransferException(exception);
                osmTransferException.setUrl(string);
                this.lastException = osmTransferException;
            }
        }
    }

    class SearchAction
    extends AbstractAction
    implements DocumentListener {
        public SearchAction() {
            this.putValue("Name", I18n.tr("Search ..."));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "search"));
            this.putValue("ShortDescription", I18n.tr("Click to start searching for places"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled() || PlaceSelection.this.cbSearchExpression.getText().trim().length() == 0) {
                return;
            }
            PlaceSelection.this.cbSearchExpression.addCurrentItemToHistory();
            Main.pref.putCollection(PlaceSelection.HISTORY_KEY, PlaceSelection.this.cbSearchExpression.getHistory());
            NameQueryTask nameQueryTask = new NameQueryTask(PlaceSelection.this.cbSearchExpression.getText());
            Main.worker.submit(nameQueryTask);
        }

        protected void updateEnabledState() {
            this.setEnabled(PlaceSelection.this.cbSearchExpression.getText().trim().length() > 0);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameFinderResultParser
    extends DefaultHandler {
        private SearchResult currentResult = null;
        private StringBuffer description = null;
        private int depth = 0;
        private List<SearchResult> data = new LinkedList<SearchResult>();

        private NameFinderResultParser() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ++this.depth;
            try {
                if (!string3.equals("searchresults")) {
                    if (string3.equals("named") && this.depth == 2) {
                        this.currentResult = new SearchResult();
                        this.currentResult.name = attributes.getValue("name");
                        this.currentResult.info = attributes.getValue("info");
                        if (this.currentResult.info != null) {
                            this.currentResult.info = I18n.tr(this.currentResult.info);
                        }
                        this.currentResult.lat = Double.parseDouble(attributes.getValue("lat"));
                        this.currentResult.lon = Double.parseDouble(attributes.getValue("lon"));
                        this.currentResult.zoom = Integer.parseInt(attributes.getValue("zoom"));
                        this.data.add(this.currentResult);
                    } else if (string3.equals("description") && this.depth == 3) {
                        this.description = new StringBuffer();
                    } else if (string3.equals("named") && this.depth == 4) {
                        String string4 = attributes.getValue("info");
                        if ("city".equals(string4) || "town".equals(string4) || "village".equals(string4)) {
                            this.currentResult.nearestPlace = attributes.getValue("name");
                        }
                    } else if (string3.equals("place") && attributes.getValue("lat") != null) {
                        this.currentResult = new SearchResult();
                        this.currentResult.description = this.currentResult.name = attributes.getValue("display_name");
                        this.currentResult.info = attributes.getValue("class");
                        if (this.currentResult.info != null) {
                            this.currentResult.info = I18n.tr(this.currentResult.info);
                        }
                        this.currentResult.nearestPlace = I18n.tr(attributes.getValue("type"));
                        this.currentResult.lat = Double.parseDouble(attributes.getValue("lat"));
                        this.currentResult.lon = Double.parseDouble(attributes.getValue("lon"));
                        String[] stringArray = attributes.getValue("boundingbox").split(",");
                        this.currentResult.bounds = new Bounds(new LatLon(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[2])), new LatLon(Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[3])));
                        this.data.add(this.currentResult);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                throw new SAXException(numberFormatException.getMessage(), numberFormatException);
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                throw new SAXException(I18n.tr("Null pointer exception, possibly some missing tags."), nullPointerException);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!string3.equals("searchresults") && string3.equals("description") && this.description != null) {
                this.currentResult.description = this.description.toString();
                this.description = null;
            }
            --this.depth;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.description != null) {
                this.description.append(cArray, n, n2);
            }
        }

        public List<SearchResult> getResult() {
            return this.data;
        }
    }

    private static class SearchResult {
        public String name;
        public String info;
        public String nearestPlace;
        public String description;
        public double lat;
        public double lon;
        public int zoom = 0;
        public Bounds bounds = null;

        private SearchResult() {
        }

        public Bounds getDownloadArea() {
            return this.bounds != null ? this.bounds : OsmUrlToBounds.positionToBounds(this.lat, this.lon, this.zoom);
        }
    }

    private static class Server {
        public String name;
        public String url;
        public String thirdcol;
        public String fourthcol;

        public String toString() {
            return this.name;
        }

        public Server(String string, String string2, String string3, String string4) {
            this.name = string;
            this.url = string2;
            this.thirdcol = string3;
            this.fourthcol = string4;
        }
    }
}

