/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentDownloadTask;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SingleChangesetDownloadPanel
extends JPanel {
    private JTextField tfChangesetId;
    private DownloadAction actDownload;
    private ChangesetIdValidator valChangesetId;

    protected void build() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        this.add(new JLabel(I18n.tr("Changeset ID: ")));
        this.tfChangesetId = new JTextField(10);
        this.add(this.tfChangesetId);
        this.tfChangesetId.setToolTipText(I18n.tr("Enter a changeset id"));
        this.valChangesetId = ChangesetIdValidator.decorate(this.tfChangesetId);
        SelectAllOnFocusGainedDecorator.decorate(this.tfChangesetId);
        this.actDownload = new DownloadAction();
        SideButton sideButton = new SideButton(this.actDownload);
        this.tfChangesetId.addActionListener(this.actDownload);
        this.tfChangesetId.getDocument().addDocumentListener(this.actDownload);
        this.add(sideButton);
    }

    public SingleChangesetDownloadPanel() {
        this.build();
    }

    public int getChangesetId() {
        return this.valChangesetId.getChangesetId();
    }

    private static class ChangesetIdValidator
    extends AbstractTextComponentValidator {
        public static ChangesetIdValidator decorate(JTextComponent jTextComponent) {
            return new ChangesetIdValidator(jTextComponent);
        }

        public ChangesetIdValidator(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        public boolean isValid() {
            String string = this.getComponent().getText();
            if (string == null || string.trim().length() == 0) {
                return true;
            }
            return this.getChangesetId() > 0;
        }

        public void validate() {
            if (!this.isValid()) {
                this.feedbackInvalid(I18n.tr("The current value is not a valid changeset ID. Please enter an integer value > 0"));
            } else {
                this.feedbackValid(I18n.tr("Please enter an integer value > 0"));
            }
        }

        public int getChangesetId() {
            String string = this.getComponent().getText();
            if (string == null || string.trim().length() == 0) {
                return 0;
            }
            try {
                int n = Integer.parseInt(string.trim());
                if (n > 0) {
                    return n;
                }
                return 0;
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
    }

    class DownloadAction
    extends AbstractAction
    implements DocumentListener {
        public DownloadAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/changeset", "downloadchangesetcontent"));
            this.putValue("ShortDescription", I18n.tr("Download the changeset with the specified id, including the changeset content"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            int n = SingleChangesetDownloadPanel.this.getChangesetId();
            if (n == 0) {
                return;
            }
            ChangesetContentDownloadTask changesetContentDownloadTask = new ChangesetContentDownloadTask((Component)SingleChangesetDownloadPanel.this, Collections.singleton(n));
            ChangesetCacheManager.getInstance().runDownloadTask(changesetContentDownloadTask);
        }

        protected void updateEnabledState() {
            String string = SingleChangesetDownloadPanel.this.tfChangesetId.getText();
            if (string == null || string.trim().length() == 0) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(SingleChangesetDownloadPanel.this.valChangesetId.isValid());
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }
    }
}

