/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import org.openstreetmap.josm.data.osm.FilterMatcher;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterWorker {
    public static boolean executeFilters(Collection<OsmPrimitive> collection, FilterMatcher filterMatcher) {
        boolean bl = false;
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Node) continue;
            if (filterMatcher.isHidden(osmPrimitive)) {
                bl |= osmPrimitive.setDisabledState(true);
                continue;
            }
            if (filterMatcher.isDisabled(osmPrimitive)) {
                bl |= osmPrimitive.setDisabledState(false);
                continue;
            }
            bl |= osmPrimitive.unsetDisabledState();
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Node)) continue;
            if (filterMatcher.isHidden(osmPrimitive)) {
                bl |= osmPrimitive.setDisabledState(true);
                continue;
            }
            if (filterMatcher.isDisabled(osmPrimitive)) {
                bl |= osmPrimitive.setDisabledState(false);
                continue;
            }
            bl |= osmPrimitive.unsetDisabledState();
        }
        return bl;
    }

    public static boolean executeFilters(OsmPrimitive osmPrimitive, FilterMatcher filterMatcher) {
        boolean bl = false;
        bl = filterMatcher.isHidden(osmPrimitive) ? (bl |= osmPrimitive.setDisabledState(true)) : (filterMatcher.isDisabled(osmPrimitive) ? (bl |= osmPrimitive.setDisabledState(false)) : (bl |= osmPrimitive.unsetDisabledState()));
        return bl;
    }

    public static void clearFilterFlags(Collection<OsmPrimitive> collection) {
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.unsetDisabledState();
        }
    }
}

