/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.AllFormatsImporter;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenFileAction
extends DiskAccessAction {
    public OpenFileAction() {
        super(I18n.tr("Open..."), "open", I18n.tr("Open a file."), Shortcut.registerShortcut("system:open", I18n.tr("File: {0}", I18n.tr("Open...")), 79, 2));
        this.putValue("help", HelpUtil.ht("/Action/OpenFile"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = OpenFileAction.createAndOpenFileChooser(true, true, null);
        if (jFileChooser == null) {
            return;
        }
        File[] fileArray = jFileChooser.getSelectedFiles();
        OpenFileTask openFileTask = new OpenFileTask(Arrays.asList(fileArray), jFileChooser.getFileFilter());
        Main.worker.submit(openFileTask);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(!Main.applet);
    }

    public static void openFiles(List<File> list) {
        OpenFileTask openFileTask = new OpenFileTask(list, null);
        Main.worker.submit(openFileTask);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OpenFileTask
    extends PleaseWaitRunnable {
        private List<File> files;
        private FileFilter fileFilter;
        private boolean cancelled;

        public OpenFileTask(List<File> list, FileFilter fileFilter) {
            super(I18n.tr("Opening files"), false);
            this.files = new ArrayList<File>(list);
            this.fileFilter = fileFilter;
        }

        @Override
        protected void cancel() {
            this.cancelled = true;
        }

        @Override
        protected void finish() {
        }

        protected void alertFilesNotMatchingWithImporter(Collection<File> collection, FileImporter fileImporter) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            stringBuffer.append(I18n.trn("Cannot open {0} file with the file importer ''{1}''.", "Cannot open {0} files with the file importer ''{1}''.", collection.size(), collection.size(), fileImporter.filter.getDescription())).append("<br>");
            stringBuffer.append("<ul>");
            for (File file : collection) {
                stringBuffer.append("<li>").append(file.getAbsolutePath()).append("</li>");
            }
            stringBuffer.append("</ul>");
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, stringBuffer.toString(), I18n.tr("Warning"), 2, HelpUtil.ht("/Action/OpenFile#ImporterCantImportFiles"));
        }

        protected void alertFilesWithUnknownImporter(Collection<File> collection) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            stringBuffer.append(I18n.trn("Cannot open {0} file because no suitable file importer is available.", "Cannot open {0} files because no suitable file importer is available.", collection.size(), collection.size())).append("<br>");
            stringBuffer.append("<ul>");
            for (File file : collection) {
                stringBuffer.append("<li>").append(file.getAbsolutePath()).append("</li>");
            }
            stringBuffer.append("</ul>");
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, stringBuffer.toString(), I18n.tr("Warning"), 2, HelpUtil.ht("/Action/OpenFile#MissingImporterForFiles"));
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            MultiMap<FileImporter, File> multiMap;
            if (this.files == null || this.files.isEmpty()) {
                return;
            }
            FileImporter fileImporter = null;
            for (FileImporter linkedList2 : ExtensionFileFilter.importers) {
                if (this.fileFilter != linkedList2.filter) continue;
                fileImporter = linkedList2;
            }
            if (fileImporter instanceof AllFormatsImporter) {
                fileImporter = null;
            }
            this.getProgressMonitor().setTicksCount(this.files.size());
            if (fileImporter != null) {
                multiMap = new LinkedList();
                LinkedList<File> linkedList = new LinkedList<File>();
                for (final File file : this.files) {
                    if (!fileImporter.acceptFile(file)) {
                        if (file.isDirectory()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Cannot open directory ''{0}''.<br>Please select a file.</html>", file.getAbsolutePath()), I18n.tr("Open file"), 0);
                                }
                            });
                            return;
                        }
                        multiMap.add(file);
                        continue;
                    }
                    linkedList.add(file);
                }
                if (!multiMap.isEmpty()) {
                    this.alertFilesNotMatchingWithImporter((Collection<File>)((Object)multiMap), fileImporter);
                }
                if (!linkedList.isEmpty()) {
                    this.importData(fileImporter, linkedList);
                }
            } else {
                multiMap = new MultiMap<FileImporter, File>();
                LinkedList<File> linkedList = new LinkedList<File>();
                LinkedList<File> linkedList2 = new LinkedList<File>();
                block2: for (File file : this.files) {
                    for (FileImporter fileImporter2 : ExtensionFileFilter.importers) {
                        if (!fileImporter2.acceptFile(file)) continue;
                        multiMap.put(fileImporter2, file);
                        linkedList.add(file);
                        continue block2;
                    }
                    linkedList2.add(file);
                }
                if (!linkedList2.isEmpty()) {
                    this.alertFilesWithUnknownImporter(linkedList2);
                }
                ArrayList arrayList = new ArrayList(multiMap.keySet());
                Collections.sort(arrayList);
                Collections.reverse(arrayList);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    FileImporter fileImporter3 = (FileImporter)iterator.next();
                    ArrayList<File> arrayList2 = new ArrayList<File>((Collection)multiMap.get(fileImporter3));
                    this.importData(fileImporter3, arrayList2);
                }
            }
        }

        public void importData(FileImporter fileImporter, List<File> list) {
            if (fileImporter.isBatchImporter()) {
                if (this.cancelled) {
                    return;
                }
                String string = list.size() == 1 ? I18n.tr("Opening 1 file...") : I18n.trn("Opening {0} file...", "Opening {0} files...", list.size(), list.size());
                this.getProgressMonitor().setCustomText(string);
                this.getProgressMonitor().indeterminateSubTask(string);
                fileImporter.importDataHandleExceptions(list, this.getProgressMonitor().createSubTaskMonitor(list.size(), false));
            } else {
                for (File file : list) {
                    if (this.cancelled) {
                        return;
                    }
                    this.getProgressMonitor().indeterminateSubTask(I18n.tr("Opening file ''{0}'' ...", file.getAbsolutePath()));
                    fileImporter.importDataHandleExceptions(file, this.getProgressMonitor().createSubTaskMonitor(1, false));
                }
            }
        }
    }
}

