/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ActionParameter;
import org.openstreetmap.josm.actions.ParameterizedAction;
import org.openstreetmap.josm.actions.ParameterizedActionDecorator;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolbarPreferences
implements PreferenceSettingFactory {
    private static final String EMPTY_TOOLBAR_MARKER = "<!-empty-!>";
    private Map<String, Action> actions = new HashMap<String, Action>();
    private Map<String, Action> regactions = new HashMap<String, Action>();
    private DefaultMutableTreeNode rootActionsNode = new DefaultMutableTreeNode(I18n.tr("Actions"));
    public JToolBar control = new JToolBar();
    private static final String[] deftoolbar = new String[]{"open", "save", "download", "upload", "|", "undo", "redo", "|", "dialogs/search", "preference", "|", "splitway", "combineway", "wayflip", "|", "tagginggroup_Highways/Streets", "tagginggroup_Highways/Ways", "tagginggroup_Highways/Waypoints", "tagginggroup_Highways/Barriers", "|", "tagginggroup_Transport/Car", "tagginggroup_Transport/Public Transport", "|", "tagginggroup_Travel/Tourism", "tagginggroup_Travel/Food+Drinks", "|", "tagginggroup_Travel/Historic Places", "|", "tagginggroup_Man-Made/Man Made"};
    private static DataFlavor ACTION_FLAVOR = new DataFlavor(ActionDefinition.class, "ActionItem");

    @Override
    public PreferenceSetting createPreferenceSetting() {
        return new Settings(this.rootActionsNode);
    }

    public ToolbarPreferences() {
        this.control.setFloatable(false);
    }

    private void loadAction(DefaultMutableTreeNode defaultMutableTreeNode, MenuElement menuElement) {
        Object object = null;
        MenuElement menuElement2 = menuElement;
        if (menuElement.getSubElements().length > 0 && menuElement.getSubElements()[0] instanceof JPopupMenu) {
            menuElement2 = menuElement.getSubElements()[0];
        }
        for (MenuElement menuElement3 : menuElement2.getSubElements()) {
            Serializable serializable;
            if (menuElement3 instanceof JMenuItem) {
                serializable = (JMenuItem)menuElement3;
                if (((AbstractButton)serializable).getAction() != null) {
                    Action action = ((AbstractButton)serializable).getAction();
                    object = action;
                    this.actions.put((String)action.getValue("toolbar"), action);
                } else {
                    object = ((AbstractButton)serializable).getText();
                }
            }
            serializable = new DefaultMutableTreeNode(object);
            defaultMutableTreeNode.add((MutableTreeNode)((Object)serializable));
            this.loadAction((DefaultMutableTreeNode)serializable, menuElement3);
        }
    }

    public Action getAction(String string) {
        Action action = this.actions.get(string);
        if (action == null) {
            action = this.regactions.get(string);
        }
        return action;
    }

    private void loadActions() {
        this.rootActionsNode.removeAllChildren();
        this.loadAction(this.rootActionsNode, Main.main.menu);
        for (Map.Entry<String, Action> entry : this.regactions.entrySet()) {
            if (this.actions.get(entry.getKey()) != null) continue;
            this.rootActionsNode.add(new DefaultMutableTreeNode(entry.getValue()));
        }
        this.rootActionsNode.add(new DefaultMutableTreeNode(null));
    }

    private static Collection<String> getToolString() {
        Collection<String> collection = Main.pref.getCollection("toolbar", Arrays.asList(deftoolbar));
        if (collection == null || collection.size() == 0) {
            collection = Arrays.asList(deftoolbar);
        }
        return collection;
    }

    private Collection<ActionDefinition> getDefinedActions() {
        this.loadActions();
        HashMap<String, Action> hashMap = new HashMap<String, Action>(this.regactions);
        hashMap.putAll(this.actions);
        ActionParser actionParser = new ActionParser(hashMap);
        ArrayList<ActionDefinition> arrayList = new ArrayList<ActionDefinition>();
        for (String string : ToolbarPreferences.getToolString()) {
            if (string.equals("|")) {
                arrayList.add(ActionDefinition.SEPARATOR);
                continue;
            }
            ActionDefinition actionDefinition = actionParser.loadAction(string);
            if (actionDefinition == null) continue;
            arrayList.add(actionDefinition);
        }
        return arrayList;
    }

    public Action register(Action action) {
        this.regactions.put((String)action.getValue("toolbar"), action);
        return action;
    }

    public void refreshToolbarControl() {
        this.control.removeAll();
        for (ActionDefinition actionDefinition : this.getDefinedActions()) {
            if (actionDefinition == ActionDefinition.SEPARATOR) {
                this.control.addSeparator();
                continue;
            }
            Action action = actionDefinition.getParametrizedAction();
            JButton jButton = this.control.add(action);
            Object object = action.getValue("Optional tooltip text");
            if (object == null) continue;
            jButton.setToolTipText((String)object);
        }
        this.control.setVisible(this.control.getComponentCount() != 0);
    }

    public class Settings
    implements PreferenceSetting {
        private final Move moveAction = new Move();
        private final DefaultListModel selected = new DefaultListModel();
        private final JList selectedList = new JList(this.selected);
        private final DefaultTreeModel actionsTreeModel;
        private final JTree actionsTree;
        private final ActionParametersTableModel actionParametersModel = new ActionParametersTableModel();
        private final JTable actionParametersTable = new JTable(this.actionParametersModel);
        private JPanel actionParametersPanel;
        private JButton upButton;
        private JButton downButton;
        private JButton removeButton;
        private JButton addButton;
        private String movingComponent;

        public Settings(DefaultMutableTreeNode defaultMutableTreeNode) {
            this.actionsTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
            this.actionsTree = new JTree(this.actionsTreeModel);
        }

        private JButton createButton(String string) {
            JButton jButton = new JButton();
            if (string.equals("up")) {
                jButton.setIcon(ImageProvider.get("dialogs", "up"));
            } else if (string.equals("down")) {
                jButton.setIcon(ImageProvider.get("dialogs", "down"));
            } else {
                jButton.setText(string);
            }
            jButton.addActionListener(this.moveAction);
            jButton.setActionCommand(string);
            return jButton;
        }

        private void updateEnabledState() {
            int n = this.selectedList.getSelectedIndex();
            this.upButton.setEnabled(n > 0);
            this.downButton.setEnabled(n < this.selectedList.getModel().getSize() - 1);
            this.removeButton.setEnabled(n != -1);
            this.addButton.setEnabled(this.actionsTree.getSelectionCount() > 0);
        }

        public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
            this.actionsTree.setCellRenderer(new DefaultTreeCellRenderer(){

                public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                    JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                    if (defaultMutableTreeNode.getUserObject() == null) {
                        jLabel.setText(I18n.tr("Separator"));
                        jLabel.setIcon(ImageProvider.get("preferences/separator"));
                    } else if (defaultMutableTreeNode.getUserObject() instanceof Action) {
                        Action action = (Action)defaultMutableTreeNode.getUserObject();
                        jLabel.setText((String)action.getValue("Name"));
                        jLabel.setIcon((Icon)action.getValue("SmallIcon"));
                    }
                    return jLabel;
                }
            });
            DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    Icon icon;
                    String string;
                    Object object2;
                    if (object != ActionDefinition.SEPARATOR) {
                        object2 = (ActionDefinition)object;
                        string = (String)((ActionDefinition)object2).getAction().getValue("Name");
                        icon = (Icon)((ActionDefinition)object2).getAction().getValue("SmallIcon");
                    } else {
                        icon = ImageProvider.get("preferences/separator");
                        string = I18n.tr("Separator");
                    }
                    object2 = (JLabel)super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
                    ((JLabel)object2).setIcon(icon);
                    return object2;
                }
            };
            this.selectedList.setCellRenderer(defaultListCellRenderer);
            this.selectedList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    boolean bl;
                    boolean bl2 = bl = Settings.this.selectedList.getSelectedIndex() != -1;
                    if (bl) {
                        Settings.this.actionsTree.clearSelection();
                        ActionDefinition actionDefinition = (ActionDefinition)Settings.this.selected.get(Settings.this.selectedList.getSelectedIndex());
                        Settings.this.actionParametersModel.setCurrentAction(actionDefinition);
                        Settings.this.actionParametersPanel.setVisible(Settings.this.actionParametersModel.getRowCount() > 0);
                    }
                    Settings.this.updateEnabledState();
                }
            });
            this.selectedList.setDragEnabled(true);
            this.selectedList.setTransferHandler(new TransferHandler(){

                protected Transferable createTransferable(JComponent jComponent) {
                    ArrayList<ActionDefinition> arrayList = new ArrayList<ActionDefinition>();
                    for (Object object : ((JList)jComponent).getSelectedValues()) {
                        arrayList.add((ActionDefinition)object);
                    }
                    return new ActionTransferable(arrayList);
                }

                public int getSourceActions(JComponent jComponent) {
                    return 2;
                }

                public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                    for (DataFlavor dataFlavor : dataFlavorArray) {
                        if (!ACTION_FLAVOR.equals(dataFlavor)) continue;
                        return true;
                    }
                    return false;
                }

                public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
                    super.exportAsDrag(jComponent, inputEvent, n);
                    Settings.this.movingComponent = "list";
                }

                public boolean importData(JComponent jComponent, Transferable transferable) {
                    try {
                        Object object;
                        int n = Settings.this.selectedList.locationToIndex(Settings.this.selectedList.getMousePosition(true));
                        List list = (List)transferable.getTransferData(ACTION_FLAVOR);
                        Object object2 = n >= 0 ? (Object)Settings.this.selected.elementAt(n) : null;
                        int n2 = list.size();
                        if (object2 != null) {
                            for (Object e : list) {
                                if (!object2.equals(e)) continue;
                                return false;
                            }
                        }
                        int n3 = -1;
                        boolean bl = "list".equals(Settings.this.movingComponent);
                        if (bl) {
                            n3 = Settings.this.selected.indexOf(list.get(0));
                            object = list.iterator();
                            while (object.hasNext()) {
                                Object e = object.next();
                                Settings.this.selected.removeElement(e);
                            }
                        }
                        object = new int[n2];
                        if (bl) {
                            int n4 = Settings.this.selected.indexOf(object2);
                            int n5 = n3 <= n4 ? 1 : 0;
                            for (int i = 0; i < n2; ++i) {
                                Settings.this.selected.insertElementAt(list.get(i), n4 + n5 + i);
                                object[i] = n4 + n5 + i;
                            }
                        } else {
                            for (int i = 0; i < n2; ++i) {
                                Settings.this.selected.add(n, list.get(i));
                                object[i] = n + i;
                            }
                        }
                        Settings.this.selectedList.clearSelection();
                        Settings.this.selectedList.setSelectedIndices((int[])object);
                        Settings.this.movingComponent = "";
                        return true;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return false;
                    }
                }

                protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
                    if (Settings.this.movingComponent.equals("list")) {
                        try {
                            List list = (List)transferable.getTransferData(ACTION_FLAVOR);
                            boolean bl = Settings.this.selected.contains(list.get(0));
                            if (bl) {
                                int[] nArray = Settings.this.selectedList.getSelectedIndices();
                                Arrays.sort(nArray);
                                for (int i = nArray.length - 1; i >= 0; --i) {
                                    Settings.this.selected.remove(nArray[i]);
                                }
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        Settings.this.movingComponent = "";
                    }
                }
            });
            this.actionsTree.setTransferHandler(new TransferHandler(){
                private static final long serialVersionUID = 1L;

                public int getSourceActions(JComponent jComponent) {
                    return 2;
                }

                protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
                }

                protected Transferable createTransferable(JComponent jComponent) {
                    TreePath[] treePathArray = Settings.this.actionsTree.getSelectionPaths();
                    ArrayList<ActionDefinition> arrayList = new ArrayList<ActionDefinition>();
                    for (TreePath treePath : treePathArray) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        Object object = defaultMutableTreeNode.getUserObject();
                        if (object == null) {
                            arrayList.add(ActionDefinition.SEPARATOR);
                            continue;
                        }
                        if (!(object instanceof Action)) continue;
                        arrayList.add(new ActionDefinition((Action)object));
                    }
                    return new ActionTransferable(arrayList);
                }
            });
            this.actionsTree.setDragEnabled(true);
            this.actionsTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    Settings.this.updateEnabledState();
                }
            });
            final JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JLabel(I18n.tr("Toolbar")), GBC.eol());
            jPanel.add((Component)new JScrollPane(this.selectedList), GBC.std().fill(1));
            final JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.add((Component)new JLabel(I18n.tr("Available")), GBC.eol());
            jPanel2.add((Component)new JScrollPane(this.actionsTree), GBC.eol().fill(1));
            final JPanel jPanel3 = new JPanel(new GridLayout(6, 1));
            this.upButton = this.createButton("up");
            jPanel3.add(this.upButton);
            this.addButton = this.createButton("<");
            jPanel3.add(this.addButton);
            this.removeButton = this.createButton(">");
            jPanel3.add(this.removeButton);
            this.downButton = this.createButton("down");
            jPanel3.add(this.downButton);
            this.updateEnabledState();
            final JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new LayoutManager(){

                public void addLayoutComponent(String string, Component component) {
                }

                public void removeLayoutComponent(Component component) {
                }

                public Dimension minimumLayoutSize(Container container) {
                    Dimension dimension = jPanel.getMinimumSize();
                    Dimension dimension2 = jPanel2.getMinimumSize();
                    Dimension dimension3 = jPanel3.getMinimumSize();
                    return new Dimension(dimension.width + dimension3.width + 10 + dimension2.width, dimension.height + dimension3.height + 10 + dimension2.height);
                }

                public Dimension preferredLayoutSize(Container container) {
                    Dimension dimension = new Dimension(200, 200);
                    Dimension dimension2 = new Dimension(200, 200);
                    return new Dimension(dimension.width + dimension2.width + 10 + jPanel3.getPreferredSize().width, Math.max(dimension.height, dimension2.height));
                }

                public void layoutContainer(Container container) {
                    Dimension dimension = jPanel4.getSize();
                    Dimension dimension2 = jPanel3.getPreferredSize();
                    int n = (dimension.width - 10 - dimension2.width) / 2;
                    jPanel.setBounds(new Rectangle(0, 0, n, dimension.height));
                    jPanel2.setBounds(new Rectangle(n + 10 + dimension2.width, 0, n, dimension.height));
                    jPanel3.setBounds(new Rectangle(n + 5, dimension.height / 2 - dimension2.height / 2, dimension2.width, dimension2.height));
                }
            });
            jPanel4.add(jPanel);
            jPanel4.add(jPanel3);
            jPanel4.add(jPanel2);
            this.actionParametersPanel = new JPanel(new GridBagLayout());
            this.actionParametersPanel.add((Component)new JLabel(I18n.tr("Action parameters")), GBC.eol().insets(0, 10, 0, 20));
            this.actionParametersTable.getColumnModel().getColumn(0).setHeaderValue(I18n.tr("Parameter name"));
            this.actionParametersTable.getColumnModel().getColumn(1).setHeaderValue(I18n.tr("Parameter value"));
            this.actionParametersPanel.add((Component)this.actionParametersTable.getTableHeader(), GBC.eol().fill(2));
            this.actionParametersPanel.add((Component)this.actionParametersTable, GBC.eol().fill(1).insets(0, 0, 0, 10));
            this.actionParametersPanel.setVisible(false);
            JPanel jPanel5 = preferenceTabbedPane.createPreferenceTab("toolbar", I18n.tr("Toolbar customization"), I18n.tr("Customize the elements on the toolbar."), false);
            jPanel5.add((Component)jPanel4, GBC.eol().fill(1));
            jPanel5.add((Component)this.actionParametersPanel, GBC.eol().fill(2));
            this.selected.removeAllElements();
            for (ActionDefinition actionDefinition : ToolbarPreferences.this.getDefinedActions()) {
                this.selected.addElement(actionDefinition);
            }
        }

        public boolean ok() {
            LinkedList<String> linkedList = new LinkedList();
            ActionParser actionParser = new ActionParser(null);
            for (int i = 0; i < this.selected.size(); ++i) {
                if (this.selected.get(i) == ActionDefinition.SEPARATOR) {
                    linkedList.add("|");
                    continue;
                }
                linkedList.add(actionParser.saveAction((ActionDefinition)this.selected.get(i)));
            }
            if (linkedList.isEmpty()) {
                linkedList = Collections.singletonList(ToolbarPreferences.EMPTY_TOOLBAR_MARKER);
            }
            Main.pref.putCollection("toolbar", linkedList);
            Main.toolbar.refreshToolbarControl();
            return false;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ActionTransferable
        implements Transferable {
            private DataFlavor[] flavors = new DataFlavor[]{ToolbarPreferences.access$300()};
            private final List<ActionDefinition> actions;

            public ActionTransferable(List<ActionDefinition> list) {
                this.actions = list;
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                return this.actions;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return this.flavors;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return this.flavors[0] == dataFlavor;
            }
        }

        private final class Move
        implements ActionListener {
            private Move() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("<") && Settings.this.actionsTree.getSelectionCount() > 0) {
                    int n = Settings.this.selected.getSize();
                    if (Settings.this.selectedList.getSelectedIndex() != -1) {
                        int[] objectArray = Settings.this.selectedList.getSelectedIndices();
                        n = objectArray[objectArray.length - 1];
                    }
                    for (TreePath treePath : Settings.this.actionsTree.getSelectionPaths()) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        if (defaultMutableTreeNode.getUserObject() == null) {
                            Settings.this.selected.add(n++, ActionDefinition.SEPARATOR);
                            continue;
                        }
                        if (!(defaultMutableTreeNode.getUserObject() instanceof Action)) continue;
                        Settings.this.selected.add(n++, new ActionDefinition((Action)defaultMutableTreeNode.getUserObject()));
                    }
                } else if (actionEvent.getActionCommand().equals(">") && Settings.this.selectedList.getSelectedIndex() != -1) {
                    while (Settings.this.selectedList.getSelectedIndex() != -1) {
                        Settings.this.selected.remove(Settings.this.selectedList.getSelectedIndex());
                    }
                } else if (actionEvent.getActionCommand().equals("up")) {
                    int n = Settings.this.selectedList.getSelectedIndex();
                    Object e = Settings.this.selected.get(n);
                    if (n != 0) {
                        Settings.this.selected.remove(n);
                        Settings.this.selected.add(n - 1, e);
                        Settings.this.selectedList.setSelectedIndex(n - 1);
                    }
                } else if (actionEvent.getActionCommand().equals("down")) {
                    int n = Settings.this.selectedList.getSelectedIndex();
                    Object e = Settings.this.selected.get(n);
                    if (n != Settings.this.selected.size() - 1) {
                        Settings.this.selected.remove(n);
                        Settings.this.selected.add(n + 1, e);
                        Settings.this.selectedList.setSelectedIndex(n + 1);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActionParametersTableModel
    extends AbstractTableModel {
        private ActionDefinition currentAction = ActionDefinition.SEPARATOR;

        private ActionParametersTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.currentAction == ActionDefinition.SEPARATOR || !(this.currentAction.getAction() instanceof ParameterizedAction)) {
                return 0;
            }
            ParameterizedAction parameterizedAction = (ParameterizedAction)this.currentAction.getAction();
            return parameterizedAction.getActionParameters().size();
        }

        private ActionParameter<Object> getParam(int n) {
            ParameterizedAction parameterizedAction = (ParameterizedAction)this.currentAction.getAction();
            return parameterizedAction.getActionParameters().get(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ActionParameter<Object> actionParameter = this.getParam(n);
            switch (n2) {
                case 0: {
                    return actionParameter.getName();
                }
                case 1: {
                    return actionParameter.writeToString(this.currentAction.getParameters().get(actionParameter.getName()));
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ActionParameter<Object> actionParameter = this.getParam(n);
            this.currentAction.getParameters().put(actionParameter.getName(), actionParameter.readFromString((String)object));
        }

        public void setCurrentAction(ActionDefinition actionDefinition) {
            this.currentAction = actionDefinition;
            this.fireTableDataChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ActionParser {
        private final Map<String, Action> actions;
        private final StringBuilder result = new StringBuilder();
        private int index;
        private char[] s;

        public ActionParser(Map<String, Action> map) {
            this.actions = map;
        }

        private String readTillChar(char c, char c2) {
            this.result.setLength(0);
            while (this.index < this.s.length && this.s[this.index] != c && this.s[this.index] != c2) {
                if (this.s[this.index] == '\\') {
                    ++this.index;
                    if (this.index >= this.s.length) break;
                }
                this.result.append(this.s[this.index]);
                ++this.index;
            }
            return this.result.toString();
        }

        private void skip(char c) {
            if (this.index < this.s.length && this.s[this.index] == c) {
                ++this.index;
            }
        }

        public ActionDefinition loadAction(String string) {
            this.index = 0;
            this.s = string.toCharArray();
            String string2 = this.readTillChar('(', '(');
            Action action = this.actions.get(string2);
            if (action == null) {
                return null;
            }
            ActionDefinition actionDefinition = new ActionDefinition(action);
            if (action instanceof ParameterizedAction) {
                this.skip('(');
                ParameterizedAction parameterizedAction = (ParameterizedAction)action;
                HashMap hashMap = new HashMap();
                for (ActionParameter<?> object : parameterizedAction.getActionParameters()) {
                    hashMap.put(object.getName(), object);
                }
                do {
                    ActionParameter actionParameter;
                    String string3 = this.readTillChar('=', '=');
                    this.skip('=');
                    String string4 = this.readTillChar(',', ')');
                    if (string3.length() > 0 && (actionParameter = (ActionParameter)hashMap.get(string3)) != null) {
                        actionDefinition.getParameters().put(string3, actionParameter.readFromString(string4));
                    }
                    this.skip(',');
                } while (this.index < this.s.length && this.s[this.index] != ')');
            }
            return actionDefinition;
        }

        private void escape(String string) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\\' || c == '(' || c == ',' || c == ')' || c == '=') {
                    this.result.append('\\');
                    this.result.append(c);
                    continue;
                }
                this.result.append(c);
            }
        }

        public String saveAction(ActionDefinition actionDefinition) {
            this.result.setLength(0);
            this.escape((String)actionDefinition.getAction().getValue("toolbar"));
            if (actionDefinition.getAction() instanceof ParameterizedAction) {
                this.result.append('(');
                List<ActionParameter<?>> list = ((ParameterizedAction)actionDefinition.getAction()).getActionParameters();
                for (int i = 0; i < list.size(); ++i) {
                    ActionParameter<?> actionParameter = list.get(i);
                    this.escape(actionParameter.getName());
                    this.result.append('=');
                    Object object = actionDefinition.getParameters().get(actionParameter.getName());
                    if (object != null) {
                        this.escape(actionParameter.writeToString(object));
                    }
                    if (i < list.size() - 1) {
                        this.result.append(',');
                        continue;
                    }
                    this.result.append(')');
                }
            }
            return this.result.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ActionDefinition {
        public static ActionDefinition SEPARATOR = new ActionDefinition(null);
        private final Action action;
        private final Map<String, Object> parameters = new HashMap<String, Object>();

        public ActionDefinition(Action action) {
            this.action = action;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public Action getParametrizedAction() {
            if (this.getAction() instanceof ParameterizedAction) {
                return new ParameterizedActionDecorator((ParameterizedAction)this.getAction(), this.parameters);
            }
            return this.getAction();
        }

        public Action getAction() {
            return this.action;
        }
    }
}

