/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.Collection;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.gui.mappaint.Rule;

public abstract class ElemStyle {
    public long minScale;
    public long maxScale;
    public int priority;
    public String code;
    Collection<Rule> rules = null;

    public boolean equals(Object object) {
        return object instanceof ElemStyle && ((ElemStyle)object).getCode().equals(this.getCode());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String getCode() {
        if (this.code == null) {
            this.code = "";
            if (this.rules != null) {
                for (Rule rule : this.rules) {
                    this.code = this.code + rule.toCode();
                }
            }
        }
        return this.code;
    }

    public boolean check(OsmPrimitive osmPrimitive) {
        if (this.rules == null) {
            return true;
        }
        for (Rule rule : this.rules) {
            String string = osmPrimitive.get(rule.key);
            String string2 = OsmUtils.getNamedOsmBoolean(rule.boolValue);
            if (string != null && (rule.value == null || string.equals(rule.value)) && (string2 == null || string2.equals(OsmUtils.getNamedOsmBoolean(string)))) continue;
            return false;
        }
        return true;
    }

    public abstract void paintPrimitive(OsmPrimitive var1, MapPaintSettings var2, MapPainter var3, boolean var4, boolean var5);
}

