/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;

class SaveFlagCellEditor
extends JCheckBox
implements TableCellEditor {
    private CopyOnWriteArrayList<CellEditorListener> listeners = new CopyOnWriteArrayList();
    private boolean value;

    public SaveFlagCellEditor() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                SaveFlagCellEditor.this.stopCellEditing();
            }
        });
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        if (cellEditorListener != null) {
            this.listeners.addIfAbsent(cellEditorListener);
        }
    }

    protected void fireEditingCanceled() {
        for (CellEditorListener cellEditorListener : this.listeners) {
            cellEditorListener.editingCanceled(new ChangeEvent(this));
        }
    }

    protected void fireEditingStopped() {
        for (CellEditorListener cellEditorListener : this.listeners) {
            cellEditorListener.editingStopped(new ChangeEvent(this));
        }
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public Object getCellEditorValue() {
        return this.value;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.remove(cellEditorListener);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public void setInitialValue(boolean bl) {
        this.value = bl;
        this.setSelected(bl);
    }

    public boolean stopCellEditing() {
        this.value = this.isSelected();
        this.fireEditingStopped();
        return true;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        SaveLayerInfo saveLayerInfo = (SaveLayerInfo)object;
        switch (n2) {
            case 4: {
                this.setInitialValue(saveLayerInfo.isDoUploadToServer());
                break;
            }
            case 5: {
                this.setInitialValue(saveLayerInfo.isDoSaveToFile());
            }
        }
        return this;
    }
}

