/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.FilterMatcher;
import org.openstreetmap.josm.data.osm.FilterWorker;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterTableModel
extends AbstractTableModel {
    public int disabledCount;
    public int disabledAndHiddenCount;
    private final List<Filter> filters = new LinkedList<Filter>();
    private final FilterMatcher filterMatcher = new FilterMatcher();
    private OSDLabel lblOSD = new OSDLabel("");

    public FilterTableModel() {
        this.loadPrefs();
    }

    private void updateFilters() {
        try {
            this.filterMatcher.update(this.filters);
            this.executeFilters();
        }
        catch (SearchCompiler.ParseError parseError) {
            JOptionPane.showMessageDialog(Main.parent, parseError.getMessage(), I18n.tr("Error in filter"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeFilters() {
        DataSet dataSet = Main.main.getCurrentDataSet();
        boolean bl = false;
        if (dataSet == null) {
            this.disabledAndHiddenCount = 0;
            this.disabledCount = 0;
            bl = true;
        } else {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            dataSet.beginUpdate();
            try {
                Collection<OsmPrimitive> collection = dataSet.allNonDeletedCompletePrimitives();
                bl = FilterWorker.executeFilters(collection, this.filterMatcher);
                this.disabledCount = 0;
                this.disabledAndHiddenCount = 0;
                for (OsmPrimitive osmPrimitive : collection) {
                    if (!osmPrimitive.isDisabled()) continue;
                    ++this.disabledCount;
                    if (osmPrimitive.isSelected()) {
                        hashSet.add(osmPrimitive);
                    }
                    if (!osmPrimitive.isDisabledAndHidden()) continue;
                    ++this.disabledAndHiddenCount;
                }
                this.disabledCount -= this.disabledAndHiddenCount;
            }
            finally {
                dataSet.endUpdate();
            }
            if (!hashSet.isEmpty()) {
                dataSet.clearSelection(hashSet);
            }
        }
        if (Main.isDisplayingMapView() && bl) {
            Main.map.mapView.repaint();
            Main.map.filterDialog.updateDialogHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeFilters(Collection<? extends OsmPrimitive> collection) {
        DataSet dataSet = Main.main.getCurrentDataSet();
        if (dataSet == null) {
            return;
        }
        boolean bl = false;
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        dataSet.beginUpdate();
        try {
            for (int i = 0; i < 2; ++i) {
                for (OsmPrimitive osmPrimitive : collection) {
                    if (i == 0 && osmPrimitive instanceof Node || i == 1 && !(osmPrimitive instanceof Node)) continue;
                    if (osmPrimitive.isDisabled()) {
                        --this.disabledCount;
                    }
                    if (osmPrimitive.isDisabledAndHidden()) {
                        --this.disabledAndHiddenCount;
                    }
                    bl |= FilterWorker.executeFilters(osmPrimitive, this.filterMatcher);
                    if (osmPrimitive.isDisabled()) {
                        ++this.disabledCount;
                    }
                    if (osmPrimitive.isDisabledAndHidden()) {
                        ++this.disabledAndHiddenCount;
                    }
                    if (!osmPrimitive.isSelected() || !osmPrimitive.isDisabled()) continue;
                    arrayList.add(osmPrimitive);
                }
            }
        }
        finally {
            dataSet.endUpdate();
        }
        if (bl) {
            Main.map.mapView.repaint();
            Main.map.filterDialog.updateDialogHeader();
            dataSet.clearSelection(arrayList);
        }
    }

    public void clearFilterFlags() {
        DataSet dataSet = Main.main.getCurrentDataSet();
        if (dataSet != null) {
            FilterWorker.clearFilterFlags(dataSet.allPrimitives());
        }
        this.disabledCount = 0;
        this.disabledAndHiddenCount = 0;
    }

    private void loadPrefs() {
        Map<String, String> map = Main.pref.getAllPrefix("filters.filter");
        for (String string : map.values()) {
            this.filters.add(new Filter(string));
        }
        this.updateFilters();
    }

    private void savePrefs() {
        Map<String, String> map = Main.pref.getAllPrefix("filters.filter");
        for (String object : map.keySet()) {
            String[] stringArray = object.split("\\.");
            if (stringArray.length != 3) {
                throw new Error("Incompatible filter preferences");
            }
            Main.pref.put("filters.filter." + stringArray[2], null);
        }
        int n = 0;
        for (Filter filter : this.filters) {
            Main.pref.put("filters.filter." + n++, filter.getPrefString());
        }
    }

    private void savePref(int n) {
        if (n >= this.filters.size()) {
            Main.pref.put("filters.filter." + n, null);
        } else {
            Main.pref.put("filters.filter." + n, this.filters.get(n).getPrefString());
        }
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
        this.savePref(this.filters.size() - 1);
        this.updateFilters();
        this.fireTableRowsInserted(this.filters.size() - 1, this.filters.size() - 1);
    }

    public void moveDownFilter(int n) {
        if (n >= this.filters.size() - 1) {
            return;
        }
        this.filters.add(n + 1, this.filters.remove(n));
        this.savePref(n);
        this.savePref(n + 1);
        this.updateFilters();
        this.fireTableRowsUpdated(n, n + 1);
    }

    public void moveUpFilter(int n) {
        if (n == 0) {
            return;
        }
        this.filters.add(n - 1, this.filters.remove(n));
        this.savePref(n);
        this.savePref(n - 1);
        this.updateFilters();
        this.fireTableRowsUpdated(n - 1, n);
    }

    public void removeFilter(int n) {
        this.filters.remove(n);
        this.savePrefs();
        this.updateFilters();
        this.fireTableRowsDeleted(n, n);
    }

    public void setFilter(int n, Filter filter) {
        this.filters.set(n, filter);
        this.savePref(n);
        this.updateFilters();
        this.fireTableRowsUpdated(n, n);
    }

    public Filter getFilter(int n) {
        return this.filters.get(n);
    }

    @Override
    public int getRowCount() {
        return this.filters.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int n) {
        String[] stringArray = new String[]{I18n.trc("filter", "E"), I18n.trc("filter", "H"), I18n.trc("filter", "Text"), I18n.trc("filter", "I"), I18n.trc("filter", "M")};
        return stringArray[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        Class[] classArray = new Class[]{Boolean.class, Boolean.class, String.class, Boolean.class, String.class};
        return classArray[n];
    }

    public boolean isCellEnabled(int n, int n2) {
        return this.filters.get((int)n).enable || n2 == 0;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (!this.filters.get((int)n).enable && n2 != 0) {
            return false;
        }
        return n2 < 4;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Filter filter = this.filters.get(n);
        switch (n2) {
            case 0: {
                filter.enable = (Boolean)object;
                this.savePref(n);
                this.updateFilters();
                this.fireTableRowsUpdated(n, n);
                break;
            }
            case 1: {
                filter.hiding = (Boolean)object;
                this.savePref(n);
                this.updateFilters();
                break;
            }
            case 2: {
                filter.text = (String)object;
                this.savePref(n);
                break;
            }
            case 3: {
                filter.inverted = (Boolean)object;
                this.savePref(n);
                this.updateFilters();
            }
        }
        if (n2 != 0) {
            this.fireTableCellUpdated(n, n2);
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Filter filter = this.filters.get(n);
        switch (n2) {
            case 0: {
                return filter.enable;
            }
            case 1: {
                return filter.hiding;
            }
            case 2: {
                return filter.text;
            }
            case 3: {
                return filter.inverted;
            }
            case 4: {
                switch (filter.mode) {
                    case replace: {
                        return I18n.trc("filter", "R");
                    }
                    case add: {
                        return I18n.trc("filter", "A");
                    }
                    case remove: {
                        return I18n.trc("filter", "D");
                    }
                    case in_selection: {
                        return I18n.trc("filter", "F");
                    }
                }
            }
        }
        return null;
    }

    public void drawOSDText(Graphics2D graphics2D) {
        String string = "<html>" + I18n.tr("<h2>Filter active</h2>");
        if (this.disabledCount == 0 && this.disabledAndHiddenCount == 0) {
            return;
        }
        if (this.disabledAndHiddenCount != 0) {
            string = string + I18n.tr("<p><b>{0}</b> objects hidden", this.disabledAndHiddenCount);
        }
        if (this.disabledAndHiddenCount != 0 && this.disabledCount != 0) {
            string = string + "<br>";
        }
        if (this.disabledCount != 0) {
            string = string + I18n.tr("<b>{0}</b> objects disabled", this.disabledCount);
        }
        string = string + I18n.tr("</p><p>Close the filter dialog to see all objects.<p></html>");
        this.lblOSD.setText(string);
        this.lblOSD.setSize(this.lblOSD.getPreferredSize());
        int n = Main.map.mapView.getWidth() - this.lblOSD.getPreferredSize().width - 15;
        int n2 = 15;
        graphics2D.translate(n, n2);
        this.lblOSD.paintComponent(graphics2D);
        graphics2D.translate(-n, -n2);
    }

    private static class OSDLabel
    extends JLabel {
        public OSDLabel(String string) {
            super(string);
            this.setOpaque(true);
            this.setForeground(Color.black);
            this.setBackground(new Color(0, 0, 0, 0));
            this.setFont(this.getFont().deriveFont(0));
            this.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        }

        public void paintComponent(Graphics graphics) {
            graphics.setColor(new Color(255, 255, 255, 140));
            graphics.fillRoundRect(this.getX(), this.getY(), this.getWidth(), this.getHeight(), 10, 10);
            super.paintComponent(graphics);
        }
    }
}

