/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveAction
extends JosmAction {
    private Direction myDirection;

    private static Object calltosupermustbefirststatementinconstructor(Direction direction, boolean bl) {
        Shortcut shortcut;
        String string;
        if (direction == Direction.UP) {
            string = I18n.tr("up");
            shortcut = Shortcut.registerShortcut("core:moveup", I18n.tr("Move objects {0}", string), 38, 12);
        } else if (direction == Direction.DOWN) {
            string = I18n.tr("down");
            shortcut = Shortcut.registerShortcut("core:movedown", I18n.tr("Move objects {0}", string), 40, 12);
        } else if (direction == Direction.LEFT) {
            string = I18n.tr("left");
            shortcut = Shortcut.registerShortcut("core:moveleft", I18n.tr("Move objects {0}", string), 37, 12);
        } else {
            string = I18n.tr("right");
            shortcut = Shortcut.registerShortcut("core:moveright", I18n.tr("Move objects {0}", string), 39, 12);
        }
        if (bl) {
            return string;
        }
        return shortcut;
    }

    public MoveAction(Direction direction) {
        super(I18n.tr("Move {0}", MoveAction.calltosupermustbefirststatementinconstructor(direction, true)), null, I18n.tr("Moves Objects {0}", MoveAction.calltosupermustbefirststatementinconstructor(direction, true)), (Shortcut)MoveAction.calltosupermustbefirststatementinconstructor(direction, false), true);
        this.myDirection = direction;
        this.putValue("help", HelpUtil.ht("/Action/Move"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Command command;
        if (!Main.isDisplayingMapView()) {
            return;
        }
        EastNorth eastNorth = Main.map.mapView.getEastNorth(100, 100);
        EastNorth eastNorth2 = Main.map.mapView.getEastNorth(101, 101);
        double d = eastNorth2.east() - eastNorth.east();
        double d2 = eastNorth2.north() - eastNorth.north();
        switch (this.myDirection) {
            case UP: {
                d = 0.0;
                d2 = -d2;
                break;
            }
            case DOWN: {
                d = 0.0;
                break;
            }
            case LEFT: {
                d2 = 0.0;
                d = -d;
                break;
            }
            default: {
                d2 = 0.0;
            }
        }
        Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
        Collection<Node> collection2 = AllNodesVisitor.getAllNodes(collection);
        Command command2 = command = !Main.main.undoRedo.commands.isEmpty() ? Main.main.undoRedo.commands.getLast() : null;
        if (command instanceof MoveCommand && ((Object)collection2).equals(((MoveCommand)command).getParticipatingPrimitives())) {
            ((MoveCommand)command).moveAgain(d, d2);
        } else {
            command = new MoveCommand(collection, d, d2);
            Main.main.undoRedo.add(command);
        }
        for (Node node : collection2) {
            if (!node.getCoor().isOutSideWorld()) continue;
            ((MoveCommand)command).moveAgain(-d, -d2);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot move objects outside of the world."), I18n.tr("Warning"), 2);
            return;
        }
        Main.map.mapView.repaint();
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        UP,
        LEFT,
        RIGHT,
        DOWN;

    }
}

