/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPritority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompletingComboBox
extends JComboBox {
    private boolean autocompleteEnabled = true;

    public AutoCompletingComboBox() {
        this.setRenderer(new AutoCompleteListCellRenderer());
        final JTextComponent jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
        jTextComponent.setDocument(new AutoCompletingComboBoxDocument(this));
        jTextComponent.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
            }

            public void focusGained(FocusEvent focusEvent) {
                jTextComponent.selectAll();
            }
        });
    }

    @Override
    public void configureEditor(ComboBoxEditor comboBoxEditor, Object object) {
        if (object == null) {
            comboBoxEditor.setItem(null);
        } else if (object instanceof String) {
            comboBoxEditor.setItem(object);
        } else if (object instanceof AutoCompletionListItem) {
            comboBoxEditor.setItem(((AutoCompletionListItem)object).getValue());
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setSelectedItem(Object object) {
        if (object == null) {
            super.setSelectedItem(null);
        } else if (object instanceof AutoCompletionListItem) {
            super.setSelectedItem(object);
        } else if (object instanceof String) {
            String string = (String)object;
            for (int i = 0; i < this.getModel().getSize(); ++i) {
                AutoCompletionListItem autoCompletionListItem = (AutoCompletionListItem)this.getModel().getElementAt(i);
                if (!string.equals(autoCompletionListItem.getValue())) continue;
                super.setSelectedItem(autoCompletionListItem);
                return;
            }
            super.setSelectedItem(new AutoCompletionListItem(string, AutoCompletionItemPritority.UNKNOWN));
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void setPossibleItems(Collection<String> collection) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.getModel();
        Object object = this.getEditor().getItem();
        defaultComboBoxModel.removeAllElements();
        for (String string : collection) {
            defaultComboBoxModel.addElement(new AutoCompletionListItem(string, AutoCompletionItemPritority.UNKNOWN));
        }
        this.getEditor().setItem(object);
    }

    public void setPossibleACItems(Collection<AutoCompletionListItem> collection) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.getModel();
        Object object = this.getEditor().getItem();
        defaultComboBoxModel.removeAllElements();
        for (AutoCompletionListItem autoCompletionListItem : collection) {
            defaultComboBoxModel.addElement(autoCompletionListItem);
        }
        this.getEditor().setItem(object);
    }

    protected boolean isAutocompleteEnabled() {
        return this.autocompleteEnabled;
    }

    protected void setAutocompleteEnabled(boolean bl) {
        this.autocompleteEnabled = bl;
    }

    public class AutoCompleteListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public AutoCompleteListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            AutoCompletionListItem autoCompletionListItem = (AutoCompletionListItem)object;
            this.setText(autoCompletionListItem.getValue());
            return this;
        }
    }

    class AutoCompletingComboBoxDocument
    extends PlainDocument {
        private JComboBox comboBox;
        private boolean selecting = false;

        public AutoCompletingComboBoxDocument(JComboBox jComboBox) {
            this.comboBox = jComboBox;
        }

        public void remove(int n, int n2) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            super.remove(n, n2);
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            Object object;
            int n2;
            if (this.selecting || n == 0 && string.equals(this.getText(0, this.getLength()))) {
                return;
            }
            boolean bl = n == 0 && this.getLength() == 0 && string.length() > 1;
            super.insertString(n, string, attributeSet);
            if (this.selecting) {
                return;
            }
            if (!AutoCompletingComboBox.this.autocompleteEnabled) {
                return;
            }
            if (attributeSet != null && attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                return;
            }
            int n3 = this.getLength();
            int n4 = n2 = n + string.length();
            String string2 = this.getText(0, n3);
            if (Main.pref.getBoolean("autocomplete.dont_complete_numbers", true)) {
                try {
                    Long.parseLong(string);
                    if (string2.length() == 0) {
                        return;
                    }
                    Long.parseLong(string2);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Object object2 = this.lookupItem(string2);
            this.setSelectedItem(object2);
            if (bl) {
                n2 = 0;
            }
            if (object2 != null && !((String)(object = ((AutoCompletionListItem)object2).getValue())).equals(string2)) {
                this.selecting = true;
                super.remove(0, n3);
                super.insertString(0, (String)object, attributeSet);
                this.selecting = false;
                n2 = n3;
                n4 = this.getLength();
            }
            object = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
            ((JTextComponent)object).setSelectionStart(n2);
            ((JTextComponent)object).setSelectionEnd(n4);
        }

        private void setSelectedItem(Object object) {
            this.selecting = true;
            this.comboBox.setSelectedItem(object);
            this.selecting = false;
        }

        private Object lookupItem(String string) {
            ComboBoxModel comboBoxModel = this.comboBox.getModel();
            AutoCompletionListItem autoCompletionListItem = null;
            int n = comboBoxModel.getSize();
            for (int i = 0; i < n; ++i) {
                AutoCompletionListItem autoCompletionListItem2 = (AutoCompletionListItem)comboBoxModel.getElementAt(i);
                if (!autoCompletionListItem2.getValue().startsWith(string) || autoCompletionListItem != null && autoCompletionListItem2.getPriority().compareTo(autoCompletionListItem.getPriority()) <= 0) continue;
                autoCompletionListItem = autoCompletionListItem2;
            }
            return autoCompletionListItem;
        }
    }
}

