/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.html.HTMLEditorKit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.server.UserNameValidator;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.CredentialsManagerException;
import org.openstreetmap.josm.io.auth.CredentialsManagerFactory;
import org.openstreetmap.josm.io.auth.JosmPreferencesCredentialManager;
import org.openstreetmap.josm.tools.I18n;

public class BasicAuthenticationPreferencesPanel
extends JPanel {
    private JTextField tfOsmUserName;
    private UserNameValidator valUserName;
    private JPasswordField tfOsmPassword;

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 3);
        this.add((Component)new JLabel(I18n.tr("OSM username:")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.tfOsmUserName = new JTextField();
        this.add((Component)this.tfOsmUserName, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfOsmUserName);
        this.valUserName = new UserNameValidator(this.tfOsmUserName);
        this.valUserName.validate();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("OSM password:")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.tfOsmPassword = new JPasswordField();
        this.add((Component)this.tfOsmPassword, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfOsmPassword);
        this.tfOsmPassword.setToolTipText(I18n.tr("Please enter your OSM password"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.fill = 1;
        HtmlPanel htmlPanel = new HtmlPanel();
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)htmlPanel.getEditorPane().getEditorKit();
        hTMLEditorKit.getStyleSheet().addRule(".warning-body {background-color:rgb(253,255,221);padding: 10pt; border-color:rgb(128,128,128);border-style: solid;border-width: 1px;}");
        htmlPanel.setText(I18n.tr("<html><body><p class=\"warning-body\"><strong>Warning:</strong> The password is stored in plain text in the JOSM preferences file. Furthermore, it is transferred <strong>unencrypted</strong> in every request sent to the OSM server. <strong>Do not use a valuable password.</strong></p></body></html>"));
        this.add((Component)htmlPanel, gridBagConstraints);
    }

    public BasicAuthenticationPreferencesPanel() {
        this.build();
    }

    public void initFromPreferences() {
        CredentialsManager credentialsManager = CredentialsManagerFactory.getCredentialManager();
        try {
            PasswordAuthentication passwordAuthentication = credentialsManager.lookup(Authenticator.RequestorType.SERVER);
            if (passwordAuthentication == null) {
                this.tfOsmUserName.setText("");
                this.tfOsmPassword.setText("");
            } else {
                this.tfOsmUserName.setText(passwordAuthentication.getUserName() == null ? "" : passwordAuthentication.getUserName());
                this.tfOsmPassword.setText(passwordAuthentication.getPassword() == null ? "" : String.valueOf(passwordAuthentication.getPassword()));
            }
        }
        catch (CredentialsManagerException credentialsManagerException) {
            credentialsManagerException.printStackTrace();
            System.err.println(I18n.tr("Warning: failed to retrieve OSM credentials from credential manager."));
            System.err.println(I18n.tr("Current credential manager is of type ''{0}''", credentialsManager.getClass().getName()));
            this.tfOsmUserName.setText("");
            this.tfOsmPassword.setText("");
        }
    }

    public void saveToPreferences() {
        CredentialsManager credentialsManager = CredentialsManagerFactory.getCredentialManager();
        try {
            PasswordAuthentication passwordAuthentication = new PasswordAuthentication(this.tfOsmUserName.getText().trim(), this.tfOsmPassword.getPassword());
            credentialsManager.store(Authenticator.RequestorType.SERVER, passwordAuthentication);
            if (!(credentialsManager instanceof JosmPreferencesCredentialManager)) {
                Main.pref.put("osm-server.username", this.tfOsmUserName.getText().trim());
            }
        }
        catch (CredentialsManagerException credentialsManagerException) {
            credentialsManagerException.printStackTrace();
            System.err.println(I18n.tr("Warning: failed to save OSM credentials to credential manager."));
            System.err.println(I18n.tr("Current credential manager is of type ''{0}''", credentialsManager.getClass().getName()));
        }
    }

    public void clearPassword() {
        this.tfOsmPassword.setText("");
    }
}

