/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.properties;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.CoordinateConflictResolveCommand;
import org.openstreetmap.josm.command.DeletedStateConflictResolveCommand;
import org.openstreetmap.josm.command.PurgePrimitivesCommand;
import org.openstreetmap.josm.command.UndeletePrimitivesCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.properties.OperationCancelledException;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesMergeModel
extends Observable {
    public static final String RESOLVED_COMPLETELY_PROP = PropertiesMergeModel.class.getName() + ".resolvedCompletely";
    public static final String DELETE_PRIMITIVE_PROP = PropertiesMergeModel.class.getName() + ".deletePrimitive";
    private OsmPrimitive my;
    private LatLon myCoords;
    private LatLon theirCoords;
    private MergeDecisionType coordMergeDecision = MergeDecisionType.UNDECIDED;
    private boolean myDeletedState;
    private boolean theirDeletedState;
    private boolean myVisibleState;
    private boolean theirVisibleState;
    private List<OsmPrimitive> myReferrers;
    private List<OsmPrimitive> theirReferrers;
    private MergeDecisionType deletedMergeDecision = MergeDecisionType.UNDECIDED;
    private MergeDecisionType visibleMergeDecision;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean resolvedCompletely = false;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void fireCompletelyResolved() {
        boolean bl = this.resolvedCompletely;
        this.resolvedCompletely = this.isResolvedCompletely();
        this.support.firePropertyChange(RESOLVED_COMPLETELY_PROP, bl, this.resolvedCompletely);
    }

    public boolean isDecidedCoord() {
        return !this.coordMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
    }

    public boolean isDecidedDeletedState() {
        return !this.deletedMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
    }

    public boolean isDecidedVisibleState() {
        return !this.visibleMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
    }

    public boolean isCoordMergeDecision(MergeDecisionType mergeDecisionType) {
        return this.coordMergeDecision.equals((Object)mergeDecisionType);
    }

    public boolean isDeletedStateDecision(MergeDecisionType mergeDecisionType) {
        return this.deletedMergeDecision.equals((Object)mergeDecisionType);
    }

    public boolean isVisibleStateDecision(MergeDecisionType mergeDecisionType) {
        return this.visibleMergeDecision.equals((Object)mergeDecisionType);
    }

    public void populate(Conflict<? extends OsmPrimitive> conflict) {
        this.my = conflict.getMy();
        OsmPrimitive osmPrimitive = conflict.getTheir();
        if (this.my instanceof Node) {
            this.myCoords = ((Node)this.my).getCoor();
            this.theirCoords = ((Node)osmPrimitive).getCoor();
        } else {
            this.myCoords = null;
            this.theirCoords = null;
        }
        this.myDeletedState = conflict.isMyDeleted() || this.my.isDeleted();
        this.theirDeletedState = osmPrimitive.isDeleted();
        this.myVisibleState = this.my.isVisible();
        this.theirVisibleState = osmPrimitive.isVisible();
        this.myReferrers = this.my.getDataSet() == null ? Collections.emptyList() : this.my.getReferrers();
        this.theirReferrers = osmPrimitive.getDataSet() == null ? Collections.emptyList() : osmPrimitive.getReferrers();
        this.coordMergeDecision = MergeDecisionType.UNDECIDED;
        this.deletedMergeDecision = MergeDecisionType.UNDECIDED;
        this.visibleMergeDecision = MergeDecisionType.UNDECIDED;
        this.setChanged();
        this.notifyObservers();
        this.fireCompletelyResolved();
    }

    public LatLon getMyCoords() {
        return this.myCoords;
    }

    public LatLon getTheirCoords() {
        return this.theirCoords;
    }

    public LatLon getMergedCoords() {
        switch (this.coordMergeDecision) {
            case KEEP_MINE: {
                return this.myCoords;
            }
            case KEEP_THEIR: {
                return this.theirCoords;
            }
            case UNDECIDED: {
                return null;
            }
        }
        return null;
    }

    public void decideCoordsConflict(MergeDecisionType mergeDecisionType) {
        this.coordMergeDecision = mergeDecisionType;
        this.setChanged();
        this.notifyObservers();
        this.fireCompletelyResolved();
    }

    public Boolean getMyDeletedState() {
        return this.myDeletedState;
    }

    public Boolean getTheirDeletedState() {
        return this.theirDeletedState;
    }

    public Boolean getMergedDeletedState() {
        switch (this.deletedMergeDecision) {
            case KEEP_MINE: {
                return this.myDeletedState;
            }
            case KEEP_THEIR: {
                return this.theirDeletedState;
            }
            case UNDECIDED: {
                return null;
            }
        }
        return null;
    }

    public Boolean getMyVisibleState() {
        return this.myVisibleState;
    }

    public Boolean getTheirVisibleState() {
        return this.theirVisibleState;
    }

    public List<OsmPrimitive> getMyReferrers() {
        return this.myReferrers;
    }

    public List<OsmPrimitive> getTheirReferrers() {
        return this.theirReferrers;
    }

    public Boolean getMergedVisibleState() {
        switch (this.visibleMergeDecision) {
            case KEEP_MINE: {
                return this.myVisibleState;
            }
            case KEEP_THEIR: {
                return this.theirVisibleState;
            }
            case UNDECIDED: {
                return null;
            }
        }
        return null;
    }

    private boolean getMergedDeletedState(MergeDecisionType mergeDecisionType) {
        switch (mergeDecisionType) {
            case KEEP_MINE: {
                return this.myDeletedState;
            }
            case KEEP_THEIR: {
                return this.theirDeletedState;
            }
        }
        return false;
    }

    public void decideDeletedStateConflict(MergeDecisionType mergeDecisionType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)mergeDecisionType, "decision");
        boolean bl = this.getMergedDeletedState(this.deletedMergeDecision);
        boolean bl2 = this.getMergedDeletedState(mergeDecisionType);
        this.deletedMergeDecision = mergeDecisionType;
        this.setChanged();
        this.notifyObservers();
        this.fireCompletelyResolved();
        if (bl != bl2) {
            this.support.firePropertyChange(DELETE_PRIMITIVE_PROP, bl, bl2);
        }
    }

    public void decideVisibleStateConflict(MergeDecisionType mergeDecisionType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)mergeDecisionType, "decision");
        this.visibleMergeDecision = mergeDecisionType;
        this.setChanged();
        this.notifyObservers();
        this.fireCompletelyResolved();
    }

    public boolean hasCoordConflict() {
        if (this.myCoords == null && this.theirCoords != null) {
            return true;
        }
        if (this.myCoords != null && this.theirCoords == null) {
            return true;
        }
        if (this.myCoords == null && this.theirCoords == null) {
            return false;
        }
        return !this.myCoords.equalsEpsilon(this.theirCoords);
    }

    public boolean hasDeletedStateConflict() {
        return this.myDeletedState != this.theirDeletedState;
    }

    public boolean hasVisibleStateConflict() {
        return this.myVisibleState != this.theirVisibleState;
    }

    public boolean isResolvedCompletely() {
        boolean bl = true;
        if (this.hasCoordConflict()) {
            boolean bl2 = bl = bl && !this.coordMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
        }
        if (this.hasDeletedStateConflict()) {
            boolean bl3 = bl = bl && !this.deletedMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
        }
        if (this.hasVisibleStateConflict()) {
            bl = bl && !this.visibleMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
        }
        return bl;
    }

    public List<Command> buildResolveCommand(Conflict<? extends OsmPrimitive> conflict) throws OperationCancelledException {
        OsmPrimitive osmPrimitive = conflict.getMy();
        ArrayList<Command> arrayList = new ArrayList<Command>();
        if (this.hasVisibleStateConflict() && this.isDecidedVisibleState()) {
            if (this.isVisibleStateDecision(MergeDecisionType.KEEP_MINE)) {
                try {
                    UndeletePrimitivesCommand undeletePrimitivesCommand = this.createUndeletePrimitiveCommand(osmPrimitive);
                    if (undeletePrimitivesCommand == null) {
                        throw new OperationCancelledException();
                    }
                    arrayList.add(undeletePrimitivesCommand);
                }
                catch (OsmTransferException osmTransferException) {
                    this.handleExceptionWhileBuildingCommand(osmTransferException);
                    throw new OperationCancelledException(osmTransferException);
                }
            } else if (this.isVisibleStateDecision(MergeDecisionType.KEEP_THEIR)) {
                arrayList.add(new PurgePrimitivesCommand(osmPrimitive));
            }
        }
        if (this.hasCoordConflict() && this.isDecidedCoord()) {
            arrayList.add(new CoordinateConflictResolveCommand(conflict, this.coordMergeDecision));
        }
        if (this.hasDeletedStateConflict() && this.isDecidedDeletedState()) {
            arrayList.add(new DeletedStateConflictResolveCommand(conflict, this.deletedMergeDecision));
        }
        return arrayList;
    }

    public OsmPrimitive getMyPrimitive() {
        return this.my;
    }

    protected void handleExceptionWhileBuildingCommand(Exception exception) {
        exception.printStackTrace();
        String string = exception.getMessage() != null ? exception.getMessage() : exception.toString();
        string = string.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>An error occurred while communicating with the server<br>Details: {0}</html>", string), I18n.tr("Communication with server failed"), 0);
    }

    protected UndeletePrimitivesCommand createUndeletePrimitiveCommand(OsmPrimitive osmPrimitive) throws OsmTransferException {
        if (osmPrimitive instanceof Node) {
            return this.createUndeleteNodeCommand((Node)osmPrimitive);
        }
        if (osmPrimitive instanceof Way) {
            return this.createUndeleteWayCommand((Way)osmPrimitive);
        }
        if (osmPrimitive instanceof Relation) {
            return this.createUndeleteRelationCommand((Relation)osmPrimitive);
        }
        return null;
    }

    protected UndeletePrimitivesCommand createUndeleteNodeCommand(Node node) {
        return new UndeletePrimitivesCommand((OsmPrimitive)node);
    }

    protected boolean confirmUndeleteDependentPrimitives(Way way, ArrayList<OsmPrimitive> arrayList) {
        Object[] objectArray = new String[]{I18n.tr("Yes, undelete them too"), I18n.tr("No, cancel operation")};
        int n = JOptionPane.showOptionDialog(Main.parent, "<html>" + I18n.trn("There is {0} additional node used by way {1}<br>which is deleted on the server.<br><br>Do you want to undelete this node too?", "There are {0} additional nodes used by way {1}<br>which are deleted on the server.<br><br>Do you want to undelete these nodes too?", arrayList.size(), arrayList.size(), way.getId()) + "</html>", I18n.tr("Undelete additional nodes?"), 0, 3, null, objectArray, objectArray[0]);
        switch (n) {
            case -1: {
                return false;
            }
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    protected boolean confirmUndeleteDependentPrimitives(Relation relation, ArrayList<OsmPrimitive> arrayList) {
        Object[] objectArray = new String[]{I18n.tr("Yes, undelete them too"), I18n.tr("No, cancel operation")};
        int n = JOptionPane.showOptionDialog(Main.parent, "<html>" + I18n.trn("There is {0} additional primitive referred to by relation {1}<br>which is deleted on the server.<br><br>Do you want to undelete this too?", "There are {0} additional primitives referred to by relation {1}<br>which are deleted on the server.<br><br>Do you want to undelete these too?", arrayList.size(), arrayList.size(), relation.getId()) + "</html>", I18n.tr("Undelete dependent primitives?"), 0, 3, null, objectArray, objectArray[0]);
        switch (n) {
            case -1: {
                return false;
            }
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    protected UndeletePrimitivesCommand createUndeleteWayCommand(Way way) throws OsmTransferException {
        HashMap<Long, Node> hashMap = new HashMap<Long, Node>();
        for (Node object2 : way.getNodes()) {
            if (object2.isNew() || hashMap.values().contains(object2)) continue;
            hashMap.put(object2.getId(), object2);
        }
        MultiFetchServerObjectReader multiFetchServerObjectReader = new MultiFetchServerObjectReader();
        multiFetchServerObjectReader.append(hashMap.values());
        DataSet dataSet = multiFetchServerObjectReader.parseOsm(NullProgressMonitor.INSTANCE);
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : dataSet.allPrimitives()) {
            if (!hashMap.keySet().contains(osmPrimitive.getId()) || osmPrimitive.isVisible()) continue;
            arrayList.add((OsmPrimitive)hashMap.get(osmPrimitive.getId()));
        }
        if (!arrayList.isEmpty() && !this.confirmUndeleteDependentPrimitives(way, arrayList)) {
            return null;
        }
        arrayList.add(way);
        return new UndeletePrimitivesCommand(arrayList);
    }

    protected UndeletePrimitivesCommand createUndeleteRelationCommand(Relation relation) throws OsmTransferException {
        HashMap<Long, OsmPrimitive> hashMap = new HashMap<Long, OsmPrimitive>();
        for (RelationMember object2 : relation.getMembers()) {
            if (object2.getMember().isNew() || hashMap.values().contains(object2.getMember())) continue;
            hashMap.put(object2.getMember().getId(), object2.getMember());
        }
        MultiFetchServerObjectReader multiFetchServerObjectReader = new MultiFetchServerObjectReader();
        multiFetchServerObjectReader.append(hashMap.values());
        DataSet dataSet = multiFetchServerObjectReader.parseOsm(NullProgressMonitor.INSTANCE);
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : dataSet.allPrimitives()) {
            if (!hashMap.keySet().contains(osmPrimitive.getId()) || osmPrimitive.isVisible()) continue;
            arrayList.add((OsmPrimitive)hashMap.get(osmPrimitive.getId()));
        }
        if (!arrayList.isEmpty() && !this.confirmUndeleteDependentPrimitives(relation, arrayList)) {
            return null;
        }
        arrayList.add(relation);
        return new UndeletePrimitivesCommand(arrayList);
    }
}

